import React, { useEffect, useState } from 'react';
import * as z from 'zod';
import { Link, useNavigate, useParams } from 'react-router-dom';
import PropertyDetail from '@/components/Elements/Loader/PropertyDetail';
import { useBusinessDetails } from '@/api/commonDetail/getBusinessDetail';
import OwlCarousel from 'react-owl-carousel';
import 'owl.carousel/dist/assets/owl.carousel.css';
import 'owl.carousel/dist/assets/owl.theme.default.css';
import './Carousel.css';
import GoogleMapReact from 'google-map-react';
import destination from '@/assets/destination.png';
import rental from '@/assets/rental.png';
import vision from '@/assets/vision.png';
import cashFlow from '@/assets/cashFlow.png';
import cpital from '@/assets/cpital.png';
import cost from '@/assets/cost.png';
import { Form, InputField } from '@/components/Form';
import { Button } from '@/components/Elements';
import { inquiryPropertyProject } from '@/api/propertyProject/inquiryPropertyProject';
import propertyCategory from '@/constants/propertyCategory';
import { useNotificationStore } from '@/stores/notifications';
import { useAuth } from '@/lib/auth';
import icon1 from '@/assets/icon1.png';
import icon2 from '@/assets/icon2.png';
import icon3 from '@/assets/icon3.png';
import li6 from '@/assets/money.png';
import li7 from '@/assets/li7.svg';
useState;
import List from '@material-ui/core/List';
import ListItem from '@material-ui/core/ListItem';
import ListItemAvatar from '@material-ui/core/ListItemAvatar';
import Avatar from '@material-ui/core/Avatar';
import ListItemText from '@material-ui/core/ListItemText';

import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import FsImageOpner from '@/components/FsImageOpner/FsImageOpner';
import storage from '@/utils/storage';
import i18next from 'i18next';
import { translateAmenties } from '@/translations/translateFunction';

function PropertyContent() {
  const AnyReactComponent = ({ text }: { text: any }) => <div>{text}</div>;
  const auth = useAuth();
  const loggedinId = auth.user?.customer_id;
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { id } = useParams();
  const searchParams = new URLSearchParams(document.location.search);
  const typeVal = searchParams.get('type');
  const { data, isLoading } = useBusinessDetails({ id: id ?? '2' });
  const customerId = data?.data?.customer_id;
  const navigate = useNavigate();
  const property = data?.data;
  const [iLat, setiLat] = useState(0);
  const [iLong, setiLong] = useState(0);
  useEffect(() => {
    if (property) {
      const parsedLat = parseFloat(property.latitude);
      const parsedLong = parseFloat(property.longitude);

      if (!isNaN(parsedLat) && !isNaN(parsedLong)) {
        setiLat(parsedLat);
        setiLong(parsedLong);
      } else {
        console.error('Invalid latitude or longitude values');
      }
    }
  }, [property]);
  const categoryVal = property?.category;
  const amenitiesValues = property?.amenities ?? '';
  const amenitiesArray = amenitiesValues.split(',');

  const schema = z.object({
    name: z.string().min(1, 'Please enter your full name'),
    email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
    telephone: z.custom(isValidMobile, isValidMobileMsg),
    message: z.string().min(1, 'Please enter a message'),
    company_name: z.string().min(1, 'Please enter a Company Name'),
  });

  type inquiryAd = {
    name: string;
    telephone: string;
    email: string;
    message: string;
    company_name: string;
  };
  const [loading, setLoading] = useState(false);
  const [toggler, setToggler] = useState<boolean>(false);
  const [pics, setPics] = useState([]);
  const [productIndex, setProductIndex] = useState(0);

  const handleSubmit = async (values: inquiryAd) => {
    try {
      setLoading(true);

      await inquiryPropertyProject({
        ...values,
        project_id: `${id}`,
        type: `${typeVal}`,
        id: `${id}`,
      });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'info',
        message: 'Inquiry Sent successfully!',
      });
    } finally {
      setLoading(false);
      localStorage.removeItem('values');
    }
  };

  const options = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    rewind: true,
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 1,
      },
      600: {
        items: 1,
      },
      700: {
        items: 1,
      },
      1000: {
        items: 1,
      },
    },
  };
  const optionsCar = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    rewind: true,
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 2,
      },
      400: {
        items: 3,
      },
      600: {
        items: 4,
      },
      700: {
        items: 5,
      },
      1000: {
        items: 5,
      },
    },
  };
  const optionsThree = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    rewind: true,
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 1,
      },
      400: {
        items: 2,
      },
      600: {
        items: 2,
      },
      700: {
        items: 3,
      },
      1000: {
        items: 3,
      },
    },
  };

  useEffect(() => {
    eval(property?.image_data)?.map((val) => {
      setPics((item) => [...item, val?.image]);
    });
  }, [isLoading, loading]);

  const handleToggler = (index: number) => {
    setToggler(true);
    setProductIndex(index);
  };

  const [isLightboxOpen, setIsLightboxOpen] = useState(false);

  useEffect(() => {
    setToggler(false);
  }, [isLightboxOpen]);

  return (
    <>
      {isLoading || loading ? (
        <PropertyDetail />
      ) : (
        <div className="Content project-prop-details">
          {eval(property?.image_data)?.length == 0 ? null : (
            <>
              <div className="container ">
                <div className="row">
                  <div className="col-md-12 col-12">
                    <div className="propertyCarousel noter prop-cont">
                      <OwlCarousel {...options} className="owl-theme" loop nav>
                        {eval(property?.image_data)?.map((item: any, index: number) => (
                          <div key={index}>
                            <div className="item">
                              {item?.name && <span className="imageNames">{item?.name}</span>}
                              <img alt="hias" src={item?.image} />
                            </div>
                          </div>
                        ))}
                      </OwlCarousel>
                    </div>
                  </div>

                  <div className="col-md-12 col-12 row picsfor fiveBOxes prop-content">
                    {property?.image_data?.length <= 4 ? (
                      <>
                        {eval(property?.image_data)
                          .slice(0, 4)
                          .map((item: any, index: number) => (
                            <div className="col-md-3 col-6" key={index}>
                              <img
                                alt="hixas"
                                src={item?.image}
                                onClick={() => handleToggler(index)}
                              />
                            </div>
                          ))}
                      </>
                    ) : (
                      <OwlCarousel {...optionsCar} className="owl-theme" loop nav>
                        {eval(property?.image_data)?.map((item: any, index: number) => {
                          return (
                            <div key={index}>
                              <div className="item">
                                <img
                                  alt="hias"
                                  src={item?.image}
                                  onClick={() => handleToggler(index)}
                                />
                              </div>
                            </div>
                          );
                        })}
                      </OwlCarousel>
                    )}
                  </div>

                  <FsImageOpner
                    pics={pics}
                    index={productIndex}
                    show={toggler}
                    setIsLightboxOpen={setIsLightboxOpen}
                  />
                </div>
              </div>
            </>
          )}

          <section className="proprty-name-row bg-light-pink mt-5">
            <div className="container">
              <div className="row col-12 propertyName main-prop-wrapper">
                <div className="col-md-12 col-12 left-columns">
                  <p className="property-name dark-color">{property?.property_name}</p>
                  <p className="property-category mb-1">
                    {Object.entries(propertyCategory)?.map(([key, val], i) => (
                      <span key={i}>{key == categoryVal ? val : null}</span>
                    ))}
                  </p>

                  <h3 className="money">
                    {localSymbol} {(property?.price * localCurrency).toFixed(0)}
                  </h3>
                  <div className="facilities">
                    <div className="faciltiy-1">
                      <img src={icon1} alt="pay1" />
                      <span>
                        {' '}
                        {property?.bathroom} {i18next.t('Baths')}
                      </span>
                    </div>
                    <div className="faciltiy-1">
                      <img src={icon2} alt="pay1" />
                      <span>
                        {' '}
                        {property?.bedroom} {i18next.t('Beds')}
                      </span>
                    </div>
                    <div className="faciltiy-1">
                      <img src={icon3} alt="pay1" />
                      <span>
                        {property?.size} {i18next.t('Sq.Ft')}.
                      </span>
                    </div>
                  </div>
                  <hr />

                  <div className="fiveBOxes">
                    <OwlCarousel {...optionsThree} className="owl-theme" loop nav>
                      <div className="itemsNew">
                        <div className="insBox">
                          <p className="pp1 mb-1">
                            <i className="fa-solid fa-map-pin"></i>
                          </p>
                          <p className="pp2 mb-1"> House number </p>
                          <p className="pp3 mb-1">{property?.house_number}</p>
                        </div>
                      </div>
                      <div className="itemsNew">
                        <div className="insBox">
                          <p className="pp1 mb-1">
                            <i className="fa-solid fa-map-location-dot"></i>
                          </p>
                          <p className="pp2 mb-1"> {i18next.t('Town')} </p>
                          <p className="pp3 mb-1">{property?.town}</p>
                        </div>
                      </div>
                      <div className="itemsNew">
                        <div className="insBox">
                          <p className="pp1 mb-1">
                            <i className="fa-solid fa-location-dot"></i>
                          </p>
                          <p className="pp2 mb-1"> {i18next.t('Postal Code')} </p>
                          <p className="pp3 mb-1">{property?.postal_code}</p>
                        </div>
                      </div>
                      <div className="itemsNew">
                        <div className="insBox">
                          <p className="pp1 mb-1">
                            <i className="fa-solid fa-phone-volume"></i>
                          </p>
                          <p className="pp2 mb-1">{i18next.t('Phone')} </p>
                          <p className="pp3 mb-1">{property?.phone_number}</p>
                        </div>
                      </div>
                      <Link to={property?.youtube_url ?? ''}>
                        <div className="itemsNew">
                          <div className="insBox">
                            <p className="pp1 mb-1">
                              <i className="fa-brands fa-youtube"></i>
                            </p>
                            <p className="pp2 mb-1">{i18next.t('Watch Video')} </p>
                          </div>
                        </div>
                      </Link>
                    </OwlCarousel>
                  </div>
                  <List className="listDetail prop-list-li">
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary="Return on Investment" />
                      <ListItemText
                        className="secondss"
                        primary={(property?.return_on_investment * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary={i18next.t('Cashflow PCM')} />
                      <ListItemText
                        className="secondss"
                        primary={(property?.cashflow_pcm * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary="Finder Fee" />
                      <ListItemText
                        className="secondss"
                        primary={(property?.finder_fees * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary={i18next.t('Total Closing Fee')} />
                      <ListItemText
                        className="secondss"
                        primary={(property?.total_closing_fees * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary={i18next.t('Gross Income')} />
                      <ListItemText
                        className="secondss"
                        primary={(property?.gross_income * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary="Rent To LandLoard" />
                      <ListItemText
                        className="secondss"
                        primary={(property?.rent_to_landlord * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary="Price" />
                      <ListItemText
                        className="secondss"
                        primary={(property?.price * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                    <ListItem>
                      <ListItemAvatar>
                        <Avatar>
                          <img src={li6} className="priceIcons" alt="pay1" />
                        </Avatar>
                      </ListItemAvatar>
                      <ListItemText primary="Bill Utilites" />
                      <ListItemText
                        className="secondss"
                        primary={(property?.bill_utilites * localCurrency).toFixed(0)}
                      />
                    </ListItem>
                  </List>
                  <div className="row place-offers-rw">
                    <div className="main-datas  col-12 col-md-12 ">
                      <div className="cardss w-100">
                        <span className="titleHeader">{i18next.t('What this place offers')} </span>
                        <div className="right-div aps row">
                          <div className="col-md-4 col-12">
                            <div className="place-offers-maincol">
                              <p>
                                {amenitiesArray.includes('Garden_view') ? (
                                  <>
                                    <i className="fa-solid fa-tree"></i>
                                    {i18next.t('Garden View')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Kitchen') ? (
                                  <>
                                    <i className="fa-solid fa-kitchen-set"></i>{' '}
                                    {i18next.t('Kitchen')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Linens') ? (
                                  <>
                                    <i className="fa-solid fa-shirt"></i> {i18next.t('Linens')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('tv') ? (
                                  <>
                                    <i className="fa-solid fa-tv"></i> {i18next.t('Telivision')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Extra_Chairs') ? (
                                  <>
                                    <i className="fa-solid fa-chair"></i> {i18next.t('Extra Chair')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Balcony') ? (
                                  <>
                                    <i className="fa-solid fa-door-open"></i> {i18next.t('Balcony')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Fitness_Centre') ? (
                                  <>
                                    <i className="fa-solid fa-dumbbell"></i>{' '}
                                    {i18next.t('Fitness Centre')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Wood_style_flooring') ? (
                                  <>
                                    <i className="fa-solid fa-house"></i>{' '}
                                    {i18next.t('Wood-Style Flooring')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Laundry_facility') ? (
                                  <>
                                    <i className="fa-solid fa-jug-detergent"></i>{' '}
                                    {i18next.t('Laundry Facility')}
                                  </>
                                ) : null}
                              </p>
                            </div>
                          </div>
                          <div className="col-md-4 col-12">
                            <div className="place-offers-maincol">
                              <p>
                                {' '}
                                {amenitiesArray.includes('Window_ac_unit') ? (
                                  <>
                                    <i className="fa-solid fa-temperature-low"></i>{' '}
                                    {i18next.t('Window Ac')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Pets_Allowed') ? (
                                  <>
                                    <i className="fa-solid fa-dog"></i> {i18next.t('Pets Allowed')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Dedicated_Workspace') ? (
                                  <>
                                    <i className="fa-solid fa-briefcase"></i>
                                    {i18next.t('Work Space')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes(' Extra_Pillows_And_Blankets') ? (
                                  <>
                                    <i className="fa-solid fa-mattress-pillow"></i>{' '}
                                    {i18next.t('Extra Pillow And Blanket')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Extra_bed') ? (
                                  <>
                                    <i className="fa-solid fa-bed"></i> {i18next.t('Extra Bed')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Smart_Home') ? (
                                  <>
                                    <i className="fa-solid fa-house-signal"></i>{' '}
                                    {i18next.t('Smart Home')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Play_Ground') ? (
                                  <>
                                    <i className="fa-solid fa-football"></i>{' '}
                                    {i18next.t('Playground')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Dinnig_Room') ? (
                                  <>
                                    <i className="fa-solid fa-utensils"></i>{' '}
                                    {i18next.t('Dinning Room')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Spa') ? (
                                  <>
                                    <i className="fa-solid fa-hot-tub-person"></i>{' '}
                                    {i18next.t('Spa')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Large_windows') ? (
                                  <>
                                    <i className="fa-solid fa-house-chimney-window"></i>{' '}
                                    {i18next.t('Large Windows')}
                                  </>
                                ) : null}
                              </p>
                            </div>
                          </div>
                          <div className="col-md-4 col-12">
                            <div className="place-offers-maincol">
                              <p>
                                {' '}
                                {amenitiesArray.includes('Charger') ? (
                                  <>
                                    <i className="fa-solid fa-bolt"></i> {i18next.t('Charger')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Candels') ? (
                                  <>
                                    <i className="fa-solid fa-hanukiah"></i> {i18next.t('Candels')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Utensils') ? (
                                  <>
                                    <i className="fa-solid fa-utensils"></i> {i18next.t('Utensils')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {' '}
                                {amenitiesArray.includes('Bath_Tub') ? (
                                  <>
                                    <i className="fa-solid fa-bath"></i> {i18next.t('Bath Tub')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Hair_Chair') ? (
                                  <>
                                    <i className="fa-solid fa-couch"></i> {i18next.t('Couch')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Games_Room') ? (
                                  <>
                                    <i className="fa-solid fa-table-tennis-paddle-ball"></i>{' '}
                                    {i18next.t('Games Room')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Parking_lots') ? (
                                  <>
                                    <i className="fa-solid fa-car"></i> {i18next.t('Parking lots')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Keyless_electronic_unit') ? (
                                  <>
                                    <i className="fa-solid fa-unlock-keyhole"></i>{' '}
                                    {i18next.t('Keyless Electronic Unit')}
                                  </>
                                ) : null}
                              </p>
                              <p>
                                {amenitiesArray.includes('Nearby_supermarkets') ? (
                                  <>
                                    <i className="fa-solid fa-cart-shopping"></i>{' '}
                                    {i18next.t('Nearby Supermarkets')}
                                  </>
                                ) : null}
                              </p>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div className="col-12 col-md-12 gmaps">
                      <div style={{ height: '300px', width: '100%' }}>
                        <GoogleMapReact
                          bootstrapURLKeys={{ key: process.env.REACT_APP_GOOGLE_MAPS_API_KEY }}
                          defaultCenter={{ lat: iLat, lng: iLong }}
                          defaultZoom={13}
                        >
                          <AnyReactComponent
                            lat={iLat}
                            lng={iLong}
                            text={<i className="fa-sharp fa-solid fa-location-dot googleEarth"></i>}
                          />
                        </GoogleMapReact>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="main-datas propert-details d-block col-12 col-md-4">
                  <div>
                    {/* <div className="cardss iqforms">
                      <div className="inquireformhover">
                        <fieldset disabled={loggedinId === customerId}>
                          <Form<inquiryAd> onSubmit={handleSubmit} schema={schema}>
                            {({ register, formState }) => (
                              <>
                                <InputField
                                  label={i18next.t('Name')}
                                  error={formState.errors['name']}
                                  registration={register('name')}
                                />
                                <InputField
                                  label="Company Name"
                                  error={formState.errors['company_name']}
                                  registration={register('company_name')}
                                />
                                <InputPhone
                                  floating
                                  error={formState.errors['telephone']}
                                  registration={register('telephone')}
                                />
                                <InputField
                                  label="Email"
                                  error={formState.errors['email']}
                                  registration={register('email')}
                                />
                                <InputField
                                  label={i18next.t('Message')}
                                  error={formState.errors['message']}
                                  registration={register('message')}
                                />
                                {loggedinId === customerId && (
                                  <p className="messages">You are owner of this Property</p>
                                )}

                                <div className="iq-div">
                                  <Button type="submit" className="iq-btn dark-btn">
                                  {i18next.t('Inquire Now')}
                                  </Button>
                                </div>
                              </>
                            )}
                          </Form>
                        </fieldset>
                      </div>
                    </div> */}
                  </div>
                  {/* <div className="col-12 col-md-12 gmaps">
                    <div style={{ height: '300px', width: '100%' }}>
                      <GoogleMapReact
                        bootstrapURLKeys={{ key: '' }}
                        defaultCenter={defaultProps.center}
                        defaultZoom={defaultProps.zoom}
                      >
                        <AnyReactComponent lat={59.955413} lng={30.337844} text="My Marker" />
                      </GoogleMapReact>
                    </div>
                  </div> */}
                </div>
              </div>
            </div>
          </section>
          <div className="property-details-tabs">
            <div className="container">
              {/* <Tabs items={getTabs()} /> */}
              {/* vertical tabs */}
              <div className="company-categories  mb-5 pt-3">
                <div className="row">
                  <div className="col-12 col-md-4 col-lg-3">
                    {/* <h5 className="underlined-title f-26 semi-bold mb-4">Categories</h5> */}

                    <div
                      className="nav flex-column nav-pills me-3"
                      id="v-pills-tab"
                      role="tablist"
                      aria-orientation="vertical"
                    >
                      <button
                        className="nav-link active"
                        id="v-pills-descript-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-descript"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-descript"
                        aria-selected="true"
                      >
                        {translateAmenties('Property Description')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-rental-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-rental"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-rental"
                        aria-selected="false"
                      >
                        {translateAmenties('Rental')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-cashflow-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-cashflow"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-cashflow"
                        aria-selected="false"
                      >
                        {translateAmenties('Cashflow Forecast')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-cost-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-cost"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-cost"
                        aria-selected="false"
                      >
                        {translateAmenties('Cost To Consider')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-capital-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-capital"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-capital"
                        aria-selected="false"
                      >
                        {translateAmenties('Capital Required')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-vision-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-vision"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-vision"
                        aria-selected="false"
                      >
                        {translateAmenties('Vision')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-disclaim-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-disclaim"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-disclaim"
                        aria-selected="false"
                      >
                        {translateAmenties('Disclaimer')}
                      </button>
                      <button
                        className="nav-link"
                        id="v-pills-info-tab"
                        data-bs-toggle="pill"
                        data-bs-target="#v-pills-info"
                        type="button"
                        role="tab"
                        aria-controls="v-pills-info"
                        aria-selected="false"
                      >
                        {translateAmenties('Property Information')}
                      </button>
                    </div>
                    {loggedinId === customerId ? null : (
                      <div className="profileFoto outlets pt-0 pb-3 mt-4">
                        <div className="mainDIv card">
                          <div className="topPics">
                            <img src={li7} alt="picture" />
                          </div>

                          <div className="midData text-center">
                            <h5 className="mb-0">{i18next.t('User Name')}</h5>
                            <p className="mb-0">User bio </p>
                          </div>

                          <div className="bottomButn">
                            <Button onClick={() => navigate(`/profile-details?id=${customerId}`)}>
                              {i18next.t(' View Profile')}
                            </Button>
                          </div>
                        </div>
                      </div>
                    )}
                  </div>
                  <div className="col-12 col-md-8 col-lg-9">
                    <div className="tab-content" id="v-pills-tabContent">
                      {/* First tab descript */}
                      <div
                        className="tab-pane fade show active"
                        id="v-pills-descript"
                        role="tabpanel"
                        aria-labelledby="v-pills-descript-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={destination} alt="sds" />
                          <span
                            dangerouslySetInnerHTML={{
                              __html: `${property?.property_description}`,
                            }}
                          />
                        </div>
                      </div>
                      {/* First tab descript ends */}
                      {/* Second tab rental */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-rental"
                        role="tabpanel"
                        aria-labelledby="v-pills-rental-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={rental} alt="sds" />
                          <span dangerouslySetInnerHTML={{ __html: `${property?.rental}` }} />
                        </div>
                      </div>
                      {/* Second tab rental  ends */}
                      {/* Third tab Cashflow */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-cashflow"
                        role="tabpanel"
                        aria-labelledby="v-pills-cashflow-tab"
                      >
                        <div className="business-plans">
                          <img className="propImages" src={cashFlow} alt="sds" />
                          <span
                            dangerouslySetInnerHTML={{ __html: `${property?.cashflow_forecast}` }}
                          />
                        </div>
                      </div>
                      {/* Third tab Cashflow ends */}
                      {/* 4rth tab cost */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-cost"
                        role="tabpanel"
                        aria-labelledby="v-pills-cost-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={cost} alt="sds" />{' '}
                          <span
                            dangerouslySetInnerHTML={{ __html: `${property?.costs_to_consider}` }}
                          />
                        </div>
                      </div>
                      {/* 4rth tab cost  ends*/}
                      {/* 5th tab capital */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-capital"
                        role="tabpanel"
                        aria-labelledby="v-pills-capital-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={cpital} alt="sds" />{' '}
                          <span
                            dangerouslySetInnerHTML={{ __html: `${property?.capital_required}` }}
                          />
                        </div>
                      </div>
                      {/* 5th tab capital  ends*/}
                      {/* 6th tab vision */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-vision"
                        role="tabpanel"
                        aria-labelledby="v-pills-vision-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={vision} alt="sds" />{' '}
                          <span dangerouslySetInnerHTML={{ __html: `${property?.vision}` }} />
                        </div>
                      </div>
                      {/* 6th tab vision  ends*/}
                      {/* 7th tab disclaim */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-disclaim"
                        role="tabpanel"
                        aria-labelledby="v-pills-disclaim-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={vision} alt="sds" />{' '}
                          <span dangerouslySetInnerHTML={{ __html: `${property?.disclaimer}` }} />
                        </div>
                      </div>
                      {/* 7th tab disclaim  ends*/}
                      {/* 8th tab info */}
                      <div
                        className="tab-pane fade"
                        id="v-pills-info"
                        role="tabpanel"
                        aria-labelledby="v-pills-info-tab"
                      >
                        <div className="overview-tab-cnt">
                          <img className="propImages" src={vision} alt="sds" />{' '}
                          <span
                            dangerouslySetInnerHTML={{
                              __html: `${property?.property_information}`,
                            }}
                          />
                        </div>
                      </div>
                      {/* 8th tab info  ends*/}
                    </div>
                    <div>
                      <div className="cardss iqforms mt-4">
                        <div className="inquireformhover">
                          <fieldset disabled={loggedinId === customerId}>
                            <Form<inquiryAd> onSubmit={handleSubmit} schema={schema}>
                              {({ register, formState }) => (
                                <>
                                  <InputField
                                    label={translateAmenties('Name')}
                                    error={formState.errors['name']}
                                    registration={register('name')}
                                  />
                                  <InputField
                                    label={translateAmenties('Company Name')}
                                    error={formState.errors['company_name']}
                                    registration={register('company_name')}
                                  />
                                  <InputPhone
                                    floating
                                    error={formState.errors['telephone']}
                                    registration={register('telephone')}
                                  />
                                  <InputField
                                    label={translateAmenties('Email')}
                                    error={formState.errors['email']}
                                    registration={register('email')}
                                  />
                                  <InputField
                                    label={translateAmenties('Message')}
                                    error={formState.errors['message']}
                                    registration={register('message')}
                                  />
                                  {loggedinId === customerId && (
                                    <p className="messages">You are owner of this Property</p>
                                  )}

                                  <div className="iq-div">
                                    <Button type="submit" className="iq-btn dark-btn">
                                      {translateAmenties('Inquire Now')}
                                    </Button>
                                  </div>
                                </>
                              )}
                            </Form>
                          </fieldset>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      )}
    </>
  );
}

export default PropertyContent;
