import nextArrow from '@/assets/arrowNext.png';
import { Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import React, { useState } from 'react';
import { z } from 'zod';
import { SingleImageUploder } from '@/components/Elements/upload/SingleImageUploader';
import subCatagories from '@/config/subcatagories';
import { InputPhone } from '@/components/Form/InputPhone';
import { LocationInput } from '@/components/Elements/map/MapMarker';
const schema = z.object({
  short_title: z.string().min(1, 'This field is required.'),
  phone_number: z.string().min(10, 'Phone number must be at least 10 digits'),
  region: z.string().min(1, 'This field is required.'),
  property_name: z.string().min(1, 'This field is required.'),
  house_number: z.string().min(1, 'This field is required.'),
  postal_code: z.string().min(1, 'This field is required.'),
  property_dimension: z.string().min(1, 'This field is required.'),
  price: z.string().min(1, 'This field is required.'),
  sub_category: z.string().min(1, 'This field is required.'),
  location: z.string().min(1, 'This field is required.'),
});
type FormData = z.infer<typeof schema>;
const StepFirst = ({ formData, setFormData, onNext }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const [cordinates, setCordinates] = useState({
    latitude: 0,
    longitude: 0,
  });
  const handdleLocationChnage = (details: {
    address: string;
    location: number[];
    lat: number;
    long: number;
  }) => {
    setCordinates({ latitude: details?.lat, longitude: details?.long });
  };
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media, ...cordinates };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Property Information
          </button>
          <button
            className={`tab-button ${activeTab === 'address' ? 'active' : ''}`}
            onClick={() => handleTabClick('address')}
          >
            Address
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Property Information</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-3">
                      <div className="form-block d-flex flex-column gap-2">
                        <TextAreaField
                          rows={4}
                          error={formState.errors['short_title']}
                          registration={register('short_title')}
                          label="Short Title"
                        />
                        <SingleImageUploder
                          src={media?.image_data}
                          setImage={(img) => handdleMediaChange(img, 'image_data')}
                          labbel="Property Images"
                        />
                        <SingleImageUploder
                          src={media?.videos}
                          setImage={(img) => handdleMediaChange(img, 'videos')}
                          labbel="Property Videos"
                        />
                        <SingleImageUploder
                          src={media?.property_document}
                          setImage={(img) => handdleMediaChange(img, 'property_document')}
                          labbel="Property Documents"
                        />
                      </div>
                    </div>

                    <div className="col-md-9">
                      {activeTab === 'propertyInfo' && (
                        <div className="form-block d-flex flex-column gap-2">
                          <InputField
                            label="Property Name"
                            error={formState.errors['property_name']}
                            registration={register('property_name')}
                          />

                          <InputField
                            label="House Number"
                            error={formState.errors['house_number']}
                            registration={register('house_number')}
                          />

                          <InputField
                            label="Postal Code"
                            error={formState.errors['postal_code']}
                            registration={register('postal_code')}
                          />

                          <InputField
                            label="Property Dimensions"
                            error={formState.errors['property_dimension']}
                            registration={register('property_dimension')}
                          />
                          <InputField
                            label="Price NOK"
                            error={formState.errors['price']}
                            registration={register('price')}
                          />
                          <SelectField
                            options={subCatagories}
                            label="Sub Category"
                            error={formState.errors['sub_category']}
                            registration={register('sub_category')}
                            {...control}
                          />
                          <LocationInput
                            label="Location"
                            error={formState.errors['location']}
                            registration={register('location')}
                            handdleAddressChange={handdleLocationChnage}
                          />
                        </div>
                      )}

                      {activeTab === 'address' && (
                        <div className="form-block d-flex flex-column gap-2">
                          <InputField
                            label="Region"
                            type="text"
                            error={formState.errors['region']}
                            registration={register('region')}
                          />

                          <InputPhone
                            label="Phone Number"
                            error={formState.errors['phone_number']}
                            registration={register('phone_number')}
                          />
                        </div>
                      )}
                    </div>
                  </div>

                  {/* Next button to proceed */}
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    {/* <span className="arrow prev-arrow"><img src={prevArrow} className="d-block w-100" alt="" /></span> */}
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFirst;
