import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { Form } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { z } from 'zod';
const schema = z.object({
  rent_to_landlord: z.string().min(1, 'This field is required.'),
  cashflow_pcm: z.string().min(1, 'This field is required.'),
  cashflow_pa: z.string().min(1, 'This field is required.'),
  return_on_investment: z.string().min(1, 'This field is required.'),
});
type FormData = z.infer<typeof schema>;
const StepSecond = ({ formData, setFormData, onNext, onBack }: any) => {
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button className="tab-button active">Investment</button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Property Information</p>
            <Form<FormData, typeof schema>
              onSubmit={onNext}
              id="my-form"
              options={{ defaultValues: formData }}
              schema={schema}
            >
              {({ register, formState }) => (
                <>
                  <div className="row">
                    <div className="col-md-8">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          type="text"
                          label="Rent to Landlord"
                          error={formState.errors['rent_to_landlord']}
                          registration={register('rent_to_landlord')}
                          placeholder="Content"
                        />
                        <span className="requiredField">Required</span>

                        <InputField
                          type="number"
                          label="Cashflow PCM"
                          error={formState.errors['cashflow_pcm']}
                          registration={register('cashflow_pcm')}
                          placeholder="Content"
                        />
                        <span className="requiredField">Required</span>

                        <InputField
                          type="number"
                          label="Cashflow PA"
                          error={formState.errors['cashflow_pa']}
                          registration={register('cashflow_pa')}
                          placeholder="Content"
                        />
                        <span className="requiredField">Required</span>

                        <InputField
                          type="number"
                          label="Return on Investment"
                          error={formState.errors['return_on_investment']}
                          registration={register('return_on_investment')}
                          placeholder="Content"
                        />
                        <span className="requiredField">Required</span>
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};
export default StepSecond;
