import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import deleteIcon from '@/assets/deleteIcon.png';
import ReactQuill from 'react-quill';
import 'react-quill/dist/quill.snow.css';
import { useState } from 'react';
const StepThird = ({ formData, onNext, onBack }: any) => {
  const [value, setValue] = useState(formData?.cashflow_forecast ?? '');
  const handdleSubmit = () => {
    onNext({ cashflow_forecast: value });
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button className="tab-button active">Complete the following fields</button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3 d-flex justify-content-between align-items-center">
              Description
              <img src={deleteIcon} alt="" className="d-block w-100" />
            </p>
            <div>
              <ReactQuill theme="snow" value={value} onChange={setValue} />
            </div>
            <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
              <span className="arrow prev-arrow" onClick={onBack}>
                <img src={prevArrow} className="d-block w-100" alt="" />
              </span>
              <button
                className="arrow next-arrow d-flex gap-2 align-items-center"
                type="button"
                onClick={handdleSubmit}
              >
                Save
                <img src={nextArrow} className="d-block w-100" alt="" />
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
export default StepThird;
