import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import deleteIcon from '@/assets/deleteIcon.png';
import ReactQuill from 'react-quill';
import 'react-quill/dist/quill.snow.css';
import { useEffect, useState } from 'react';
import { nanoid } from 'nanoid';
type propsType = {
  formData: any;
  onNext: (value: any) => void;
  onBack: (value: any) => void;
  labbel: string;
  keyType: string;
};
const StepThird = ({ formData, onNext, onBack, labbel, keyType }: propsType) => {
  const [value, setValue] = useState('');
  const handdleSubmit = () => onNext({ [keyType]: value });
  useEffect(() => {
    setValue('');
    if (formData && formData[keyType]) setValue(formData[keyType]);
  }, [formData, keyType]);
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button className="tab-button active">{labbel}</button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3 d-flex justify-content-between align-items-center">
              Property Description
            </p>
            <div>
              <ReactQuill theme="snow" value={value} onChange={setValue} id={nanoid()} />
            </div>
            <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
              <span className="arrow prev-arrow" onClick={onBack}>
                <img src={prevArrow} className="d-block w-100" alt="" />
              </span>
              <button
                className="arrow next-arrow d-flex gap-2 align-items-center"
                type="button"
                onClick={handdleSubmit}
              >
                Save
                <img src={nextArrow} className="d-block w-100" alt="" />
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
export default StepThird;
