import React, { useEffect, useState } from 'react';
import { Stepper, Step, StepLabel, Button } from '@mui/material';
import StepFirst from './PropertyComponents/StepFirst';
import StepSecond from './PropertyComponents/StepSecond';
import StepThird from './PropertyComponents/StepThird';
import StepEight from './PropertyComponents/StepEight';
import { AddAdvertisement } from '@/api/Advertisement/add';
import { getUser } from '@/features/auth';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
const steps = [
  'Property Information',
  'Investment',
  'Property Information',
  'Rental',
  'The Vision',
  'Cash Flow Forecast',
  'Costs To Consider',
  'Disclaimer',
];

export const Advertisement = () => {
  const router = useNavigate();
  const [activeStep, setActiveStep] = useState(0);
  const [formData, setFormData] = useState<any>({});
  const [currentUser, setCurentUser] = useState<string | null>(null);
  const { addNotification } = useNotificationStore();
  const handleNext = () => {
    setActiveStep((prevActiveStep) => prevActiveStep + 1);
  };

  const handleBack = () => {
    setActiveStep((prevActiveStep) => prevActiveStep - 1);
  };

  const handleReset = () => {
    setActiveStep(0);
  };

  const updateFormData = (stepData: any) => {
    setFormData((prevData: any) => ({
      ...prevData,
      ...stepData,
    }));
  };
  const handdleNextSubmit = (data: any) => {
    setFormData((prevData: any) => ({
      ...prevData,
      ...data,
    }));
    handleNext();
  };
  const handdleFormMainSubmit = async () => {
    if (currentUser) {
      const daatForAdd = {
        ...formData,
        agency_id: currentUser,
        is_draft: 'False',
      };
      await AddAdvertisement({
        ...daatForAdd,
        latitude: 30.710596,
        longitude: 76.7128978,
        location: 'mohali punjab',
      });
      addNotification({
        type: 'success',
        title: 'Succes',
        message: 'Advertisement added succesfully',
      });
      router('/user/add');
    }
  };
  const getUserDetails = async () => {
    const res = await getUser();
    setCurentUser(res?.data?.customer_id);
  };
  useEffect(() => {
    getUserDetails();
  }, []);
  const renderStepContent = (step: number) => {
    switch (step) {
      case 0:
        return (
          <StepFirst
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            setFormData={(data: string) => updateFormData({ propertyInformation: data })}
          />
        );
      case 1:
        return (
          <StepSecond
            onNext={(values: any) => handdleNextSubmit(values)}
            onBack={handleBack}
            formData={formData}
            setFormData={(data: string) => updateFormData({ investment: data })}
          />
        );
      case 2:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            onBack={handleBack}
            formData={formData}
            labbel="Property Information"
            keyType="property_description"
          />
        );
      case 3:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            onBack={handleBack}
            formData={formData}
            labbel="Rental"
            keyType="rental_description"
          />
        );
      case 4:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            onBack={handleBack}
            formData={formData}
            labbel="The vision"
            keyType="vision_description"
          />
        );
      case 5:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            onBack={handleBack}
            formData={formData}
            labbel="Cash Flow Forecast"
            keyType="cashflow_forecast"
          />
        );
      case 6:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            onBack={handleBack}
            formData={formData}
            labbel="Costs To Consider"
            keyType="costs_to_consider"
          />
        );
      case 7:
        return (
          <StepEight
            onNext={handdleFormMainSubmit}
            onBack={handleBack}
            formData={formData}
            labbel="Discription"
            keyType="property_description"
          />
        );
      default:
        return 'Unknown step';
    }
  };

  return (
    <div className="section property-projects py-5">
      <div className="container">
        <h1 className="text-center text-dark mb-5">Add New Advertisement/Listing</h1>
        <div className="row">
          <div className="col-md-3">
            <Stepper activeStep={activeStep} orientation="vertical">
              {steps.map((label, index) => (
                <Step key={index}>
                  <StepLabel>{label}</StepLabel>
                </Step>
              ))}
            </Stepper>
          </div>

          <div className="col-md-9">
            <div className="step-content">
              {activeStep === steps.length ? (
                <div>
                  <p>All steps completed - you're finished!</p>
                  <Button onClick={handleReset}>Reset</Button>
                </div>
              ) : (
                <div>{renderStepContent(activeStep)}</div>
              )}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
