import React from 'react';
// import { useCommonDetails } from '@/api/commonDetail/getCommonDetail';
import { useBusinessDetails } from '@/api/commonDetail/getBusinessDetail';
import { useParams } from 'react-router-dom';

export const Accords = () => {
  const { id } = useParams();
  const { data } = useBusinessDetails({ id: id ?? '1' });
  const business = data?.data;
  return (
    <div className="Accords">
      <h5>{i18next.t('Categories')}</h5>
      <div className="accordion accordion-flush" id="accordionFlushExample">
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingOne">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseOne"
              aria-expanded="false"
              aria-controls="flush-collapseOne"
            >
              {i18next.t('Details')}
            </button>
          </h2>
          <div
            id="flush-collapseOne"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingOne"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body acc-list">
              <ul>
                <li className="row">
                  <div className="col-md-6 col-6 left">{i18next.t('Company name')}: </div>
                  <div className="col-md-6 col-6 right">{business?.company_name ?? ''}</div>
                </li>

                <li className="row">
                  <div className="col-md-6 col-6 left">Established : </div>
                  <div className="col-md-6 col-6 right">{business?.company_established ?? ''}</div>
                </li>

                <li className="row">
                  <div className="col-md-6 col-6 left">Background for sales : </div>
                  <div className="col-md-6 col-6 right">Priorities</div>
                </li>

                <li className="row">
                  <div className="col-md-6 col-6 left">Number Of Employees : </div>
                  <div className="col-md-6 col-6 right">{business?.number_of_employes ?? ''}</div>
                </li>

                <li className="row">
                  <div className="col-md-6 col-6 left">Web : </div>
                  <div className="col-md-6 col-6 right">{business?.company_category ?? ''}</div>
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingTwo">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseTwo"
              aria-expanded="false"
              aria-controls="flush-collapseTwo"
            >
              {i18next.t('Documents')}
            </button>
          </h2>
          <div
            id="flush-collapseTwo"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingTwo"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              Placeholder content for this accordion, which is intended to demonstrate the{' '}
              <code>.accordion-flush</code> class. This is the second items accordion body. Lets
              imagine this being filled with some actual content.
            </div>
          </div>
        </div>
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingThree">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseThree"
              aria-expanded="false"
              aria-controls="flush-collapseThree"
            >
              Operations
            </button>
          </h2>
          <div
            id="flush-collapseThree"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingThree"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              Placeholder content for this accordion, which is intended to demonstrate the{' '}
              <code>.accordion-flush</code> class. This is the third items accordion body. Nothing
              more exciting happening here in terms of content, but just filling up the space to
              make it look, at least at first glance, a bit more representative of how this would
              look in a real-world application.
            </div>
          </div>
        </div>
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingFour">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseFour"
              aria-expanded="false"
              aria-controls="flush-collapseFour"
            >
              Functional Information
            </button>
          </h2>
          <div
            id="flush-collapseFour"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingFour"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              Placeholder content for this accordion, which is intended to demonstrate the{' '}
              <code>.accordion-flush</code> class. This is the third items accordion body. Nothing
              more exciting happening here in terms of content, but just filling up the space to
              make it look, at least at first glance, a bit more representative of how this would
              look in a real-world application.
            </div>
          </div>
        </div>
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingFive">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseFive"
              aria-expanded="false"
              aria-controls="flush-collapseFive"
            >
              {i18next.t('Various Information')}
            </button>
          </h2>
          <div
            id="flush-collapseFive"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingFive"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              Placeholder content for this accordion, which is intended to demonstrate the{' '}
              <code>.accordion-flush</code> class. This is the third items accordion body. Nothing
              more exciting happening here in terms of content, but just filling up the space to
              make it look, at least at first glance, a bit more representative of how this would
              look in a real-world application.
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
