import React, { useState } from 'react';
import intro1 from '@/assets/intro1.jpg';
import logo from '@/assets/logofooter.png';
import { Bakery } from './Outlets/Bakery';
import { Accords } from './Outlets/Accords';
import { Intro } from './Outlets/Intro';
import { Inquiry } from './Outlets/Inquiry';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
// import ToggleSwitch from '@/components/Elements/ToggleSwitch/ToggleSwitch';
import { BookMeeting } from '@/api/businessInquiry/BookMeeting';

import * as z from 'zod';
import { Button } from '@/components/Elements';
import { Form, InputField, TextAreaField } from '@/components/Form';
import { useNotificationStore } from '@/stores/notifications';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import i18next from 'i18next';
function Outlets({ newId, eligible }: { newId: any; eligible: boolean }) {
  const [open, setOpen] = useState(false);
  const [loading, setLoading] = useState(false);

  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);

  const schema = z.object({
    booking_date: z.string().min(1, 'Please enter a booking date'),
    booking_time: z.string().min(1, 'Please enter a booking time'),
    message: z.string().min(1, 'Please enter a message'),
    phone_number: z.custom(isValidMobile, isValidMobileMsg),
  });

  type ContactValues = {
    booking_time: string;
    booking_date: string;
    property_id: string;
    message: string;
    phone_number: string;
  };

  const handleSubmit = async (values: ContactValues) => {
    try {
      setLoading(true);

      await BookMeeting({ ...values, property_id: newId });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Booking request sent successfully!',
      });
      onCloseModal();
    } finally {
      setLoading(false);
    }
  };
  return (
    <>
      <section className="bg-light-pink agent-outlet">
        <div className="container outlets ">
          <div className="row">
            <div className="col-12 col-md-4 col-lg-3">
              <div className="card">
                <p className="card-p1">
                  <img src={intro1} alt="Profile Pic" />
                </p>
                <p className="card-p2 f-20 mb-1">John Smith Reachel</p>
                <p className="card-p3 f-15">{i18next.t('Reeipo Real Estate Agent')}</p>
                <p className="card-p4 w-90">
                  {eligible ? (
                    <Button onClick={onOpenModal} className="w-100">
                      Book a meeting
                    </Button>
                  ) : (
                    <Button disabled className="w-100">
                      Book a meeting
                    </Button>
                  )}
                  <Modal open={open} onClose={onCloseModal} center>
                    <div className="modal-contents row">
                      <div className="col-4 col-md-4 left">
                        <div>
                          <img src={logo} alt="pic" />
                        </div>
                        <div className="div-two">
                          <h4>{i18next.t('Book Call Appointment')}</h4>
                          <p>{i18next.t('with our Agent')}</p>
                        </div>
                        <div className="div-three">
                          <span>Carol Manyos</span>
                        </div>
                      </div>
                      <div className="col-8 col-md-8 right">
                        <h5>{i18next.t('Select Date And Time')}</h5>
                        <hr />
                        <div className="form-boxes">
                          <Form<ContactValues, typeof schema>
                            onSubmit={handleSubmit}
                            schema={schema}
                          >
                            {({ register, formState }) => (
                              <>
                                <div className="row">
                                  <div className="col-md-6 col-6">
                                    <InputField
                                      type="date"
                                      label="Meeting Date"
                                      error={formState.errors['booking_date']}
                                      registration={register('booking_date')}
                                      placeholder={i18next.t('Wanted From')}
                                    />
                                  </div>
                                  <div className="col-md-6 col-6">
                                    <InputField
                                      type="time"
                                      label="Meeting Time"
                                      error={formState.errors['booking_time']}
                                      registration={register('booking_time')}
                                      placeholder="Meeting Time"
                                    />
                                  </div>
                                </div>
                                <div className="row">
                                  <InputPhone
                                    floating
                                    error={formState.errors['phone_number']}
                                    registration={register('phone_number')}
                                  />
                                </div>

                                <div className="row">
                                  <TextAreaField
                                    rows={4}
                                    error={formState.errors['message']}
                                    registration={register('message')}
                                    label={i18next.t('Message')}
                                  />
                                </div>

                                <Button isLoading={loading} type="submit">
                                  Submit
                                </Button>
                              </>
                            )}
                          </Form>
                        </div>
                      </div>
                    </div>
                  </Modal>
                </p>
                <p className="card-p5 w-90">
                  {eligible ? <Button className="w-100">{i18next.t('Inquire Now')}</Button> : null}
                </p>
              </div>
              <Accords />
            </div>
            <div className="col-12 col-md-8 col-lg-9">
              <Bakery />
              <Intro />
              {/* <div className="desktop-inquiry">
                <Inquiry userIdentity={newId} />
              </div> */}
            </div>
          </div>
        </div>
      </section>
    </>
  );
}

export default Outlets;
