import React from 'react';
import { useBusinessSaleDetails } from '@/api/bussinessForSale/getBusinessfroSaleDetail';
import { useParams } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import { Image } from '@/components/Elements/Images';
import i18next from 'i18next';

export const Accords = () => {
  const { id } = useParams();
  const { data } = useBusinessSaleDetails({ id: id ?? '1' });
  const business = data?.data;
  return (
    <div className="Accords">
      <h5 className="underlined-title f-26 semi-bold mb-4">{i18next.t('Categories')}</h5>
      <div className="accordion accordion-flush" id="accordionFlushExample">
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingOne">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseOne"
              aria-expanded="false"
              aria-controls="flush-collapseOne"
            >
              {i18next.t('Details')}
            </button>
          </h2>
          <div
            id="flush-collapseOne"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingOne"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body acc-list">
              <ul>
                <li className="row">
                  <div className="col-md-7 col-7 left">{i18next.t('Company name')}: </div>
                  <div className="col-md-5 col-5 right">{business?.company_name ?? ''}</div>
                </li>

                <li className="row">
                  <div className="col-md-7 col-7 left">Established : </div>
                  <div className="col-md-5 col-5 right">{business?.company_established ?? ''}</div>
                </li>

                <li className="row">
                  <div className="col-md-7 col-7 left">Email : </div>
                  <div className="col-md-5 col-5 right">{business?.company_email}</div>
                </li>

                <li className="row">
                  <div className="col-md-7 col-7 left">Contact : </div>
                  <div className="col-md-5 col-5 right">{business?.company_telephone}</div>
                </li>

                <li className="row">
                  <div className="col-md-7 col-7 left">No. Of Employees</div>
                  <div className="col-md-5 col-5 right">{business?.number_of_employes ?? ''}</div>
                </li>

                <li className="row">
                  <div className="col-md-7 col-7 left">Category : </div>
                  <div className="col-md-5 col-5 right">{business?.company_category ?? ''}</div>
                </li>
                <li className="row">
                  <div className="col-md-7 col-7 left">Type : </div>
                  <div className="col-md-5 col-5 right">{business?.company_type ?? ''}</div>
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingTwo">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseTwo"
              aria-expanded="false"
              aria-controls="flush-collapseTwo"
            >
              {i18next.t('Documents')}
            </button>
          </h2>
          <div
            id="flush-collapseTwo"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingTwo"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              <div className="prospect-dwnload d-flex align-items-center justify-content-between">
                {/* <span className="f-16">Prospectus</span>{' '}
                <a className="prospect-dwn" href="">
                  <i className="fa-solid fa-download"></i>
                </a> */}
                <FileViewer file={business?.documents} />
                {/* <Image
                  imagefallback={business?.documents}
                  className="itemImage"
                  alt="banner"
                  src={business?.documents}
                /> */}
              </div>
            </div>
          </div>
        </div>
        {/* <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingThree">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseThree"
              aria-expanded="false"
              aria-controls="flush-collapseThree"
            >
             {i18next.t('Note to purchase')}
            </button>
          </h2>
          <div
            id="flush-collapseThree"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingThree"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">{business?.note_to_purchase}</div>
          </div>
        </div> */}
        {/* <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingFour">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseFour"
              aria-expanded="false"
              aria-controls="flush-collapseFour"
            >
              Functional Information
            </button>
          </h2>
          <div
            id="flush-collapseFour"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingFour"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              Placeholder content for this accordion, which is intended to demonstrate the{' '}
              <code>.accordion-flush</code> class. This is the third items accordion body. Nothing
              more exciting happening here in terms of content, but just filling up the space to
              make it look, at least at first glance, a bit more representative of how this would
              look in a real-world application.
            </div>
          </div>
        </div> */}
        {/* <div className="accordion-item">
          <h2 className="accordion-header" id="flush-headingFive">
            <button
              className="accordion-button collapsed"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#flush-collapseFive"
              aria-expanded="false"
              aria-controls="flush-collapseFive"
            >
              Various Information
            </button>
          </h2>
          <div
            id="flush-collapseFive"
            className="accordion-collapse collapse"
            aria-labelledby="flush-headingFive"
            data-bs-parent="#accordionFlushExample"
          >
            <div className="accordion-body">
              Placeholder content for this accordion, which is intended to demonstrate the{' '}
              <code>.accordion-flush</code> class. This is the third items accordion body. Nothing
              more exciting happening here in terms of content, but just filling up the space to
              make it look, at least at first glance, a bit more representative of how this would
              look in a real-world application.
            </div>
          </div>
        </div> */}
      </div>
    </div>
  );
};
