import React from 'react';
import './Outlet.css';
import FileViewer from '@/components/Viewer/FileViewer';
import intro3 from '@/assets/intro3.png';
import { useParams } from 'react-router-dom';
import { useBusinessSaleDetails } from '@/api/bussinessForSale/getBusinessfroSaleDetail';
import i18next from 'i18next';

export const Bakery = () => {
  const { id } = useParams();
  const { data } = useBusinessSaleDetails({ id: id ?? '1' });
  const business = data?.data;
  return (
    <>
      <div className="bakery">
        <h5>{i18next.t('Business Details')}</h5>
        <p className="mb-4">{business?.company_details}</p>
        <FileViewer file={business?.videos}></FileViewer>
      </div>
    </>
  );
};
