import React, { useState } from 'react';
import * as z from 'zod';
import intro2 from '@/assets/intro2.png';
import { useParams } from 'react-router-dom';
import { Form, InputField } from '@/components/Form';
import { Button } from '@/components/Elements';
// import { inquiryAd } from '@/api/inquiryAd/inquiryAd';
import { inquiryBusinessForSale } from '@/api/bussinessForSale/inquiryBusinessForSale';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useAuth } from '@/lib/auth';
import { useBusinessSaleDetails } from '@/api/bussinessForSale/getBusinessfroSaleDetail';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import { translateAmenties } from '@/translations/translateFunction';
import i18next from 'i18next';

export const Inquiry = ({ userIdentity }: { userIdentity: any }) => {
  const { id } = useParams();
  const customerId = userIdentity;

  const auth = useAuth();
  const { data } = useBusinessSaleDetails({ id: id ?? '1' });
  const business = data?.data;

  const loggedinId = auth.user?.customer_id;

  const schema = z.object({
    name: z.string().min(1, 'Please enter your full name'),
    email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
    telephone: z.custom(isValidMobile, isValidMobileMsg),

    message: z.string().min(1, 'Please enter a message'),
    company_name: z.string().min(1, 'PLease enter company name'),
  });

  type inquiryAd = {
    name: string;
    telephone: string;
    email: string;
    message: string;
    company_name: string;
  };
  const [loading, setLoading] = useState(false);
  const handleSubmit = async (values: inquiryAd) => {
    try {
      setLoading(true);

      await inquiryBusinessForSale({
        ...values,
        project_id: `${id}`,
        id: `${id}`,
        type: `SaleProperty`,
      });
    } finally {
      setLoading(false);
    }
  };
  return (
    <>
      <BackdropLoader open={loading} />
      <section className="inquiryform">
        <div className="inquiry">
          <h5 className="mb-4">Inquire About the Adds</h5>
          <div className="row">
            <div className="col-12 col-md-12 col-lg-7 left">
              <div className="form-box mt-0">
                <div>
                  <div className="inquireformhover">
                    <fieldset disabled={loggedinId === customerId}>
                      <Form<inquiryAd> onSubmit={handleSubmit} schema={schema}>
                        {({ register, formState }) => (
                          <>
                            <InputField
                              label={translateAmenties('Name')}
                              error={formState.errors['name']}
                              registration={register('name')}
                            />
                            <InputField
                              label={translateAmenties('Company Name')}
                              error={formState.errors['company_name']}
                              registration={register('company_name')}
                            />
                            <InputPhone
                              floating
                              error={formState.errors['telephone']}
                              registration={register('telephone')}
                            />

                            <InputField
                              label={translateAmenties('Email')}
                              error={formState.errors['email']}
                              registration={register('email')}
                            />
                            <InputField
                              label={translateAmenties('Message')}
                              error={formState.errors['message']}
                              registration={register('message')}
                            />
                            {loggedinId === customerId && (
                              <p className="message">You are owner of this Property</p>
                            )}

                            <div className="iq-div">
                              <Button type="submit" className="iq-btn dark-btn">
                                {translateAmenties('Inquire Now')}
                              </Button>
                            </div>
                          </>
                        )}
                      </Form>
                    </fieldset>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-12 col-md-12 col-lg-5 right">
              <div className="topss">
                <img src={business?.customer_image} alt="profile" />
              </div>
              <div className="bottms">
                <div>
                  <p> {i18next.t('We would not be where we are today')} .</p>
                  <p className="nam">{business?.customer_name}</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};
