import React from 'react';
import { useBusinessSaleDetails } from '@/api/bussinessForSale/getBusinessfroSaleDetail';
import { useParams, Link } from 'react-router-dom';
import FileViewer from '@/components/Viewer/FileViewer';
import intro3 from '@/assets/intro3.png';
import i18next from 'i18next';

function SaleContent() {
  const { id } = useParams();
  const { data } = useBusinessSaleDetails({ id: id ?? '2' });
  const business = data?.data;
  return (
    <>
      <div className="container SaleContent">
        <div className="row">
          <div className="col-12 col-md-6 col-lg-5">
            <p className="line1">{business?.company_name ?? ''}</p>
            <p className="line2">
              <i className="fa-solid fa-map-location-dot"></i>Cambridge, CB5 8TN
            </p>
            <p className="line3">{business?.company_vision ?? ''}</p>
            <p className="line4">{business?.note_to_purchase ?? ''}</p>
            <div className="line5">
              <div className="sl1 row">
                <p className="left col-6 col-md-6">Suggested price:</p>
                <p className="right col-6 col-md-6">{business?.purchase_price ?? ''}</p>
              </div>
              <div className="sl1 row">
                <p className="left col-6 col-md-6">{i18next.t('Total turnover')} 2021</p>
                <p className="right col-6 col-md-6">{business?.total_turnover ?? ''}</p>
              </div>
              <div className="sl1 row">
                <p className="left col-6 col-md-6">{i18next.t('Operating profit ')} 2021</p>
                <p className="right col-6 col-md-6">{business?.operating_profit ?? ''}</p>
              </div>
            </div>
          </div>
          <div className="col-12 col-md-6 col-lg-7">
            <div className="flex items-end justify-end">
              <FileViewer
                file={business?.images ?? intro3}
                style={{ width: '60%', maxHeight: 'none' }}
              ></FileViewer>
            </div>
          </div>
        </div>
        <div className="social-list container">
          {i18next.t('Share the campaign with your friends')}:
          <Link to="/${business?.company_email??''}">
            <i className="fa-regular fa-envelope"></i>
          </Link>
          <Link to="/${business?.company_twitter_link??''}">
            <i className="fa-brands fa-twitter"></i>
          </Link>
          <Link to="/${business?.company_linkedin_link ?? ''}">
            <i className="fa-brands fa-linkedin"></i>
          </Link>
          <Link to="/${business?.company_youtube_link??''}">
            <i className="fa-brands fa-whatsapp"></i>
          </Link>
        </div>
      </div>
    </>
  );
}

export default SaleContent;
