import Footer from '@/components/Layout/Footer/Footer';
import Header, { HeaderType } from '@/components/Layout/Header/Header';
import React, { useEffect, useState } from 'react';
import Outlets from './Outlets';
import './SaleDetail.css';
import { useNavigate, useParams, Link } from 'react-router-dom';
import { ContentLayout } from '@/components/Layout';
import { Inquiry } from './Outlets/Inquiry';
import { useBusinessSaleDetails } from '@/api/bussinessForSale/getBusinessfroSaleDetail';
import FileViewer from '@/components/Viewer/FileViewer';
import intro3 from '@/assets/intro3.png';
import destination from '@/assets/destination.png';
import PropertyDetail from '@/components/Elements/Loader/PropertyDetail';
import { trimSixty } from '@/utils/format';
import Tabs from 'react-responsive-tabs';
import 'react-responsive-tabs/styles.css';
import OwlCarousel from 'react-owl-carousel';
import 'owl.carousel/dist/assets/owl.carousel.css';
import 'owl.carousel/dist/assets/owl.theme.default.css';
import { Button } from '@/components/Elements/Button';
import { useAuth } from '@/lib/auth';
import FsLightbox from 'fslightbox-react';
import storage from '@/utils/storage';
import i18next from 'i18next';

export const SaleDetail = ({ newId }: { newId: any }) => {
  const navigate = useNavigate();
  const { id } = useParams();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { user } = useAuth();
  const [eligible, setEligible] = useState(true);
  const [toggler, setToggler] = useState<boolean>(false);
  const [pics, setPics] = useState([]);
  const [productIndex, setProductIndex] = useState(0);

  const { data, isLoading } = useBusinessSaleDetails({ id: id ?? '2' });

  const loggedInId = user?.customer_id;
  const ownerId = data?.data?.customer_id;

  useEffect(() => {
    if (loggedInId == ownerId) {
      setEligible(false);
    }
  }, [loggedInId, ownerId]);

  const business = data?.data;
  const customerId = business?.customer_id;
  const presidents = [
    {
      name: 'Concept',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.concept}`,
            }}
          />
        </>
      ),
    },

    {
      name: 'Financial Information',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.financial_information}`,
            }}
          />
        </>
      ),
    },
    {
      name: 'Market Situation',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.market_situtation}`,
            }}
          />
        </>
      ),
    },

    {
      name: 'Operation & History',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.operation_and_history}`,
            }}
          />
        </>
      ),
    },

    {
      name: 'Premises and Location',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.premisis_and_location}`,
            }}
          />
        </>
      ),
    },
    {
      name: `${i18next.t('Price and Valuation')}`,
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.price_and_valuation}`,
            }}
          />
        </>
      ),
    },
    {
      name: 'Advantage',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.advantage_and_opportuntity}`,
            }}
          />
        </>
      ),
    },
    {
      name: 'Various Information',
      biography: (
        <>
          <img className="propImages" src={destination} alt="sds" />
          <span
            dangerouslySetInnerHTML={{
              __html: `${business?.various_information}`,
            }}
          />
        </>
      ),
    },

    // {
    //   name: 'Property At Glance',
    //   biography: (
    //     <>
    //       <img className="propImages" src={destination} alt="sds" />

    //       <div className="row glanceRow">
    //         <div className="col-md-3 col-3 leftdd">ass</div>
    //         <div className="col-md-9 col-9">dfg</div>
    //       </div>
    //     </>
    //   ),
    // },
    // {
    //   name: 'Management',
    //   biography: (
    //     <>
    //       <img className="propImages" src={destination} alt="sds" />
    //       <div className="management-details">
    //         <p className="bold f-32 ls-1 mb-1">About</p>
    //         <p>fgdhkj</p>
    //       </div>
    //     </>
    //   ),
    // },
  ];
  const optionsCar = {
    margin: 30,
    responsiveClass: true,
    nav: true,
    dots: false,
    autoplay: true,
    navText: ['<', '>'],
    rewind: true,
    smartSpeed: 1000,
    responsive: {
      0: {
        items: 2,
      },
      400: {
        items: 3,
      },
      600: {
        items: 4,
      },
      700: {
        items: 5,
      },
      1000: {
        items: 5,
      },
    },
  };

  function getTabs() {
    return presidents.map((president, index) => ({
      title: president.name,
      getContent: () => president.biography,
      key: index,
      tabClassName: 'tab',
      panelClassName: 'panel',
    }));
  }

  useEffect(() => {
    eval(business?.image_data)?.map((val) => {
      setPics((item) => [...item, val?.image]);
    });
  }, [isLoading]);

  const handleToggler = (index: number) => {
    setToggler(true);
    setProductIndex(index);
  };

  const handleClose = () => {
    setToggler(false);
  };

  return (
    <>
      {isLoading ? (
        <PropertyDetail />
      ) : (
        <ContentLayout title="Sale Detail">
          <div>
            <Header type={HeaderType.LANDING} />
            <button onClick={() => navigate(-1)}>
              <i className="fa-regular fa-circle-left go-back-button"></i>
            </button>
            <div className="container SaleContent">
              <div className="row">
                <div className="col-12 col-md-6 col-lg-5">
                  <p className="line1">{business?.company_name ?? ''}</p>
                  <p className="line2">
                    <i className="fa-solid fa-map-location-dot ms-0"></i>
                    {business?.location}
                  </p>

                  {/* {/* <p className="line3">{trimSixty(business?.company_vision) ?? ''}</p> */}
                  <p className="line4">{trimSixty(business?.description) ?? ''}</p>
                  <p className="right col-6 col-md-6">
                    {i18next.t('Price')} : {localSymbol}{' '}
                    {business?.purchase_price
                      ? (business?.purchase_price * localCurrency)?.toFixed(0)
                      : ''}
                  </p>
                  <div className="line5">
                    <div className="sl1 row">
                      <p className="left col-6 col-md-6">
                        {i18next.t('Purchase price')} ({localSymbol}):
                      </p>
                      <p className="right col-6 col-md-6">
                        {localSymbol}{' '}
                        {business?.purchase_price
                          ? (business?.purchase_price * localCurrency)?.toFixed(0)
                          : ''}
                      </p>
                    </div>
                    <div className="sl1 row">
                      <p className="left col-6 col-md-6">
                        {i18next.t('Total turnover')} ({localSymbol}):{' '}
                      </p>
                      <p className="right col-6 col-md-6">
                        {localSymbol}{' '}
                        {business?.total_turnover
                          ? (business?.total_turnover * localCurrency)?.toFixed(0)
                          : ''}
                      </p>
                    </div>
                    <div className="sl1 row">
                      <p className="left col-6 col-md-6">
                        {i18next.t('Operating profit ')}({localSymbol}):
                      </p>
                      <p className="right col-6 col-md-6">
                        {localSymbol}{' '}
                        {business?.operating_profit
                          ? (business?.operating_profit * localCurrency)?.toFixed(0)
                          : ''}
                      </p>
                    </div>
                    <div className="sl1 row">
                      <p className="left col-6 col-md-6">Sallary Percentage</p>
                      <p className="right col-6 col-md-6">{business?.salary_percentage ?? ''} %</p>
                    </div>
                    <div className="sl1 row">
                      <p className="left col-6 col-md-6">
                        {i18next.t('Background for sale')} ({localSymbol}):
                      </p>
                      <p className="right col-6 col-md-6">
                        {localSymbol}{' '}
                        {business?.background_for_sale
                          ? (business?.background_for_sale * localCurrency)?.toFixed(0)
                          : ''}
                      </p>
                    </div>
                    <div className="sl1 row">
                      <p className="left col-6 col-md-6">
                        {i18next.t('Cost Of Goods Sold')} ({localSymbol}):
                      </p>
                      <p className="right col-6 col-md-6">
                        {localSymbol}{' '}
                        {business?.cost_of_goods_sold
                          ? (business?.cost_of_goods_sold * localCurrency)?.toFixed(0)
                          : ''}
                      </p>
                    </div>
                  </div>
                  {/* <div className="profileFoto">
                    <div className="mainDIv">
                      <div className="topPics"></div>
                      <hr />

                      <div className="midData">
                        <h5>User Name</h5>
                        <p>User bio </p>
                      </div>
                      <hr />

                      <div className="bottomButn">
                        <Button onClick={() => navigate(`/profile-details?id=${customerId}`)}>
                        {i18next.t(' View Profile')}
                        </Button>
                      </div>
                    </div>
                  </div> */}
                </div>
                <div className="col-12 col-md-6 col-lg-7 sidePanel">
                  <div className="row">
                    {eval(business?.image_data)
                      .slice(0, 1)
                      .map((item: any, index: number) => (
                        <div className="col-md-12 col-12" key={index}>
                          <img className="idImage busines-top-img" alt="hixas" src={item?.image} />
                        </div>
                      ))}
                  </div>
                  {/* <div className="flex items-end justify-end two">
                    {eval(business?.image_data)
                      .slice(1, 2)
                      .map((item: any) => (
                        <img className="idImage" alt="hixas" src={item?.image} />
                      ))}
                  </div> */}
                </div>
              </div>
              <div className="social-list container mt-0">
                {i18next.t('Share the campaign with your friends')}:
                <button onClick={() => window.open(`${business?.website_link}`)}>
                  <i className="fa-regular fa-envelope"></i>
                </button>
                <button onClick={() => window.open(`${business?.company_twitter_link}`)}>
                  <i className="fa-brands fa-twitter"></i>
                </button>
                <button onClick={() => window.open(`${business?.company_linkedin_link}`)}>
                  <i className="fa-brands fa-linkedin"></i>
                </button>
                <button onClick={() => window.open(`${business?.company_facebook_link}`)}>
                  <i className="fa-brands fa-facebook"></i>
                </button>
                <button onClick={() => window.open(`${business?.company_youtube_link}`)}>
                  <i className="fa-brands fa-youtube"></i>
                </button>
              </div>
              <div className="row w-100 m-auto">
                <div className="col-md-12 col-12 row picsfor fiveBOxes sale-detals">
                  {business?.image_data?.length <= 4 ? (
                    <>
                      {eval(business?.image_data)
                        .slice(0, 4)
                        .map((item: any, index: number) => (
                          <div className="col-md-3 col-6" key={index}>
                            <img
                              alt="hixas"
                              src={item?.image}
                              onClick={() => handleToggler(index)}
                            />
                          </div>
                        ))}
                    </>
                  ) : (
                    <OwlCarousel {...optionsCar} className="owl-theme sale-details" loop nav>
                      {eval(business?.image_data).map((item: any, index: number) => (
                        <div key={index}>
                          <div className="item">
                            {/* {item?.name && <span className="imageNames">{item?.name}</span>} */}
                            <img
                              alt="hias"
                              src={item?.image}
                              style={{ objectFit: 'cover' }}
                              onClick={() => handleToggler(index)}
                            />
                          </div>
                        </div>
                      ))}
                    </OwlCarousel>
                  )}
                </div>
                <FsLightbox
                  toggler={toggler}
                  sources={pics}
                  sourceIndex={productIndex}
                  onClose={handleClose}
                />
              </div>
            </div>
            <Outlets newId={id} eligible={eligible} />
            <div className="row w-100 m-auto tab-details-rw">
              <div className="col-12">
                <div className="property-details-tabs container">
                  <Tabs showMore={false} items={getTabs()} />
                </div>
              </div>
              <div className="col-12">
                <div className="container">
                  <div>
                    {/* <div className="mobile-inquiry"> */}
                    <Inquiry userIdentity={newId} />
                  </div>
                </div>
              </div>
            </div>

            <Footer />
          </div>
        </ContentLayout>
      )}
    </>
  );
};
