import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import deleteIcon from '@/assets/deleteIcon.png';
import { z } from 'zod';
import ReactQuill from 'react-quill';
import 'react-quill/dist/quill.snow.css';
import { useState } from 'react';
import { Form, InputField, RadioButtonField, TextAreaField } from '@/components/Form';
import { MapViwerWithSearch } from '@/components/Elements/map/MapMarker';
const schema = z.object({
  valuation: z.string().min(1, 'This field is required.'),
});
type FormData = z.infer<typeof schema>;

const Disclamer = ({ formData, onNext, onBack }: any) => {
  const [value, setValue] = useState(formData?.costs_to_consider ?? '');
  const handdleSubmit = () => {
    onNext({ costs_to_consider: value });
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button className="tab-button active">Additional information about yourself</button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <h1>Additional information about yourself</h1>
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3"></p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <MapViwerWithSearch
                          label="Residence number"
                          error={formState.errors['valuation']}
                          registration={register('valuation')}
                        />
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="button"
                      onClick={handdleSubmit}
                    >
                      Submit
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
          {/* <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
            <span className="arrow prev-arrow" onClick={onBack}>
              <img src={prevArrow} className="d-block w-100" alt="" />
            </span>
            <button
              className="arrow next-arrow d-flex gap-2 align-items-center"
              type="button"
              onClick={handdleSubmit}
            >
              Submit
              <img src={nextArrow} className="d-block w-100" alt="" />
            </button>
          </div> */}
        </div>
      </div>
    </div>
  );
};
export default Disclamer;
