import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { CheckBoxField, Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import { z } from 'zod';
import subCatagories from '@/config/subcatagories';
import { MapMarker, LocationInput, MapViwerWithSearch } from '@/components/Elements/map/MapMarker';
import { Button } from '@mui/material';
const schema = z.object({
  security: z.string().min(1, 'This field is required.'),
});
type FormData = z.infer<typeof schema>;

const StepFoutrh = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Company Information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Company Information</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="Verdivurdering"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Max drawing"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Shares for sale"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Minimum  drawing"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Price per share NOK remaining shares"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Postnummer"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Number of share before issue"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Self report"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Nominal share price NOK"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Bank acc Created"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="E -post til styreleder"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Issue account number"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Company website"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Postnummer"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Location"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Write a text here...'
                        />
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFoutrh;
