import nextArrow from '@/assets/arrowNext.png';
import { Form } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { z } from 'zod';
const schema = z.object({
  sort_title: z.string().min(1, 'Required.'),
});
type FormData = z.infer<typeof schema>;

const SortTitle = ({ formData, onNext, onBack }: any) => {
  const handdleSubmit = (value: any) => {
    value = { ...value };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="card">
        <div className="card-body">
          <Form<FormData, typeof schema>
            onSubmit={handdleSubmit}
            id="my-form"
            schema={schema}
            options={{
              defaultValues: {
                ...formData,
              },
            }}
          >
            {({ register, formState, getValues, control }) => (
              <>
                <div className="row">
                  <div className="col-md-12">
                    <div className="form-block d-flex flex-column gap-2">
                      <InputField
                        error={formState.errors['sort_title']}
                        registration={register('sort_title')}
                        label="Short Title"
                      />
                    </div>
                  </div>
                </div>
                <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                  <button
                    className="arrow next-arrow d-flex gap-2 align-items-center"
                    type="submit"
                  >
                    Next
                    <img src={nextArrow} className="d-block w-100" alt="" />
                  </button>
                </div>
              </>
            )}
          </Form>
        </div>
      </div>
    </div>
  );
};

export default SortTitle;
