import nextArrow from '@/assets/arrowNext.png';
import { CheckBoxField, Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import prevArrow from '@/assets/arrowPrev.png';
import { TextAreaField } from '@/components/Form/TextareaField';
import React, { useState } from 'react';
import { z } from 'zod';
import { SingleImageUploder } from '@/components/Elements/upload/SingleImageUploader';
import subCatagories from '@/config/subcatagories';
import { InputPhone } from '@/components/Form/InputPhone';
const facilities: string[] = [
  'Air conditioning',
  'Alarm',
  'Balcony',
  'Child friendly',
  'Broadband connection',
  'Pets allowed',
  'Shared laundry',
  'Garage/parking space',
  'Garden',
  'Elevator',
  'Appliances',
  'No returnees',
  'Cable TV',
  'Charging option',
  'Life cycle standard',
  'Furniture',
  'Fireplace',
  'Calm',
  'Terrace',
  'View',
];
const schema = z.object({
  property_type: z.string().optional(),
  floor: z.string().min(1, 'Floor is required'),
  rooms: z.string().min(1, 'Number of rooms is required'),
  bedrooms: z.string().min(1, 'Number of bedrooms is required'),
  size: z.string().min(1, 'Size is required'),
  facility: z.array(z.enum(facilities)).optional(),
});
type FormData = z.infer<typeof schema>;

const StepFirst = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    console.log(value, '================================================');
    value = { ...value, ...media };
    onNext(value);
  };
  const options = [
    { label: 1, value: 1 },
    { label: 1, value: 1 },
  ];
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Property Information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Property Information</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  <div className="row">
                    <div className="col-md-3">
                      <div className="form-block d-flex flex-column gap-2">
                        {/* <TextAreaField
                          rows={4}
                          error={formState.errors['property_name']}
                          registration={register('property_name')}
                          label="Short Title"
                        /> */}
                        <SingleImageUploder
                          src={media?.image_data}
                          setImage={(img) => handdleMediaChange(img, 'image_data')}
                          labbel="Images"
                        />
                        <SingleImageUploder
                          src={media?.videos}
                          setImage={(img) => handdleMediaChange(img, 'videos')}
                          labbel="Videos"
                        />
                        {/* <SingleImageUploder
                          src={media?.documents}
                          setImage={(img) => handdleMediaChange(img, 'documents')}
                          labbel="Documents"
                        /> */}
                      </div>
                    </div>

                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="What type of property will you be renting out?"
                          error={formState.errors['property_type']}
                          registration={register('property_type')}
                          placeholder="Write a text here..."
                          value={formData.main_catatgories.replace(/_/g, ' ')}
                          disabled
                        />
                        <InputField
                          type="number"
                          label="What floor is the home on?"
                          placeholder="Select an option..."
                          error={formState.errors['floor']}
                          registration={register('floor')}
                        />
                        <InputField
                          label="How many rooms are there in the home?"
                          type="text"
                          error={formState.errors['rooms']}
                          registration={register('rooms')}
                          placeholder="Write a text here..."
                        />
                        <InputField
                          label="How many bedrooms are there in the home?"
                          type="text"
                          error={formState.errors['bedrooms']}
                          registration={register('bedrooms')}
                          placeholder="Write a text here..."
                        />
                        <InputField
                          label="How big is the home?"
                          type="text"
                          error={formState.errors['size']}
                          registration={register('size')}
                          placeholder="Write a text here..."
                        />
                        <h6>What facilities are included?</h6>
                        <div className="grid grid-flow-col-3 grid-row-auto">
                          {facilities.map((value) => (
                            <CheckBoxField
                              className="w-12"
                              registration={register('facility')}
                              value={value}
                              name="facility"
                              label={value}
                            />
                          ))}
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFirst;
