import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { CheckBoxField, Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import { z } from 'zod';
import subCatagories from '@/config/subcatagories';
import { MapMarker, LocationInput, MapViwerWithSearch } from '@/components/Elements/map/MapMarker';
import { Button } from '@mui/material';
const securityOptions = ["Deposit account", "Deposit guarantee", "NAV guarantee"]
const schema = z.object({
  security: z.string().min(1, 'This field is required.'),
  facility: z.array(z.enum(securityOptions)).optional(),
});
type FormData = z.infer<typeof schema>;

const StepFoutrh = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Security
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Complete the following fields</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <h6>What forms of security do you accept?</h6>
                        <div className="row">
                          {
                            securityOptions.map((value) => <CheckBoxField
                              // error={formState.errors['facility']}
                              registration={register('facility',)}
                              value={value}
                              name='facility'
                              label={value}
                            />)
                          }
                        </div>
                        <InputField
                          label="Security amount"
                          error={formState.errors['security']}
                          registration={register('security')}
                          placeholder='Amount for deposit'
                          title='Recommended: 3 months rent'
                        />
                        {/* <InputField
                          label="Salary percentage"
                          error={formState.errors['valuation']}
                          registration={register('valuation')}
                        /> */}
                      </div>
                    </div>
                    {/* <div className="col-md-12">
                      <div className="form-block flex flex-row gap-3 items-center">
                        <div className="col-md-4">
                          <InputField
                            label="Other operating costs"
                            error={formState.errors['valuation']}
                            registration={register('valuation')}
                          />
                        </div>
                        <div className="col-md-4">
                          <InputField
                            label="Cost"
                            error={formState.errors['valuation']}
                            registration={register('valuation')}
                          />
                        </div>
                        <Button>Add</Button>
                      </div>
                    </div> */}
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFoutrh;
