import nextArrow from '@/assets/arrowNext.png';
import { CheckBoxField, Form, RadioButtonField, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import prevArrow from '@/assets/arrowPrev.png';
import { TextAreaField } from '@/components/Form/TextareaField';
import React, { useState } from 'react';
import { z } from 'zod';
import { SingleImageUploder } from '@/components/Elements/upload/SingleImageUploader';
import subCatagories from '@/config/subcatagories';
import { InputPhone } from '@/components/Form/InputPhone';
const facilities = ["Visible to all users on Reeipo.", "Only visible to those I contact"]
const schema = z.object({
  valuation: z.string().min(1, 'This field is required.'),
  facility: z.array(z.enum(facilities)).optional(), // Optional field
});
type FormData = z.infer<typeof schema>;

const StepFirst = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    console.log(value, "================================================")
    value = { ...value, ...media };
    onNext(value);
  };
  const options = [{ label: 1, value: 1 }, { label: 1, value: 1 }]

  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Property Information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">The Profile's Visibility</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  <div className="row">


                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <RadioButtonField
                          error={formState.errors['valuation']}
                          registration={register('valuation')}
                          value='Visible to all users on Reeipo.'
                          label='Visible to all users on Reeipo.'
                          name='valuation'
                        />
                        <RadioButtonField
                          error={formState.errors['valuation']}
                          registration={register('valuation')}
                          value='Only visible to those I contact'
                          label='Only visible to those I contact'
                          name='valuation'
                        />

                        <h6>The profile is automatically hidden after 30 days</h6>
                        <div className="row">
                          {
                            facilities.map((value) => <CheckBoxField
                              // error={formState.errors['facility']}
                              registration={register('facility',)}
                              value={value}
                              name='facility'
                              label={value}
                            />)
                          }
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFirst;
