import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { CheckBoxField, Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import { z } from 'zod';
import subCatagories from '@/config/subcatagories';
import { MapMarker, LocationInput, MapViwerWithSearch } from '@/components/Elements/map/MapMarker';
import { Button } from '@mui/material';
const facilities = ["Room in shared accommodation", "Room in apartment", "Dormitory", "Apartment", "House"]
const schema = z.object({
  rentalPeriod: z.string().min(1, 'This field is required and must be a positive number.'),
  dateAvail: z.string().min(1, 'This field is required and must be a positive number.'),
  rent: z.string().min(1, 'This field is required.'),
  desiredStartDate: z.string().refine((dateString) => {
    const date = new Date(dateString);
    return !isNaN(date.getTime()); // Check if date is valid
  }, {
    message: 'Please enter a valid date.',
  }),
  facility: z.array(z.enum(facilities)).optional(),
});
type FormData = z.infer<typeof schema>;

const StepThird = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [isFacilityAdding, setISFacilityAdding] = useState(false)
  const [newFacility, setNewFacility] = useState("")
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Desired Housing
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Desired Housing</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <h6>Monthly rent includes</h6>
                        <div className="row">
                          {
                            facilities.map((value) => <CheckBoxField
                              // error={formState.errors['facility']}
                              registration={register('facility',)}
                              value={value}
                              label={value}
                              name='facility'
                            />)
                          }
                        </div>
                        <InputField
                          type='number'
                          label="Looking for housing for the number of people"
                          error={formState.errors['rentalPeriod']}
                          registration={register('rentalPeriod')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          type='number'
                          label="Max monthly rent"
                          error={formState.errors['dateAvail']}
                          registration={register('dateAvail')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Rental period"
                          error={formState.errors['rent']}
                          registration={register('rent')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          type='date'
                          label="Desired start date"
                          error={formState.errors['desiredStartDate']}
                          registration={register('desiredStartDate')}
                          placeholder='Write a text here...'
                        />

                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepThird;
