import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { Form, SelectField, TextAreaField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { z } from 'zod';
import { SingleImageUploder } from '@/components/Elements/upload/SingleImageUploader';

const schema = z.object({
  firstName: z.string().min(1, 'First Name is required.'),
  lastName: z.string().min(1, 'Last Name is required.'),
  gender: z.string().min(1, 'Gender is required.'),
  dob: z.string().refine((dateString) => {
    const date = new Date(dateString);
    const age = new Date().getFullYear() - date.getFullYear();
    return age >= 18;
  }, {
    message: 'You must be at least 18 years old.',
  }),
  nationality: z.string().min(1, 'Nationality is required.'),
  phoneNumber: z.string().min(1, 'Phone number is required.'),
  email: z.string().email('Invalid email format.').min(1, 'Email is required.'),
});
type FormData = z.infer<typeof schema>;

const StepTwo = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="fornamem-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Location
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3"> Enter the home's location via the fields below or by marking the correct position on the map.</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-3">
                      <div className="form-block d-flex flex-column gap-2">
                        <SingleImageUploder
                          src={media?.image_data}
                          setImage={(img) => handdleMediaChange(img, 'image_data')}
                          labbel="Images"
                        />
                      </div>
                    </div>
                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          type="text"
                          label="First_Name"
                          error={formState.errors['firstName']}
                          registration={register('firstName')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          type="text"
                          label="Last_Name"
                          error={formState.errors['lastName']}
                          registration={register('lastName')}
                          placeholder='Write a text here...'
                        />
                        <SelectField
                          label="Gender"
                          error={formState.errors['gender']}
                          registration={register('gender')}
                          placeholder='Write a text here...'
                          options={[{ label: "Male", value: "male" }, { label: "Female", value: "female" }]}
                        />
                        <InputField
                          type="date"
                          label="DOB"
                          error={formState.errors['dob']}
                          registration={register('dob')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          label="Nationality"
                          error={formState.errors['nationality']}
                          registration={register('nationality')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          type="number"
                          label="Phone_number"
                          error={formState.errors['phoneNumber']}
                          registration={register('phoneNumber')}
                          placeholder='Write a text here...'
                        />
                        <InputField
                          type="text"
                          label="Email"
                          error={formState.errors['email']}
                          registration={register('email')}
                          placeholder='Write a text here...'
                        />
                      </div>
                    </div>
                  </div>

                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepTwo;
