import React, { useEffect, useState } from 'react';
import { Stepper, Step, StepLabel, Button } from '@mui/material';
import { AddAdvertisement } from '@/api/Advertisement/add';
import { getUser } from '@/features/auth';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import SortTitle from './SortTitle';
import MainCatagories from './mainCatagories';
import SubCatagories from './SubCatagories';
import StepFirst from './StepFirst';
import StepTwo from './StepTwo';
import StepThird from './StepThird';
import StepFourth from './StepFourth';
import StepFifth from './stepFifth';
import StepSixth from './StepSixth';
import StepSeven from './StepSeven';
import Disclamer from './Discamer';
const steps = [
  '',
  '',
  'Basic Info',
  "The Profile's Visibility",
  'Basic Info ',
  'Desired Housing',
  'Desired Areas',
  'Other Info',
  'Additional information about yourself',
];

export const PropertyForTeanet = () => {
  const router = useNavigate();
  const [activeStep, setActiveStep] = useState(0);
  const [formData, setFormData] = useState<any>({});
  const [currentUser, setCurentUser] = useState<string | null>(null);
  const { addNotification } = useNotificationStore();
  const handleNext = () => {
    setActiveStep((prevActiveStep) => prevActiveStep + 1);
  };

  const handleBack = () => {
    setActiveStep((prevActiveStep) => prevActiveStep - 1);
  };

  const handleReset = () => {
    setActiveStep(0);
  };

  const handdleNextSubmit = (data: any) => {
    setFormData((prevData: any) => ({
      ...prevData,
      ...data,
    }));
    handleNext();
  };

  const handdleFormMainSubmit = async () => {
    if (currentUser) {
      await AddAdvertisement({
        ...formData,
        agency_id: currentUser,
        location: formData?.house_no + formData?.postal_code,
        latitude: '0.0',
        longitude: '0.0',
        is_draft: 'no',
        price: '0',
      });
      addNotification({
        type: 'success',
        title: 'Succes',
        message: 'Advertisement added succesfully',
      });
      router('/agency');
    }
  };

  const getUserDetails = async () => {
    const res = await getUser();
    setCurentUser(res?.data?.customer_id);
  };
  useEffect(() => {
    getUserDetails();
  }, []);
  const renderStepContent = (step: number) => {
    switch (step) {
      case 0:
        return (
          <SortTitle
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 1:
        return (
          <MainCatagories
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 2:
        return (
          <SubCatagories
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 3:
        return (
          <StepFirst
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      // case 4:
      //   return (
      //     <StepFirst
      //       onNext={(values: any) => handdleNextSubmit(values)}
      //       formData={formData}
      //       onBack={handleBack}
      //     />
      //   );
      case 4:
        return (
          <StepTwo
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 5:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 6:
        return (
          <StepFourth
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 7:
        return (
          <StepFifth
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 8:
        return (
          <Disclamer
            onNext={handdleFormMainSubmit}
            onBack={handleBack}
            formData={formData}
            labbel="Discription"
            keyType="property_description"
          />
        );
      default:
        return 'Unknown step';
    }
  };
  const renderTitle = (step: number) => {
    switch (step) {
      case 0:
        return 'Enter a short title to describe your listing';
      case 1:
        return 'Enter a short title to describe your listing';
      case 2:
        return 'Now choose the right category for your listing';
      default:
        return 'Create an ad by filling in the form below.';
    }
  };
  return (
    <div className="section property-projects py-5 mt-6">
      <div className="container">
        <h1 className="text-center text-dark mb-5">{renderTitle(activeStep)}</h1>

        <div className="row">
          <div className="col-md-3">
            <Stepper activeStep={activeStep} orientation="vertical">
              {steps.map((label, index) => (
                <Step key={index}>
                  <StepLabel>{label}</StepLabel>
                </Step>
              ))}
            </Stepper>
          </div>

          <div className="col-md-9">
            <div className="step-content">
              {activeStep === steps.length ? (
                <div>
                  <p>All steps completed - you're finished!</p>
                  <Button onClick={handleReset}>Reset</Button>
                </div>
              ) : (
                <div>{renderStepContent(activeStep)}</div>
              )}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
