import prevArrow from '@/assets/arrowPrev.png';
import MainCatagores from '@/config/MainCatagores';

const MainCatagories = ({ formData, onNext, onBack }: any) => {
  console.log('formdata ===================>', formData);

  const handdleSubmit = (value: any) => {
    value = { ...value };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <div className="w-full grid grid-cols-1 grid-rows-auto gap-4 next-prev-buttons">
              {MainCatagores?.map((item) => {
                return (
                  <div
                    className={`flex justify-between p-4 border rounded cursor-pointer`}
                    onClick={() => handdleSubmit({ main_catatgories: item?.value })}
                  >
                    <p
                      className={`${
                        formData?.main_catatgories === item?.value ? 'color-red-300' : ''
                      }`}
                    >
                      {item?.label}
                    </p>{' '}
                    <div>&gt;</div>
                  </div>
                );
              })}
            </div>
            <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
              <span className="arrow prev-arrow cursor-pointer" onClick={onBack}>
                <img src={prevArrow} className="d-block w-100" alt="" />
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default MainCatagories;
