import nextArrow from '@/assets/arrowNext.png';
import { Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import React, { useState } from 'react';
import { z } from 'zod';
import { SingleImageUploder } from '@/components/Elements/upload/SingleImageUploader';
import subCatagories from '@/config/subcatagories';
import { InputPhone } from '@/components/Form/InputPhone';
const schema = z.object({
  short_title: z.string().min(1, 'Required.'),
  company_name: z.string().min(1, 'Required.'),
  description: z.string().min(1, 'Required.'),
  location: z.string().min(1, 'Required.'),
  rent: z.string().min(1, 'Required.'),
  established_year: z.string().min(1, 'Required.'),
  years_of_work: z.string().min(1, 'Required.'),
  premises: z.string().min(1, 'Required.'),
});
type FormData = z.infer<typeof schema>;

const StepFirst = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    documents: formData?.property_document ?? '',
  });
  const [mediaError, setMediaError] = useState({
    image_data: false,
    videos: false,
    documents: false,
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    if (media?.image_data === '') {
      const updatedError = { ...mediaError, image_data: true };
      setMediaError(updatedError);
      return;
    }
    if (media?.videos === '') {
      const updatedError = { ...mediaError, videos: true };
      setMediaError(updatedError);
      return;
    }
    if (media?.documents === '') {
      const updatedError = { ...mediaError, documents: true };
      setMediaError(updatedError);
      return;
    }
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Property Information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Property Information</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  <div className="row">
                    <div className="col-md-3">
                      <div className="form-block d-flex flex-column gap-2">
                        <TextAreaField
                          rows={4}
                          error={formState.errors['short_title']}
                          registration={register('short_title')}
                          label="Short Title"
                        />
                        <SingleImageUploder
                          src={media?.image_data}
                          setImage={(img) => handdleMediaChange(img, 'image_data')}
                          labbel="Images"
                          error={mediaError?.image_data}
                        />
                        <SingleImageUploder
                          src={media?.videos}
                          setImage={(img) => handdleMediaChange(img, 'videos')}
                          labbel="Videos"
                          error={mediaError?.videos}
                        />
                        <SingleImageUploder
                          src={media?.documents}
                          setImage={(img) => handdleMediaChange(img, 'documents')}
                          labbel="Documents"
                          error={mediaError?.documents}
                        />
                      </div>
                    </div>

                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="Company name "
                          error={formState.errors['company_name']}
                          registration={register('company_name')}
                        />

                        <TextAreaField
                          label="Description"
                          error={formState.errors['description']}
                          registration={register('description')}
                        />

                        <InputField
                          label="Location turnover "
                          type="text"
                          error={formState.errors['location']}
                          registration={register('location')}
                        />
                        <InputField
                          label="Rent"
                          type="number"
                          error={formState.errors['rent']}
                          registration={register('rent')}
                        />
                        <InputField
                          label="Establishing year"
                          type="text"
                          error={formState.errors['established_year']}
                          registration={register('established_year')}
                        />
                        <InputField
                          label="In these premises from"
                          type="number"
                          error={formState.errors['premises']}
                          registration={register('premises')}
                        />
                        <InputField
                          label="Years of work"
                          type="number"
                          error={formState.errors['years_of_work']}
                          registration={register('years_of_work')}
                        />
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFirst;
