import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import { z } from 'zod';
import subCatagories from '@/config/subcatagories';
import { MapMarker, LocationInput, MapViwerWithSearch } from '@/components/Elements/map/MapMarker';
import { Button } from '@mui/material';
const schema = z.object({
  total_turnover: z.string().min(1, 'Required.'),
  salary_percentage: z.string().min(1, 'Required.'),
  other_operating_cost: z.string().min(1, 'Required.'),
  cost: z.string().min(1, 'Required.'),
});
type FormData = z.infer<typeof schema>;

const StepFoutrh = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Financial information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Complete the following fields</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-12">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="Turnover 2023"
                          type="number"
                          error={formState.errors['total_turnover']}
                          registration={register('total_turnover')}
                        />

                        <InputField
                          type="number"
                          label="Salary percentage"
                          error={formState.errors['salary_percentage']}
                          registration={register('salary_percentage')}
                        />
                      </div>
                    </div>
                    <div className="col-md-12">
                      <div className="form-block flex flex-row gap-3 items-center">
                        <div className="col-md-4">
                          <InputField
                            type="number"
                            label="Other operating costs"
                            error={formState.errors['other_operating_cost']}
                            registration={register('other_operating_cost')}
                          />
                        </div>
                        <div className="col-md-4">
                          <InputField
                            type="number"
                            label="Cost"
                            error={formState.errors['cost']}
                            registration={register('cost')}
                          />
                        </div>
                        <Button>Add</Button>
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFoutrh;
