import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { Form, TextAreaField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { z } from 'zod';

const schema = z.object({
  address: z.string().min(1, 'Required.'),
  reason_for_sale: z.string().min(1, 'Required.'),
  area: z.string().min(1, 'Required.'),
  term_of_lease: z.string().min(1, 'Required.'),
  number_of_employes: z.string().min(1, 'Required.'),
  website_link: z.string().min(1, 'Required.'),
});
type FormData = z.infer<typeof schema>;

const StepTwo = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Rent/The locations
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3"> Complete the following fields</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          type="text"
                          label="Address"
                          error={formState.errors['address']}
                          registration={register('address')}
                        />
                        <InputField
                          type="text"
                          label="Reason for sale "
                          error={formState.errors['reason_for_sale']}
                          registration={register('reason_for_sale')}
                        />
                        <InputField
                          type="text"
                          label="Area"
                          error={formState.errors['area']}
                          registration={register('area')}
                        />
                        <InputField
                          type="text"
                          label="Term of lease"
                          error={formState.errors['term_of_lease']}
                          registration={register('term_of_lease')}
                        />
                        <InputField
                          type="text"
                          label=" Number of employees "
                          error={formState.errors['number_of_employes']}
                          registration={register('number_of_employes')}
                        />
                        <InputField
                          type="text"
                          label="Website link"
                          error={formState.errors['website_link']}
                          registration={register('website_link')}
                        />
                      </div>
                    </div>
                  </div>

                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepTwo;
