import nextArrow from '@/assets/arrowNext.png';
import { Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import React, { useState } from 'react';
import { z } from 'zod';
import { SingleImageUploder } from '@/components/Elements/upload/SingleImageUploader';
import subCatagories from '@/config/subcatagories';
import { InputPhone } from '@/components/Form/InputPhone';
const schema = z.object({
  property_name: z.string().min(1, 'This field is required.'),
  property_type: z.string().min(10, 'Phone number must be at least 10 digits'),
  company_establed_year: z.string().min(1, 'This field is required.'),
  company_email: z.string().min(1, 'This field is required.'),
  phone_number: z.string().min(1, 'This field is required.'),
  address: z.string().min(1, 'This field is required.'),
});
type FormData = z.infer<typeof schema>;
const StepFirst = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Property Information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Property Information</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  <div className="row">
                    <div className="col-md-3">
                      <div className="form-block d-flex flex-column gap-2">
                        <TextAreaField
                          rows={4}
                          error={formState.errors['property_name']}
                          registration={register('property_name')}
                          label="Property name"
                        />
                        <SingleImageUploder
                          src={media?.image_data}
                          setImage={(img) => handdleMediaChange(img, 'image_data')}
                          labbel="Property Images"
                        />
                        <SingleImageUploder
                          src={media?.videos}
                          setImage={(img) => handdleMediaChange(img, 'videos')}
                          labbel="Property Videos"
                        />
                        <SingleImageUploder
                          src={media?.property_document}
                          setImage={(img) => handdleMediaChange(img, 'property_document')}
                          labbel="Partners Data"
                        />
                      </div>
                    </div>

                    <div className="col-md-9">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="Property Type"
                          error={formState.errors['property_type']}
                          registration={register('property_type')}
                        />

                        <InputField
                          label="Company Established (In Years)"
                          type="number"
                          error={formState.errors['company_establed_year']}
                          registration={register('company_establed_year')}
                        />

                        <InputField
                          label="Company Email Address"
                          type="email"
                          error={formState.errors['company_email']}
                          registration={register('company_email')}
                        />

                        <InputPhone
                          label="Phone Number"
                          error={formState.errors['phone_number']}
                          registration={register('phone_number')}
                        />
                        <InputField
                          label="Company Address"
                          error={formState.errors['address']}
                          registration={register('address')}
                        />
                      </div>
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepFirst;
