import React, { useState } from 'react';
import nextArrow from '@/assets/arrowNext.png';
import prevArrow from '@/assets/arrowPrev.png';
import { Form, SelectField } from '@/components/Form';
import { InputField } from '@/components/Form/InputField';
import { TextAreaField } from '@/components/Form/TextareaField';
import { z } from 'zod';
import subCatagories from '@/config/subcatagories';
import { MapMarker, LocationInput, MapViwerWithSearch } from '@/components/Elements/map/MapMarker';
const schema = z.object({
  valuation: z.string().min(1, 'This field is required.'),
  Share_for_Sale: z.string().min(1, 'THis field required.'),
  price: z.string().min(1, 'This field is required.'),
  postal_code: z.string().min(1, 'This field is required.'),
  account_number: z.string().min(1, 'This field is required.'),
  issue_account_number: z.string().min(1, 'This field is required.'),
  post_number: z.string().min(1, 'This field is required.'),
  maximum_drawing: z.string().min(1, 'This field is required.'),
  minimum_drawing: z.string().min(1, 'This field is required.'),
  remaining_shares: z.string().min(1, 'This field is required.'),
  number_of_shares_before_issue: z.string().min(1, 'This field is required.'),
  nominal_share_price: z.string().min(1, 'This field is required.'),
  email: z.string().min(1, 'This field is required.'),
  website: z.string().min(1, 'This field is required.'),
  location: z.string().min(1, 'This field is required.'),
});
type FormData = z.infer<typeof schema>;

const StepThird = ({ formData, onNext, onBack }: any) => {
  const [activeTab, setActiveTab] = useState('propertyInfo');
  const [media, setMedia] = useState({
    image_data: formData?.image_data ?? '',
    videos: formData?.videos ?? '',
    property_document: formData?.property_document ?? '',
  });
  const handleTabClick = (tab: string) => {
    setActiveTab(tab);
  };
  const handdleMediaChange = (value: string, type: string) => {
    let current = media;
    current = { ...current, [type]: value };
    setMedia(current);
  };
  const handdleSubmit = (value: any) => {
    value = { ...value, ...media };
    onNext(value);
  };
  return (
    <div className="form-component">
      <div className="d-flex justify-content-between mb-4">
        <div className="d-flex tab-buttons">
          <button
            className={`tab-button ${activeTab === 'propertyInfo' ? 'active' : ''}`}
            onClick={() => handleTabClick('propertyInfo')}
          >
            Company Information
          </button>
        </div>
      </div>

      <div className="card">
        <div className="card-body">
          <div className="property-info-form">
            <p className="form-heading pb-2 mb-3">Company Information</p>
            <Form<FormData, typeof schema>
              onSubmit={handdleSubmit}
              id="my-form"
              schema={schema}
              options={{
                defaultValues: {
                  ...formData,
                },
              }}
            >
              {({ register, formState, getValues, control }) => (
                <>
                  {console.log(formState.errors)}
                  <div className="row">
                    <div className="col-md-6">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="Valuation"
                          error={formState.errors['valuation']}
                          registration={register('valuation')}
                        />

                        <InputField
                          label="Share for Sale"
                          type="number"
                          error={formState.errors['Share_for_Sale']}
                          registration={register('Share_for_Sale')}
                        />

                        <InputField
                          label="Price Per Share NOK"
                          type="text"
                          error={formState.errors['price']}
                          registration={register('price')}
                        />
                        <InputField
                          label="Postal Code"
                          error={formState.errors['postal_code']}
                          registration={register('postal_code')}
                        />

                        <InputField
                          label="Bank Account Created "
                          type="number"
                          error={formState.errors['account_number']}
                          registration={register('account_number')}
                        />

                        <InputField
                          label="Issue Account Number"
                          type="text"
                          error={formState.errors['issue_account_number']}
                          registration={register('issue_account_number')}
                        />
                        <InputField
                          label="Post Number"
                          type="text"
                          error={formState.errors['post_number']}
                          registration={register('post_number')}
                        />
                        <TextAreaField
                          label="Self report"
                          error={formState.errors['price']}
                          registration={register('price')}
                        />
                      </div>
                    </div>
                    <div className="col-md-6">
                      <div className="form-block d-flex flex-column gap-2">
                        <InputField
                          label="Maximum Drawing"
                          error={formState.errors['maximum_drawing']}
                          registration={register('maximum_drawing')}
                        />

                        <InputField
                          label="Minimum Drawing"
                          type="number"
                          error={formState.errors['minimum_drawing']}
                          registration={register('minimum_drawing')}
                        />

                        <InputField
                          label="Remaining Shares"
                          type="text"
                          error={formState.errors['remaining_shares']}
                          registration={register('remaining_shares')}
                        />
                        <InputField
                          label="Number of Shares Before Issue"
                          error={formState.errors['number_of_shares_before_issue']}
                          registration={register('number_of_shares_before_issue')}
                        />

                        <InputField
                          label="Nominal Share Price NOK"
                          type="text"
                          error={formState.errors['nominal_share_price']}
                          registration={register('nominal_share_price')}
                        />
                        <InputField
                          label="Number of Shares Before Issue"
                          type="email"
                          error={formState.errors['email']}
                          registration={register('email')}
                        />
                        <InputField
                          label="Company Website"
                          type="text"
                          error={formState.errors['website']}
                          registration={register('website')}
                        />
                      </div>
                    </div>
                    <div className="col-md-12">
                      <MapViwerWithSearch
                        label="Company Address"
                        error={formState.errors['location']}
                        registration={register('location')}
                      />
                    </div>
                  </div>
                  <div className="next-prev-buttons d-flex gap-4 align-items-center mt-5">
                    <span className="arrow prev-arrow" onClick={onBack}>
                      <img src={prevArrow} className="d-block w-100" alt="" />
                    </span>
                    <button
                      className="arrow next-arrow d-flex gap-2 align-items-center"
                      type="submit"
                    >
                      Save
                      <img src={nextArrow} className="d-block w-100" alt="" />
                    </button>
                  </div>
                </>
              )}
            </Form>
          </div>
        </div>
      </div>
    </div>
  );
};

export default StepThird;
