import React, { useEffect, useState } from 'react';
import { Stepper, Step, StepLabel, Button } from '@mui/material';
import StepFirst from './StepFirst';
import StepTwo from './StepTwo';
import StepThird from './StepThird';
import Disclamer from './Discamer';
import { AddAdvertisement } from '@/api/Advertisement/add';
import { getUser } from '@/features/auth';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
const steps = ['Property Information', 'Add Shareholder', ' Company Information', 'Disclaimer'];

export const FindInvestor = () => {
  const router = useNavigate();
  const [activeStep, setActiveStep] = useState(0);
  const [formData, setFormData] = useState<any>({});
  const [currentUser, setCurentUser] = useState<string | null>(null);
  const { addNotification } = useNotificationStore();
  const handleNext = () => {
    setActiveStep((prevActiveStep) => prevActiveStep + 1);
  };

  const handleBack = () => {
    setActiveStep((prevActiveStep) => prevActiveStep - 1);
  };

  const handleReset = () => {
    setActiveStep(0);
  };

  const updateFormData = (stepData: any) => {
    setFormData((prevData: any) => ({
      ...prevData,
      ...stepData,
    }));
  };
  const handdleNextSubmit = (data: any) => {
    setFormData((prevData: any) => ({
      ...prevData,
      ...data,
    }));
    handleNext();
  };
  const handdleFormMainSubmit = async () => {
    if (currentUser) {
      await AddAdvertisement({
        ...formData,
        agency_id: currentUser,
        location: formData?.house_no + formData?.postal_code,
        latitude: '0.0',
        longitude: '0.0',
        is_draft: 'no',
        price: '0',
      });
      addNotification({
        type: 'success',
        title: 'Succes',
        message: 'Advertisement added succesfully',
      });
      router('/agency');
    }
  };
  const getUserDetails = async () => {
    FindInvestor;
    const res = await getUser();
    setCurentUser(res?.data?.customer_id);
  };
  useEffect(() => {
    getUserDetails();
  }, []);
  const renderStepContent = (step: number) => {
    switch (step) {
      case 0:
        return (
          <StepFirst
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 1:
        return (
          <StepTwo
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 2:
        return (
          <StepThird
            onNext={(values: any) => handdleNextSubmit(values)}
            formData={formData}
            onBack={handleBack}
          />
        );
      case 3:
        return (
          <Disclamer
            onNext={handdleFormMainSubmit}
            onBack={handleBack}
            formData={formData}
            labbel="Discription"
            keyType="property_description"
          />
        );
      default:
        return 'Unknown step';
    }
  };

  return (
    <div className="section property-projects py-5">
      <div className="container">
        <h1 className="text-center text-dark mb-5">Add New Project for money ! </h1>

        <div className="row">
          <div className="col-md-3">
            <Stepper activeStep={activeStep} orientation="vertical">
              {steps.map((label, index) => (
                <Step key={index}>
                  <StepLabel>{label}</StepLabel>
                </Step>
              ))}
            </Stepper>
          </div>

          <div className="col-md-9">
            <div className="step-content">
              {activeStep === steps.length ? (
                <div>
                  <p>All steps completed - you're finished!</p>
                  <Button onClick={handleReset}>Reset</Button>
                </div>
              ) : (
                <div>{renderStepContent(activeStep)}</div>
              )}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
