import Footer from '@/components/Layout/Footer/Footer';
import React, { useEffect, useState } from 'react';
import { useNavigate, useParams, useSearchParams } from 'react-router-dom';
import './st.css';
import card2 from '@/assets/card2.png';
import card4 from '@/assets/card4.png';
import card5 from '@/assets/card5.png';
import card6 from '@/assets/escrow.png';
import 'react-responsive-modal/styles.css';
import UserHeadBar from '../components/UserHeadBar';
import PayPalButton from '@/components/Payments/Paypal/PayPalButton';
import { paypal } from '@/api/paypal/paypal';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';

export const SubscriptionPayment = () => {
  const { idSub } = useParams();
  const [queryParams] = useSearchParams();
  const price: string = queryParams.get('price');
  const discount: number = queryParams.get('discount');
  console.log(typeof discount);

  const navigate = useNavigate();

  const [isLoading, setIsLoading] = useState(false);
  const [paypalData, setPaypalData] = useState('');

  const percentageOff = (price: number, percentageValue: number): number => {
    return price * (1 - percentageValue / 100);
  };

  const netPrice = percentageOff(parseInt(price), discount);

  const finalAmount = netPrice.toString().split('.');

  const handleSubmit = async () => {
    setIsLoading(true);
    try {
      const data = await paypal(idSub, finalAmount[0]);
      setPaypalData(data?.payment_url);
    } finally {
      setIsLoading(false);
    }
  };

  useEffect(() => {
    if (paypalData != '') {
      window.open(paypalData);
    }
  }, [paypalData]);

  return (
    <>
      <BackdropLoader open={isLoading} />

      <UserHeadBar />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <section className="container pays mb-5">
        <div className="payment-Methods">
          <h3 className="mb-5">Select payment method</h3>
          <div className="row">
            <div
              role="button"
              className="col-md-3 col-4 outer-card"
              onClick={() =>
                navigate(`/user/subscription-payment/${idSub}?price=${price}&discount=${discount}`)
              }
            >
              <div className="card-box">
                <img src={card5} alt="CARDStripe" />
              </div>
            </div>
            <div role="button" className="col-md-3 col-4 outer-card" onClick={() => handleSubmit()}>
              <div className="card-box">
                <img src={card2} alt="CARDStripe" />
              </div>
            </div>
            <div className="col-md-3 col-4 outer-card">
              <div className="card-box">
                <img src={card4} alt="CARD" />
              </div>
            </div>
            <div className="col-md-3 col-4 outer-card">
              <div className="card-box">
                <img src={card6} alt="CARD" />
              </div>
            </div>
          </div>
        </div>
      </section>
      <Footer />
    </>
  );
};
