import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import React from 'react';
import { useSubscription } from '@/api/SubscriptionCustomer/getSubList';
import './st.css';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate } from 'react-router-dom';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import clsx from 'clsx';
import { postSubscription } from '@/api/SubscriptionCustomer/postSubscription';
import { postSubscriptionBasic } from '@/api/SubscriptionCustomer/postSubscriptionBasic';

export const SubscriptionType = () => {
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const { data: listing, isLoading } = useSubscription({ page: '1' });
  const auth = useAuth();
  const subscriptionplan = auth?.user?.subscription_id;
  const navigate = useNavigate();
  const previousData = storage.getSubmitFormData();
  const nextPage = previousData?.pageUrl;

  const changeStatusAction = async (id: string, price: string, discount: number) => {
    try {
      if (price == '0') {
        await postSubscriptionBasic(id);
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'You have selected the subscription successfully',
        });
        navigate('/user/profile');
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'You have selected the subscription successfully',
        });
        navigate(
          `/user/subscription-select-payment/${id}?price=${price}&discount=${discount !== null ? discount : 0
          }`
        );
      }
    } finally {
      console.log('');
    }
  };
  return (
    <>
      <section className="container">
        <section className="cardsd container grid">
          <div className="card__container grid">
            {isLoading ? (
              <MyListingLoader />
            ) : (
              <>
                <div className="row subscription-row plans">
                  {listing?.map((item, index) => {
                    return (
                      <div className="col-md-4 cfd" key={index}>
                        <article
                          className={clsx(
                            'card__content grid',
                            subscriptionplan === item.id ? 'selected-plan' : 'unselected'
                          )}
                        >
                          {item.discount !== null && item.discount !== 0 && (
                            <div className="card__pricing">
                              <div className="card__pricing-number">
                                <span className="fa-stack fa-lg">
                                  <i className="fa fa-certificate fa-stack-2x"></i>
                                  <i className="fa fa-tag fa-stack-1x fa-inverse"></i>
                                </span>
                                <span className="card__discount">{item.discount}% off</span>
                              </div>
                            </div>
                          )}

                          <header className="card__header">
                            <div className="row">
                              <div className="col-md-8 col-sm-4">
                                <h1 className="card__header-title">{item.plan_name}</h1>
                              </div>
                              <div className="col-md-4 col-sm-4">
                                <span className="card__header-subtitle">
                                  {' '}
                                  {localSymbol}{' '}
                                  {(parseFloat(item?.price) * localCurrency)?.toFixed(0) ?? ''}
                                </span>
                              </div>
                            </div>
                            <span className="proCounting">
                              Can add {item.property_count > 20 ? 'unlimited' : item.property_count}{' '}
                              properties
                            </span>
                          </header>
                          <hr />
                          <div className="sub-descript">
                            <p className="card_Description">{item.plan_description}</p>
                            <hr className="zInd" />
                            <ul className="card__list grid">
                              <li className="card__list-item">
                                {item.digital_rental_contract ? (
                                  <i className="fa-solid fa-check card__list-icon"></i>
                                ) : (
                                  <i className="fa-solid fa-xmark card__list-icon"></i>
                                )}
                                <p className="card__list-description">Digital Rental Contract</p>
                              </li>
                              <li className="card__list-item">
                                {item.notifications_stakeholders ? (
                                  <i className="fa-solid fa-check card__list-icon"></i>
                                ) : (
                                  <i className="fa-solid fa-xmark card__list-icon"></i>
                                )}
                                <p className="card__list-description">Notifications Stakeholders</p>
                              </li>
                              <li className="card__list-item">
                                {item.visibility_among_ads ? (
                                  <i className="fa-solid fa-check card__list-icon"></i>
                                ) : (
                                  <i className="fa-solid fa-xmark card__list-icon"></i>
                                )}
                                <p className="card__list-description">Visibility Among Ads</p>
                              </li>
                              <li className="card__list-item">
                                {item.visibility_at_top ? (
                                  <i className="fa-solid fa-check card__list-icon"></i>
                                ) : (
                                  <i className="fa-solid fa-xmark card__list-icon"></i>
                                )}
                                <p className="card__list-description">Visibility At Top</p>
                              </li>
                              <li className="card__list-item">
                                {item.information_of_local_area ? (
                                  <i className="fa-solid fa-check card__list-icon"></i>
                                ) : (
                                  <i className="fa-solid fa-xmark card__list-icon"></i>
                                )}
                                <p className="card__list-description">Information Of Local Area</p>
                              </li>
                            </ul>
                          </div>
                          {auth.user?.has_subscription == true ? (
                            <>
                              {subscriptionplan === item.id ? (
                                <>
                                  <button className="card__button">Subscribed</button>
                                </>
                              ) : (
                                <>
                                  <button
                                    onClick={() =>
                                      changeStatusAction(item.id, item.price, item.discount)
                                    }
                                    className="card__button"
                                  >
                                    Upgrade Plan
                                  </button>
                                </>
                              )}
                            </>
                          ) : (
                            <>
                              <button
                                onClick={() =>
                                  changeStatusAction(item.id, item.price, item.discount)
                                }
                                className="card__button"
                              >
                                Subscribe plan
                              </button>
                            </>
                          )}
                        </article>
                      </div>
                    );
                  })}
                </div>
              </>
            )}
          </div>
        </section>
      </section>
    </>
  );
};
