import React from 'react';
import { useNavigate } from 'react-router-dom';
import { Housing } from '@/types';
import '../user.css';
import { formatMoney, formatDate } from '@/utils/format';
import { Image } from '@/components/Elements';
import house from '@/assets/house.png';
import propertyType from '@/constants/propertyType';
import { useHousingListing } from '@/api/housing/getHousingList';
import { changeFav } from '@/api/housing/changeFav';
import { useNotificationStore } from '@/stores/notifications';
import { useAuth } from '@/lib/auth';

const HouseRent = ({
  item,
  headData,
  editIcon,
  deleteIcon,
  setHeartClicked,
}: {
  item: Housing;
  deleteIcon: boolean;
  headData: boolean;
  editIcon: boolean;
  setHeartClicked: any;
}) => {
  const { refetch } = useHousingListing({ page: '1' });
  const navigate = useNavigate();
  const { user } = useAuth();
  item.id == 12121 ? refetch() : '';
  // const changeStatusAction = async (id: string, accept: boolean) => {
  //   try {
  //     await changeFav(id, accept);
  //   } finally {
  //     setHeartClicked(true);
  //   }
  // };
  const changeStatusAction = async (id: string, accept: boolean) => {
    try {
      if (user) {
        await changeFav(id, accept);
        setHeartClicked(true);
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Warning',
          type: 'info',
          message: 'Please Login first!',
        });
        navigate('/auth/login');
      }
    } finally {
    }
  };
  const handleClick = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeStatusAction(item.id, false);
  };
  const handleClick2 = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeStatusAction(item.id, true);
  };
  const handleEdit = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    navigate(`/user/create-house-rent/${item.id}?type=RentProperty`);
  };

  return (
    <>
      <div className="col-12 col-md-6 col-lg-4 home-prop-col">
        <div className="item-box border p-2 position-relative">
          {headData == true ? (
            <div className="head-functions">
              <span className="status">Wanted House For Rent</span>
              <div className="d-flex icons">
                {editIcon == true ? (
                  <span>
                    <button onClick={handleEdit}>
                      <i className="fa-solid fa-pen" />
                    </button>
                  </span>
                ) : null}
                {deleteIcon == true ? (
                  <span>
                    <i className="fa-solid fa-trash" />
                  </span>
                ) : null}
              </div>
            </div>
          ) : (
            <div className="head-functions fav-lists">
              <span className="status">{item.first_name}</span>
              {item.favourite == true ? (
                <button onClick={handleClick}>
                  <i className="fa-solid fa-heart"></i>
                </button>
              ) : (
                <button onClick={handleClick2}>
                  <i className="fa-regular fa-heart"></i>
                </button>
              )}
            </div>
          )}
          <Image imagefallback={house} className="itemImage" alt="banner" src={item.image} />
          <h6 className="mt-3 text-dark">{item.first_name}</h6>
          {location && (
            <p className="text-sm">
              <i className="fa-solid fa-map-location-dot"></i>
              {item.address}
            </p>
          )}
          <div className="tab">
            <p>Max month price</p>
            <p>{formatMoney(item.max_month_price)}</p>
          </div>
          <div className="tab">
            <p>Number of residents</p>
            <p>{item.no_of_resident}</p>
          </div>
          <div className="tab">
            <p>Property type</p>
            <p>{propertyType[item?.property_type ?? 'one_bhk']}</p>
          </div>
          <div className="tab">
            <p>Wanting From</p>
            <p>{formatDate(item.wanted_from)}</p>
          </div>
        </div>
      </div>
    </>
  );
};

export default HouseRent;
