import React, { useEffect, useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { Investment } from '@/types';
import '../user.css';
import { formatMoney, formatPrice, trimSixty } from '@/utils/format';
import { Image } from '@/components/Elements';
import { changeFav } from '@/api/propertyInvestment/changeFav';
import plus from '@/assets/plus.png';
import FileViewer from '@/components/Viewer/FileViewer';
import { Modal } from 'react-responsive-modal';
import { Button } from '@/components/Elements/Button';
import { changeAllFav } from '@/api/changeAllFav';
import { useNotificationStore } from '@/stores/notifications';
import { deletePropertyItem } from '@/api/deletePropertyItem';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import i18next from 'i18next';

const InvestmentProject = ({
  item,
  headData,
  editIcon,
  deleteIcon,
  heartIcon,
  heartFavIcon,
  setHeartClicked,
  setDeleteClicked,
}: {
  deleteIcon: boolean;
  item: Investment;
  headData: boolean;
  editIcon: boolean;
  heartFavIcon: boolean;
  heartIcon: boolean;
  setHeartClicked: any;
  setDeleteClicked: any;
}) => {
  const navigate = useNavigate();
  const [photo, setPhoto] = useState<any>();
  const localSymbol = storage.getSymbol();
  const localAmount = storage.getAmount();

  const [pics, setPics] = useState<any>();
  const [favIcon, setFavIcon] = useState<boolean>(!!item.is_favourite);
  useEffect(() => {
    try {
      const evaluatedData = eval(item?.image_data);
      setPics(evaluatedData);

      if (item?.image_data && item?.image_data.length > 0 && pics) {
        setPhoto(pics[0]?.image);
      }
    } catch (error) {
      console.error('Error evaluating image_data:', error);
    }
  }, [item?.image_data, pics]);

  const [open, setOpen] = useState(false);
  const { user } = useAuth();

  const onOpenModals = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    setOpen(true);
  };
  const [buttonLoading, setButtonLoading] = useState<boolean>(false);
  const onCloseModal = () => setOpen(false);

  const typeVal = 'InvestmentProject';
  const deleleItems = async (id: string, types: string) => {
    try {
      setButtonLoading(true);
      await deletePropertyItem(id, types);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Item deleted successfully!',
      });
    } finally {
      setDeleteClicked(true);
      setOpen(false);
      setButtonLoading(false);
    }
  };

  const deleleItemsSelect = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    deleleItems(item.id, typeVal);
  };
  const changeStatusAction = async (id: string, accept: boolean) => {
    try {
      if (user) {
        await changeFav(id, accept);
        setHeartClicked(true);
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Warning',
          type: 'info',
          message: 'Please Login first!',
        });
        navigate('/auth/login');
      }
    } finally {
    }
  };
  const handleClick = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    setFavIcon((val) => !val);
    changeStatusAction(item.id, false);
  };
  const handleClick2 = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeStatusAction(item.id, true);
    setFavIcon((val) => !val);
  };
  const handleEdit = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    navigate(`/user/project-money/${item.id}?type=InvestmentProject`);
  };
  const changeUnfavStatusAction = async (id: string, type: string) => {
    try {
      await changeAllFav(id, type);
    } finally {
      setHeartClicked(true);
    }
  };
  const handleUnfavourite = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeUnfavStatusAction(item.id, item.type);
    // refetch();
  };
  const handleNavigate = () => {
    navigate(`/investment-detail/${item.id}?type=InvestmentProject`);
  };

  return (
    <>
      <div className="col-12 col-md-6 col-lg-4 home-prop-col">
        <button className="housingButton" onClick={handleNavigate}>
          <div className="item-box border p-2 position-relative">
            {headData == true ? (
              <div className="head-functions">
                <span className="status">{i18next.t('Investment Project')}</span>
                <div className="d-flex icons">
                  {editIcon == true ? (
                    <span>
                      <button onClick={handleEdit}>
                        <i className="fa-solid fa-pen" />
                      </button>
                    </span>
                  ) : null}
                  {deleteIcon == true ? (
                    <span>
                      <button onClick={onOpenModals}>
                        <i className="fa-solid fa-trash" />
                      </button>
                    </span>
                  ) : null}
                  {heartIcon == true ? (
                    <div className=" fav-lists">
                      {favIcon ? (
                        <button onClick={handleClick}>
                          <i className="fa-solid fa-heart"></i>
                        </button>
                      ) : (
                        <button onClick={handleClick2}>
                          <i className="fa-regular fa-heart"></i>
                        </button>
                      )}
                    </div>
                  ) : null}
                  {heartFavIcon == true ? (
                    <div className=" fav-lists">
                      <button onClick={handleUnfavourite}>
                        <i className="fa-solid fa-heart"></i>
                      </button>
                    </div>
                  ) : null}
                </div>
              </div>
            ) : (
              <div className="head-functions2 ">
                {item.is_favourite == true ? (
                  <button onClick={handleClick}>
                    <i className="fa-solid fa-heart"></i>
                  </button>
                ) : (
                  <button onClick={handleClick2}>
                    <i className="fa-regular fa-heart"></i>
                  </button>
                )}
              </div>
            )}
            {/* {item?.image_data.length == 0 ? (
              <FileViewer file={plus ?? ''}></FileViewer>
            ) : (
              <Image
                // imagefallback={eval(item?.image_data)[0]?.image}
                className="itemImage"
                alt="banner"
                src={photo ?? ''}
              />

            )} */}

            {item?.image_data ? (
              <>
                {item?.image_data.length == 0 ? (
                  <FileViewer file={plus ?? ''}></FileViewer>
                ) : (
                  <Image
                    // imagefallback={eval(item?.image_data)[0]?.image}
                    className="itemImage"
                    alt="banner"
                    src={photo ?? ''}
                  />
                )}
              </>
            ) : null}
            <h6 className="mt-3 text-dark">{item?.offered_by}</h6>
            <p className="text-sm stx">{item.location}</p>
            <p className="text-sm asd">
              {i18next.t('Development')} | {i18next.t('Equity')}
            </p>
            <div className="greyTxt row">
              <p className="col-md-6 col-6 leftw">
                {i18next.t('Target return on cost')} <br />
                {/* {formatMoney(item?.target_return_on_cost)} */}
                {localSymbol} {formatPrice(item.target_return_on_cost * localAmount)}
              </p>
              <p className="col-md-6 col-6 leftww">
                {i18next.t('Target IRR')}
                <br />
                {/* {formatMoney(item?.target_irr)} */}
                {localSymbol} {formatPrice(item.target_irr * localAmount)}
              </p>
            </div>
          </div>
          <Modal open={open} onClose={onCloseModal} center>
            <section className="model-datas">
              <h3> {i18next.t('Are you sure you want to delete this item ?')}</h3>
            </section>
            <p className="btn-lines delete-bots">
              <Button isLoading={buttonLoading} onClick={deleleItemsSelect}>
                {i18next.t('Yes')}
              </Button>
              <Button onClick={onCloseModal}>{i18next.t('No')}</Button>
            </p>
          </Modal>
        </button>
      </div>
    </>
  );
};

export default InvestmentProject;
