import React from 'react';
import '../../user.css';
import { DealListing } from '@/types/Deals/DealListing';
import myDealServiceType from '@/constants/myDealServiceType';
import MyDealPropertyItem from './MyDealPropertyItem';
import MyDealSaleItem from './MyDealSaleItem';

const MyDealListing = ({
  item,
  myDeal,
  myLead,
}: {
  item: DealListing;
  myDeal: boolean;
  myLead: boolean;
}): React.ReactElement => {
  switch (item.type) {
    case myDealServiceType.SALE_RENT:
      return <MyDealSaleItem item={item} signContract={true} call={false} />;
    case myDealServiceType.Property_Project:
      return (
        <>
          {myDeal == true ? (
            <MyDealPropertyItem item={item} signContract={true} call={false} />
          ) : null}
          {myLead == true ? (
            <MyDealPropertyItem item={item} signContract={false} call={true} />
          ) : null}
        </>
      );
    default:
      return <span> </span>;
      break;
  }
};

export default MyDealListing;
// {localSymbol} {(fCap?.equityPrice * localCurrency)?.toFixed(0) ?? ''}
