import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { HouseDeal } from '@/types/Deals/HouseDeal';
import '../../user.css';
import './MyDealItem.css';
import { formatMoney, timeFromNow, trimTen, trimThirty, trimTwenty } from '@/utils/format';
import { Image, Button } from '@/components/Elements';
import business from '@/assets/business.jpeg';
import storage from '@/utils/storage';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import axios from 'axios';
import { useAuth } from '@/lib/auth';
import i18next from 'i18next';
const MyDealPropertyItem = ({
  item,
  signContract,
  call,
}: {
  item: HouseDeal;
  signContract: boolean;
  call: boolean;
}) => {
  const navigate = useNavigate();
  const id = item.id;
  const person_name = item.name;
  const PageType = item.type;

  // const signId = item.contract_id;

  const [open, setOpen] = useState(false);
  const token = storage.getToken();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const auth = useAuth();
  const ownerEmail = auth.user?.email;
  console.log(ownerEmail);
  const axiosUrl = process.env.REACT_APP_API_URL;

  const onOpenModal = () => {
    axios.get(`${axiosUrl}/customer-api/show-number?id=${id}&type=${PageType}`, {
      headers: {
        Authorization: `${token}`,
      },
    });
    setOpen(true);
  };
  const onCloseModal = () => setOpen(false);

  const gotoContract = () => {
    axios.post(
      `${axiosUrl}/customer-api/contract_status`,
      { id, status_type: 'Accepted' },
      {
        headers: {
          Authorization: `${token}`,
        },
      }
    );
    navigate(`/user/contract?id=${id}&name=${person_name}`);
  };
  const gotoCancel = () => {
    axios.post(
      `${axiosUrl}/customer-api/contract_status`,
      { id, status_type: 'Rejected' },
      {
        headers: {
          Authorization: `${token}`,
        },
      }
    );
    onCloseModal();
  };

  // const gotoSignee = () => {
  //   navigate(`/user/contract-signin?id=${id}`);
  // };

  return (
    <>
      <div className="col-12 my-2 col-md-6">
        <div className="item-box border p-2 position-relative">
          <div className="row mydeals-rw">
            <div className="col-12 col-md-12 col-lg-4">
              {/* {call == true ? null : <span className="status-span">{item?.contract_status}</span>} */}

              <Image imagefallback={business} className="itemImage" alt="banner" src={item.image} />
            </div>
            <div className="col-12 col-md-12 col-lg-8">
              <div className="item-boxs">
                <span className="crated-span">{timeFromNow(item.created_date)} ago.</span>
                <h5>{trimTwenty(item?.property_name)}</h5>
                <p className="hr2">
                  <i className="fa-solid fa-location-dot"></i>
                  {trimThirty(item?.town)}
                </p>
                <div className="row ity">
                  <p className="leftSd col-md-7 col-7">{i18next.t('Purchase price')}</p>
                  <p className="rightSd col-5 col-md-5">
                    {' '}
                    {localSymbol} {(parseFloat(item?.price) * localCurrency)?.toFixed(0) ?? ''}
                  </p>
                </div>
                <div className="row ity">
                  <p className="leftSd col-md-7 col-7">{i18next.t('Return On Investment')}</p>
                  <p className="rightSd col-5 col-md-5">
                    {localSymbol}{' '}
                    {(parseFloat(item?.return_on_investment) * localCurrency)?.toFixed(0) ?? ''}
                  </p>
                </div>
                <div className="row ity">
                  <p className="leftSd col-md-7 col-7">{i18next.t('Cashflow PCM')}</p>
                  <p className="rightSd col-5 col-md-5">
                    {localSymbol}{' '}
                    {(parseFloat(item?.cashflow_pcm) * localCurrency)?.toFixed(0) ?? ''}
                  </p>
                </div>
                <div className="row ity">
                  <p className="leftSd col-md-7 col-7">Finder Fees</p>
                  <p className="rightSd col-5 col-md-5">
                    {localSymbol}{' '}
                    {(parseFloat(item?.finder_fees) * localCurrency)?.toFixed(0) ?? ''}
                  </p>
                </div>
                {signContract == true ? (
                  <>
                    <div className="botm-btn">
                      {item?.contract_status === 'Pending' ? (
                        <>
                          <div className="toop">
                            <button className="disable-button">
                              <i className="fa-solid fa-file-signature"></i>Sign Contract
                            </button>
                            <span className="tooltiptext">Property request has not viewed yet</span>
                          </div>
                        </>
                      ) : null}
                      {item?.contract_status === 'In-Progress' ? (
                        <div className="toop">
                          <button className="disable-button">
                            <i className="fa-solid fa-file-signature"></i>Sign Contract
                          </button>
                          <span className="tooltiptext">Property request has been viewed.</span>
                        </div>
                      ) : null}
                      {item?.contract_status === 'Rejected' ? (
                        <button>
                          <i className="fa-solid fa-ban"></i>Rejected
                        </button>
                      ) : null}
                      {item?.contract_status === 'Accepted' ? (
                        <div className="toop">
                          <button className="disable-button">
                            <i className="fa-solid fa-file-signature"></i>Sign Contract
                          </button>
                          <span className="tooltiptext">Property request under process.</span>
                        </div>
                      ) : null}
                      {item?.contract_status === 'Completed' ? (
                        <div className="toop">
                          <button className="disable-button">
                            <i className="fa-solid fa-file-signature"></i>Sign Contract
                          </button>
                          <span className="tooltiptext">
                            Contract is created , verification under process.
                          </span>
                        </div>
                      ) : null}
                      {item?.contract_status === 'Signed' ? (
                        <button
                          onClick={() => navigate(`/user/contract-signin?id=${item?.contract_id}`)}
                        >
                          <i className="fa-solid fa-file-signature"></i>Sign Contract
                        </button>
                      ) : null}
                      {item?.contract_status === 'Payment-Completed' ? (
                        <div className="toop">
                          <button>
                            Payment Done <i className="fa-solid fa-check"></i>
                          </button>
                          <span className="tooltiptext">Please wait for payment approval !</span>
                        </div>
                      ) : null}

                      {item?.contract_status === 'Deal-Completed' ? (
                        <div className="toop">
                          <button>
                            Deal Done <i className="fa-solid fa-check"></i>
                          </button>
                          <span className="tooltiptext">Online Payment Completed !</span>
                        </div>
                      ) : null}

                      {item?.contract_status === 'Payment-Rejected' ? (
                        <div className="toop">
                          <button
                          // onClick={() =>
                          //   navigate(`/user/verify-contract?id=${item?.contract_id}`)
                          // }
                          >
                            Payment Rejected <i className="fa-solid fa-check"></i>
                          </button>
                          <span className="tooltiptext">Payment Rejected</span>
                        </div>
                      ) : null}

                      {/* {item?.contract_status === 'Completed' ? (
                        <>
                          <button
                            onClick={() =>
                              navigate(`/user/contract-signin?id=${item?.contract_id}`)
                            }
                          >
                            <i className="fa-solid fa-file-signature"></i>Sign Contract
                          </button>
                        </>
                      ) : (
                        <>
                          <div className="toop">
                            <button className="disable-button">
                              <i className="fa-solid fa-file-signature"></i>Sign Contract
                            </button>
                            <span className="tooltiptext">
                              {item?.contract_status === 'Pending'
                                ? 'Property has not viewed yet.'
                                : 'Request is under process'}
                            </span>
                          </div>
                        </>
                      )} */}
                    </div>
                  </>
                ) : null}
                {call == true ? (
                  <>
                    <div className="botm-btn">
                      {item?.contract_status === 'Pending' ? (
                        <button onClick={onOpenModal}>
                          <i className="fa-solid fa-phone-volume"></i>Call Now
                        </button>
                      ) : null}
                      {item?.contract_status === 'In-Progress' ? (
                        <button onClick={onOpenModal}>
                          <i className="fa-solid fa-phone-volume"></i>Call Now
                        </button>
                      ) : null}
                      {item?.contract_status === 'Rejected' ? (
                        <button>
                          <i className="fa-solid fa-ban"></i>Rejected
                        </button>
                      ) : null}
                      {item?.contract_status === 'Accepted' ? (
                        <button onClick={gotoContract}>
                          <i className="fa-solid fa-phone-volume"></i>Contract
                        </button>
                      ) : null}
                      {item?.contract_status === 'Completed' ? (
                        <button
                          onClick={() => navigate(`/user/contract-signin?id=${item?.contract_id}`)}
                        >
                          <i className="fa-solid fa-file-signature"></i>Send for Signing
                        </button>
                      ) : null}
                      {item?.contract_status === 'Signed' ? (
                        <button
                          onClick={() => navigate(`/user/contract-signin?id=${item?.contract_id}`)}
                        >
                          <i className="fa-solid fa-file-signature"></i>Signed
                        </button>
                      ) : null}
                      {item?.contract_status === 'Payment-Completed' ? (
                        <button
                          onClick={() => navigate(`/user/verify-contract?id=${item?.contract_id}`)}
                        >
                          Verify Payment <i className="fa-solid fa-check"></i>
                        </button>
                      ) : null}
                      {item?.contract_status === 'Deal-Completed' ? (
                        <div className="toop">
                          <button>
                            Deal Done <i className="fa-solid fa-check"></i>
                          </button>
                          <span className="tooltiptext">Payment Verified !</span>
                        </div>
                      ) : null}
                      {item?.contract_status === 'Payment-Rejected' ? (
                        <div className="toop">
                          <button
                          // onClick={() =>
                          //   navigate(`/user/verify-contract?id=${item?.contract_id}`)
                          // }
                          >
                            Payment Rejected <i className="fa-solid fa-check"></i>
                          </button>
                          <span className="tooltiptext">Payment Rejected</span>
                        </div>
                      ) : null}
                    </div>
                  </>
                ) : null}

                <Modal open={open} onClose={onCloseModal} center>
                  <section className="model-datas">
                    <h3>Call Us</h3>
                    <p>
                      Lereom is simply a dummy text whixh is used for generating random text for you
                      website to make it more attaractive
                    </p>
                    <p className="telephones">{item.telephone}</p>
                  </section>
                  <div className="btn-lines row">
                    <div className="col-6 col-md-6 left">
                      <Button className="contractBUtn" onClick={gotoContract}>
                        <span className="fg"> Contract</span>
                      </Button>
                    </div>
                    <div className="col-6 col-md-6 right">
                      <Button onClick={gotoCancel}>{i18next.t('Cancel Deal')}</Button>
                    </div>
                  </div>
                </Modal>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
};

export default MyDealPropertyItem;
