import React, { useState } from 'react';
import { Link } from 'react-router-dom';
import { HouseDeal } from '@/types/Deals/HouseDeal';
import '../../user.css';
import './MyDealItem.css';
import { formatMoney } from '@/utils/format';
import { Image, Button } from '@/components/Elements';
import business from '@/assets/business.jpeg';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import storage from '@/utils/storage';
import i18next from 'i18next';

const MyDealSaleItem = ({
  item,
  signContract,
  call,
}: {
  item: HouseDeal;
  signContract: boolean;
  call: boolean;
}) => {
  const [open, setOpen] = useState(false);
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);

  return (
    <>
      <div className="col-12 my-2 col-md-6">
        <Link to="#">
          <div className="item-box border p-2 position-relative">
            <div className="row">
              <div className="col-md-4">
                <Image
                  imagefallback={business}
                  className="itemImage"
                  alt="banner"
                  src={item.image}
                />
              </div>
              <div className="col-md-8">
                <div className="item-boxs   ">
                  {/* <h3>{item.title}</h3>
                  <p>{item.location}</p> */}
                  <p className="head1">Luxuriours TownHouse</p>
                  <p className="head2">
                    <i className="fa-solid fa-location-dot"></i>Cambridge , CBN 54
                  </p>
                  <p className="head3">
                    {localSymbol} {(parseFloat(item?.price) * localCurrency)?.toFixed(0) ?? ''}
                  </p>
                  <div className="row smallIcon">
                    <div className="col-md-4 col-4 thy">
                      <i className="fa-solid fa-bath"></i>
                      <span className="icon3">{item.bathrooms} </span>
                      <span>{i18next.t('Baths')}</span>
                    </div>
                    <div className="col-md-4 col-4 thy">
                      <i className="fa-solid fa-bed"></i>
                      <span className="icon3">{item.bedrooms} </span>
                      <span>{i18next.t('Beds')}</span>
                    </div>
                    <div className="col-md-4 col-4 thy">
                      <i className="fa-solid fa-maximize"></i>{' '}
                      <span className="icon3">{item.size} </span>
                      <span>{i18next.t('sqFt')}</span>
                    </div>
                  </div>
                  {signContract == true ? (
                    <>
                      <div className="botm-btn tooltip">
                        <button disabled>
                          <i className="fa-solid fa-calendar-week"></i>
                          {i18next.t('Sign Contract')}
                        </button>
                        <span className="tooltiptext">{i18next.t('Tooltip text')}</span>
                      </div>
                    </>
                  ) : null}
                  {call == true ? (
                    <>
                      <div className="botm-btn">
                        <button onClick={onOpenModal}>
                          <i className="fa-solid fa-calendar-week"></i>
                          {i18next.t('Schedule')}
                        </button>
                      </div>
                    </>
                  ) : null}
                  <Modal open={open} onClose={onCloseModal} center>
                    <section className="model-datas">
                      <h3>{i18next.t('Thankyou for Calling Us')}</h3>
                      <p>
                        Lereom is simply a dummy text whixh is used for generating random text for
                        you website to make it more attaractive
                      </p>
                    </section>
                    <div className="btn-lines row">
                      <div className="col-6 col-md-6">
                        <Button className="rightAlignButton">
                          <Link to={'/user/contract'}>{i18next.t('Contract')}</Link>
                        </Button>
                      </div>
                      <div className="col-6 col-md-6 leftAlignButton">
                        <Button onClick={onCloseModal}>{i18next.t('Cancel Deal')}</Button>
                      </div>
                    </div>
                  </Modal>
                </div>
              </div>
            </div>
          </div>
        </Link>
      </div>
    </>
  );
};

export default MyDealSaleItem;
