import React, { useEffect, useState } from 'react';
import { useNavigate } from 'react-router-dom';
import '../user.css';
import { Image } from '@/components/Elements';

import { Investment } from '@/types';
import plus from '@/assets/plus.png';
import FileViewer from '@/components/Viewer/FileViewer';
import { deletePropertyItem } from '@/api/deletePropertyItem';
import { changeFav } from '@/api/bussinessForSale/changeFav';
import { useNotificationStore } from '@/stores/notifications';
import { useAuth } from '@/lib/auth';
import i18next from 'i18next';

const PropertyManagerItem = ({
  item,
  headData,
  editIcon,
  deleteIcon,
  setHeartClicked,
}: {
  item: Investment;
  deleteIcon: boolean;
  headData: boolean;
  editIcon: boolean;
  setHeartClicked: any;
}) => {
  const navigate = useNavigate();
  const handleNavigate = () => {
    navigate(`/property-for-rent-detail/${item.id}?type=RentProperty`);
  };
  const { user } = useAuth();
  const deleleItems = async (id: string, types: string) => {
    try {
      await deletePropertyItem(id, types);
    } finally {
    }
  };
  const typeVal = 'RentProperty';

  const deleleItemsSelect = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    deleleItems(item.id, typeVal);
  };

  const changeStatusAction = async (id: string, accept: boolean) => {
    try {
      if (user) {
        await changeFav(id, accept);
        setHeartClicked(true);
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Warning',
          type: 'info',
          message: 'Please Login first!',
        });
        navigate('/auth/login');
      }
    } finally {
    }
  };
  const handleClick = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeStatusAction(item.id, false);
  };
  const handleClick2 = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeStatusAction(item.id, true);
  };
  const handleEdit = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    navigate(`/user/add-property-for-rent/${item.id}?type=RentProperty`);
  };

  const [photo, setPhoto] = useState<any>();
  const [pics, setPics] = useState<any>();
  useEffect(() => {
    try {
      const evaluatedData = eval(item?.image_data);
      setPics(evaluatedData);

      if (item?.image_data.length === 0) {
        setPhoto(null);
      } else {
        if (pics && pics[0]?.image) {
          setPhoto(pics[0]?.image);
        }
      }
    } catch (error) {
      console.error('Error occurred during evaluation:', error);
    }
  }, [item.image_data, pics]);

  return (
    <>
      <div className="col-12 col-md-6 col-lg-4 home-prop-col">
        <div className="item-box border p-2 position-relative">
          <button onClick={handleNavigate}>
            {headData == true ? (
              <div className="head-functions">
                <span className="status">{i18next.t('Property For Rent')}</span>
                <div className="d-flex icons">
                  {editIcon == true ? (
                    <span>
                      <button onClick={handleEdit}>
                        <i className="fa-solid fa-pen" />
                      </button>
                    </span>
                  ) : null}
                  {deleteIcon == true ? (
                    <span>
                      <button onClick={deleleItemsSelect}>
                        <i className="fa-solid fa-trash" />
                      </button>
                    </span>
                  ) : null}
                </div>
              </div>
            ) : (
              <div className="head-functions fav-lists">
                <span className="status">{item.property_name}</span>
                {item.is_favourite == true ? (
                  <button onClick={handleClick}>
                    <i className="fa-solid fa-heart"></i>
                  </button>
                ) : (
                  <button onClick={handleClick2}>
                    <i className="fa-regular fa-heart"></i>
                  </button>
                )}
              </div>
            )}
            {item?.image_data.length == 0 ? (
              <FileViewer file={plus ?? ''}></FileViewer>
            ) : (
              <Image
                // imagefallback={eval(item?.image_data)[0]?.image}
                className="itemImage"
                alt="banner"
                src={photo ?? ''}
              />
            )}
            {/* <div className="head-functions2 ">
                <i className="fa-regular fa-heart"></i>
              </div>
              <Image imagefallback={house} className="itemImage" alt="banner" src={house} /> */}
            <h6 className="mt-3 text-dark">Invest in Project</h6>
            <p className="text-sm stx">
              {item.location}
              {/* <i className="fa-solid fa-star"></i>
              <i className="fa-solid fa-star"></i>
              <i className="fa-solid fa-star"></i>
              <i className="fa-solid fa-star"></i>
              <i className="fa-solid fa-star"></i> */}
              {/* <span>location : {item.location}</span> */}
            </p>
            <p className="text-sm">
              Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum
              has been the industrys standard dummy text
            </p>
            <p className="text-sm asd">
              {i18next.t('Development')} | {i18next.t('Equity')}
            </p>
            <div className="greyTxt row">
              <p className="col-md-6 col-6 leftw">
                {i18next.t('Price')} <br />
                {item.price}
              </p>
              <p className="col-md-6 col-6">
                Return on Investment
                <br />
                {item.return_on_investment}
              </p>
            </div>
          </button>
        </div>
      </div>
    </>
  );
};

export default PropertyManagerItem;
