import React, { useEffect, useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { PropertyProject } from '@/types';
import '../user.css';
import { formatMoney, formatPrice, trimThirty } from '@/utils/format';
import { Image } from '@/components/Elements';
import { changeFav } from '@/api/propertyProject/changeFav';
import plus from '@/assets/plus.png';
import FileViewer from '@/components/Viewer/FileViewer';
import { deletePropertyItem } from '@/api/deletePropertyItem';
import { Modal } from 'react-responsive-modal';
import { Button } from '@/components/Elements/Button';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import { useNotificationStore } from '@/stores/notifications';
import { changeAllFav } from '@/api/changeAllFav';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import i18next from 'i18next';

const PropertyProjects = ({
  item,
  headData,
  editIcon,
  deleteIcon,
  heartIcon,
  heartFavIcon,
  setHeartClicked,
  setDeleteClicked,
}: {
  deleteIcon: boolean;
  item: PropertyProject;
  headData: boolean;
  editIcon: boolean;
  heartFavIcon: boolean;
  heartIcon: boolean;
  setHeartClicked: any;
  setDeleteClicked: any;
}) => {
  const navigate = useNavigate();
  const [favIcon, setFavIcon] = useState<boolean>(!!item.is_favourite);
  const [open, setOpen] = useState(false);
  // const onOpenModal = () => setOpen(true);
  const { user } = useAuth();
  const onOpenModals = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    setOpen(true);
  };

  const onCloseModal = () => setOpen(false);
  const [buttonLoading, setButtonLoading] = useState<boolean>(false);

  const localSymbol = storage.getSymbol();
  const localAmount = storage.getAmount();

  const typeVal = 'PropertyProject';

  const deleleItems = async (id: string, types: string) => {
    try {
      setButtonLoading(true);
      await deletePropertyItem(id, types);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Item deleted successfully!',
      });
    } finally {
      setDeleteClicked(true);
      setOpen(false);
      setButtonLoading(false);
    }
  };

  const deleleItemsSelect = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    deleleItems(item.id, typeVal);
  };

  const handleNavigate = () => {
    navigate(`/property-detail/${item.id}?type=PropertyProject`);
  };
  const changeStatusAction = async (id: string, accept: boolean) => {
    try {
      if (user) {
        await changeFav(id, accept);
        setHeartClicked(true);
      } else {
        useNotificationStore.getState().addNotification({
          title: 'Warning',
          type: 'info',
          message: 'Please Login first!',
        });
        navigate('/auth/login');
      }
    } finally {
    }
  };
  const changeUnfavStatusAction = async (id: string, type: string) => {
    try {
      await changeAllFav(id, type);
    } finally {
      setHeartClicked(true);
    }
  };
  const handleUnfavourite = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeUnfavStatusAction(item.id, item.type);
    // refetch();
  };
  const handleClick = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    setFavIcon((val) => !val);
    changeStatusAction(item.id, false);
  };
  const handleClick2 = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    changeStatusAction(item.id, true);
    setFavIcon((val) => !val);
  };
  const handleEdit = (e: { stopPropagation: () => void }) => {
    e.stopPropagation();
    navigate(`/user/edit-property-project/${item.id}?type=PropertyProject`);
  };

  const [photo, setPhoto] = useState<any>();
  const [pics, setPics] = useState<any>();

  // useEffect(() => {
  //   if (item?.image_data) {
  //     setPics(eval(item?.image_data));
  //   }
  //   {
  //     item?.image_data
  //       ? item?.image_data.length == 0
  //         ? null
  //         : pics && setPhoto(pics[0]?.image)
  //       : null;
  //   }
  // }, [item.image_data, pics]);

  useEffect(() => {
    try {
      if (item?.image_data) {
        setPics(eval(item?.image_data));
      }
      if (item?.image_data && item?.image_data.length > 0 && pics) {
        setPhoto(pics[0]?.image);
      }
    } catch (error) {
      console.error('Error evaluating image data:', error);
    }
  }, [item.image_data, pics]);

  return (
    <>
      <div className="col-12 col-md-6 col-lg-4 home-prop-col">
        <button className="w-full" onClick={handleNavigate}>
          <div className="item-box border p-2 position-relative">
            {headData == true ? (
              <div className="head-functions">
                <span className="status">{i18next.t('Property Project')}</span>
                <div className="d-flex icons">
                  {editIcon == true ? (
                    <span>
                      <button onClick={handleEdit}>
                        <i className="fa-solid fa-pen" />
                      </button>
                    </span>
                  ) : null}
                  {deleteIcon == true ? (
                    <span>
                      <button onClick={onOpenModals}>
                        <i className="fa-solid fa-trash" />
                      </button>
                    </span>
                  ) : null}
                  {heartIcon == true ? (
                    <div className=" fav-lists">
                      {favIcon ? (
                        <button onClick={handleClick}>
                          <i className="fa-solid fa-heart"></i>
                        </button>
                      ) : (
                        <button onClick={handleClick2}>
                          <i className="fa-regular fa-heart"></i>
                        </button>
                      )}
                    </div>
                  ) : null}
                  {heartFavIcon == true ? (
                    <div className=" fav-lists">
                      <button onClick={handleUnfavourite}>
                        <i className="fa-solid fa-heart"></i>
                      </button>
                    </div>
                  ) : null}
                </div>
              </div>
            ) : (
              <div className="head-functions2 ">
                {item?.is_favourite == true ? (
                  <button onClick={handleClick}>
                    <i className="fa-solid fa-heart"></i>
                  </button>
                ) : (
                  <button onClick={handleClick2}>
                    <i className="fa-regular fa-heart"></i>
                  </button>
                )}
              </div>
            )}
            {item?.image_data ? (
              <>
                {item?.image_data.length == 0 ? (
                  <FileViewer file={plus ?? ''}></FileViewer>
                ) : (
                  <Image
                    // imagefallback={eval(item?.image_data)[0]?.image}
                    className="itemImage"
                    alt="banner"
                    src={photo ?? ''}
                  />
                )}
              </>
            ) : null}
            <h6 className="mt-3 text-dark">{item.property_name}</h6>

            <p className="text-sm makeLeft">
              <i className="fa-solid fa-map-location-dot"></i>
              {trimThirty(item.town)}
            </p>
            <div className="tab">
              <p>{i18next.t('Purchase price')}</p>

              <p>
                {localSymbol} {formatPrice(item.purchase_price * localAmount)}
              </p>
            </div>
            <div className="tab">
              <p>{i18next.t('Rent')}</p>
              <p>
                {localSymbol} {formatPrice(item.propert_rent * localAmount)}
              </p>
            </div>
            <div className="tab">
              <p>{i18next.t('Cashflow PCM')}</p>
              <p>
                {localSymbol} {formatPrice(item.cashflow_pcm * localAmount)}
              </p>
            </div>
            <div className="tab">
              <p>{i18next.t('Return On Investment')}</p>
              <p>
                {localSymbol} {formatPrice(item.return_on_investment * localAmount)}
              </p>
            </div>
          </div>
        </button>
        <Modal open={open} onClose={onCloseModal} center>
          <section className="model-datas">
            <h3>{i18next.t('Are you sure you want to delete this item ?')}</h3>
          </section>
          <p className="btn-lines delete-bots">
            <Button isLoading={buttonLoading} onClick={deleleItemsSelect}>
              {i18next.t('Yes')}
            </Button>
            <Button onClick={onCloseModal}>{i18next.t('No')}</Button>
          </p>
        </Modal>
      </div>
    </>
  );
};

export default PropertyProjects;
