import React from 'react';
import { Skeleton } from '@mui/material';
import { useAuth } from '@/lib/auth';
import '../user.css';
import i18next from 'i18next';

const UserHeadBar = ({ content }: { content?: string }) => {
  const { user, isLoggingIn } = useAuth();

  return (
    <div className="container-fluid profileContainer">
      <div className="d-flex flex-column ms-4 mt-2 profl-lft">
        {isLoggingIn ? (
          <div>
            <Skeleton variant="rectangular" width={180} height={30}></Skeleton>
          </div>
        ) : (
          <h4 className="mb-1">
            {i18next.t('Hello')} {`${user?.first_name ?? ''} ${user?.last_name ?? ''}`}
          </h4>
        )}
        <p className="mb-1 text-muted">
          {content ? (
            content
          ) : (
            <>
              Your profile on REEIPO . The more information you add here, the more we can customize
              REEIPO for you.
            </>
          )}
        </p>
      </div>
    </div>
  );
};

export default UserHeadBar;
