import React, { useEffect, useState } from 'react';
import { ContentLayout } from '@/components/Layout';
import { Card } from '@/components/Elements/Card';
import house from '@/assets/house.svg';
import building from '@/assets/building.svg';
import deal from '@/assets/deal.svg';
import investor from '@/assets/investor.svg';
import saving from '@/assets/saving.svg';
import h1 from '@/assets/h1.png';
import * as z from 'zod';

import { useNavigate } from 'react-router-dom';
import './UserCss.css';
import { Button } from '@/components/Elements/Button';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import { Form, InputField, SelectField } from '@/components/Form';
import { axios } from '@/lib/axios';
import { useNotificationStore } from '@/stores/notifications';
import { useAuth } from '@/lib/auth';
import PhoneVerify from '../components/PhoneVerify';
import OTPVerify from '../components/OTPVerify';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import { InputPhone } from '@/components/Form/InputPhone';
import i18next from 'i18next';
const schema = z.object({
  name: z.string().min(1, 'Please enter first name'),
  mobile_number: z.custom(isValidMobile, isValidMobileMsg),
  email: z.string().email('Please enter a valid email address'),
  property_type: z.string().min(1, 'Select property Type').optional(),
});

type HouseRentFormValues = {
  name: string;
  mobile_number: string;
  email: string;
  property_type: string;
};

export const AddList = () => {
  const navigate = useNavigate();

  const [isAgent, setIsAgent] = useState(false);
  const loginHeader = localStorage.getItem('loginType');

  useEffect(() => {
    if (loginHeader === 'admin') {
      setIsAgent(true);
    }
  }, [loginHeader]);

  const auth = useAuth();
  const user = useAuth();
  // const { user } = useAuth();
  const phoneVerification = auth?.user?.phoneVerified;
  const [loading, setLoading] = useState(false);
  const [linkopen, setLinkOpen] = useState('');
  const [isAgency, setIsAgency] = useState(false);
  const [propertyType, setPropertyType] = useState(0);
  const [propertyValue, setPropertyValue] = useState('');
  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const cardClicked = (link: string, types: number) => () => {
    setPropertyType(types);
    setLinkOpen(link);
    onOpenModal();
  };
  const userEmail = auth?.user?.email;
  const userName = auth?.user?.first_name;
  // ------------- Reipo form -----------------------------

  const [open2, setOpen2] = useState(false);
  const onOpenModal2 = () => setOpen2(true);
  const onCloseModal2 = () => setOpen2(false);

  const handleFormModal = () => () => {
    onCloseModal();
    onOpenModal2();
  };

  const handleFormModal2 = () => () => {
    onCloseModal();
    setIsAgency(true);
    onOpenModal2();
  };
  useEffect(() => {
    if (phoneVerification === true) {
      setOpen3(false);
    } else {
      setOpen3(true);
    }
  }, [auth?.user]);
  const handleSubmit = async (values: HouseRentFormValues) => {
    try {
      setLoading(true);
      if (propertyType === 1) {
        values.property_type = 'PropertyProject';
      } else if (propertyType === 2) {
        values.property_type = 'BusinessSale';
      }

      if (isAgency == true) {
        axios.post('/customer-api/send-agency-property-request', values);
      } else {
        axios.post('/customer-api/send-property-requests', values);
      }

      setLoading(false);
      onCloseModal2();
    } finally {
      setLoading(false);
      onCloseModal2();
      useNotificationStore.getState().addNotification({
        type: 'success',
        title: 'Success',
        message: 'Request sent successfully..',
      });
    }
  };
  const [open3, setOpen3] = useState(false);
  const onOpenModal3 = () => setOpen3(true);
  const onCloseModal3 = () => setOpen3(false);

  const [open4, setOpen4] = useState(false);
  const onOpenModal4 = () => setOpen4(true);
  const onCloseModal4 = () => setOpen4(false);
  const handleVerify = () => {
    onCloseModal3();
    onOpenModal4();
  };

  return (
    <ContentLayout title={i18next.t('Add List')}>
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <div className="my-5 d-flex flex-column align-items-center listing-today">
        <h4>Hello, What Would You Like to List?</h4>
        <h6>Choose the category that best fits your project.</h6>
        <div className="w-35 mt-3 row">
          <div className="col-12 col-md-6 boxes">
            {!isAgent && loginHeader === null && (
              <Card shadow>
                <div
                  role="button"
                  tabIndex={-1}
                  onKeyDown={cardClicked('/user/create-property-project', 1)}
                  onClick={cardClicked('/user/create-property-project', 1)}
                  // onKeyDown={onOpenModal}
                  // onClick={onOpenModal}
                  className="d-flex flex-column align-items-center "
                >
                  <img alt="banner" src={house} />
                  <p className="mt-3 w-50 text-center">Property Project</p>
                </div>
              </Card>
            )}
            {isAgent ||
              (loginHeader === 'agency' && (
                <Card shadow>
                  <div
                    role="button"
                    tabIndex={-1}
                    onKeyDown={() => navigate('/user/create-property-project')}
                    onClick={() => navigate('/user/create-property-project')}
                    className="d-flex flex-column align-items-center "
                  >
                    <img alt="banner" src={house} />
                    <p className="mt-3 w-50 text-center">Property Project</p>
                  </div>
                </Card>
              ))}
            {isAgent ||
              (loginHeader === 'agency' && (
                <Card shadow>
                  <div
                    role="button"
                    tabIndex={-1}
                    onKeyDown={() => navigate('/user/find-investor')}
                    onClick={() => navigate('/user/find-investor')}
                    className="d-flex flex-column align-items-center "
                  >
                    <img alt="banner" src={investor} />
                    <p className="mt-3 w-50 text-center">Find Investor</p>
                  </div>
                </Card>
              ))}
            {!isAgent && loginHeader === null && (
              <Card shadow>
                <div
                  role="button"
                  tabIndex={-1}
                  // onKeyDown={cardClicked('/user/add-rent-sale')}
                  onKeyDown={() => navigate('/user/select-property')}
                  onClick={() => navigate('/user/select-property')}
                  className="d-flex flex-column align-items-center "
                >
                  <img alt="banner" src={deal} />
                  <p className="mt-3 w-75 text-center">Property for sale/rent</p>
                </div>
              </Card>
            )}

            {!isAgent && loginHeader === null && (
              <Card shadow>
                <div
                  role="button"
                  tabIndex={-1}
                  onClick={() => navigate('/user/create-house-rent')}
                  onKeyDown={() => navigate('/user/create-house-rent')}
                  className="d-flex flex-column align-items-center "
                >
                  <img alt="banner" src={saving} />
                  <p className="mt-3 w-75 text-center">Housing wanted for Rent</p>
                </div>
              </Card>
            )}
          </div>
          <div className="col-12 col-md-6 boxes">
            {!isAgent && loginHeader === null && (
              <Card shadow>
                <div
                  role="button"
                  tabIndex={-1}
                  onClick={cardClicked('/user/create-business', 2)}
                  onKeyDown={cardClicked('/user/create-business', 2)}
                  className="d-flex flex-column align-items-center "
                >
                  <img alt="banner" src={building} />
                  <p className="mt-3 w-50 text-center">Business for sale</p>
                </div>
              </Card>
            )}
            {isAgent ||
              (loginHeader === 'agency' && (
                <Card shadow>
                  <div
                    role="button"
                    tabIndex={-1}
                    onClick={() => navigate('/user/create-business')}
                    onKeyDown={() => navigate('/user/create-business')}
                    className="d-flex flex-column align-items-center "
                  >
                    <img alt="banner" src={building} />
                    <p className="mt-3 w-50 text-center">Business for sale</p>
                  </div>
                </Card>
              ))}
            {!isAgent && loginHeader === null && (
              <Card shadow>
                <div
                  role="button"
                  tabIndex={-1}
                  onKeyDown={cardClicked('/user/find-investor', 3)}
                  onClick={cardClicked('/user/find-investor', 3)}
                  className="d-flex flex-column align-items-center "
                >
                  <img alt="banner" src={investor} />
                  <p className="mt-3 w-50 text-center">Find Investor</p>
                </div>
              </Card>
            )}
            {!isAgent && loginHeader === null && (
              <Card shadow>
                <div
                  role="button"
                  tabIndex={-1}
                  onKeyDown={() => navigate('/user/add-reeipo-services')}
                  onClick={() => navigate('/user/add-reeipo-services')}
                  className="d-flex flex-column align-items-center "
                >
                  <img alt="banner" src={h1} />
                  <p className="mt-3 w-50 text-center"> {i18next.t('Reeipo Services')}</p>
                </div>
              </Card>
            )}
          </div>
        </div>
      </div>
      <PhoneVerify isOpen={open3} close={onCloseModal3} onSuccess={() => handleVerify()} />

      <OTPVerify isOpen={open4} close={onCloseModal4} />
      <Modal open={open} onClose={onCloseModal} center>
        <section className="add-modelss">
          <div className="row">
            <h3 className="sselect">PLease select how you want to add the form.</h3>
            <div className="col-12 col-md-4 col-sm-4 rightAlignButton helloCentr">
              <Button onClick={() => navigate(linkopen)}>Do it by yourself</Button>
            </div>
            <div className="col-12 col-md-4 col-sm-4 leftAlignButton helloCentr">
              <Button onClick={handleFormModal()}> Do it by Reeipo Team</Button>
              {/* <Button> Do it by Reeipo Team</Button> */}
            </div>
            <div className="col-12 col-md-4 col-sm-4 leftAlignButton helloCentr">
              <Button onClick={handleFormModal2()}> Do it by Agency</Button>
              {/* <Button> Do it by Reeipo Team</Button> */}
            </div>
          </div>
        </section>
      </Modal>
      {/* --------------- Do it by Reeipo Team Modal Form -------------------------------- */}

      <Modal open={open2} onClose={onCloseModal2} center>
        <section className="add-models-form">
          <div className="row">
            {isAgency ? (
              <h3 className="sselect">Details for Agency</h3>
            ) : (
              <h3 className="sselect">Details for Reeipo Team</h3>
            )}

            <Form<HouseRentFormValues, typeof schema>
              onSubmit={handleSubmit}
              schema={schema}
              options={{
                defaultValues: {
                  email: userEmail,
                  name: userName,
                },
              }}
            >
              {({ register, formState }) => (
                <div className=" mb-5">
                  <div className="row mt-4">
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="text"
                        label="Full Name"
                        error={formState.errors['name']}
                        registration={register('name')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="text"
                        label={i18next.t('Email')}
                        error={formState.errors['email']}
                        registration={register('email')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputPhone
                        floating
                        error={formState.errors['mobile_number']}
                        registration={register('mobile_number')}
                      />
                    </div>
                    {propertyType === 1 && (
                      <div className="col-12 col-md-6 mt-4">
                        <InputField
                          type="number"
                          disabled
                          label="Property Project"
                          error={formState.errors['property_type']}
                          registration={register('property_type')}
                        />
                      </div>
                    )}
                    {propertyType === 2 && (
                      <div className="col-12 col-md-6 mt-4">
                        <InputField
                          type="number"
                          disabled
                          label={i18next.t('Business For Sale')}
                          error={formState.errors['property_type']}
                          registration={register('property_type')}
                        />
                      </div>
                    )}
                    {propertyType === 3 && (
                      <div className="col-12 col-md-6 mt-4">
                        <SelectField
                          label="Select Property Type"
                          error={formState.errors['property_type']}
                          registration={register('property_type')}
                          placeholder="Select Property Type"
                          options={[
                            { label: 'Investment for Project', value: 'InvestmentProject' },
                            { label: 'Investment for Company', value: 'InvestmentCompany' },
                          ]}
                        />
                      </div>
                    )}

                    <div className="row mt-5">
                      <div className="col-12 col-md-6 col-sm-6 rightAlignButton">
                        <Button onClick={onCloseModal2}> {i18next.t(`Cancel`)}</Button>
                      </div>
                      <div className="col-12 col-md-6 col-sm-6 leftAlignButton">
                        <Button type="submit"> Send</Button>
                      </div>
                    </div>
                  </div>
                </div>
              )}
            </Form>
          </div>
        </section>
      </Modal>
      {/* --------------- Do it by Reeipo Team MOdal Form -------------------------------- */}
    </ContentLayout>
  );
};
