import Footer from '@/components/Layout/Footer/Footer';
// import './landing.css';
import React, { useEffect, useState } from 'react';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import { timeFromNow } from '@/utils/format';
import './AgencyMeeting.css';
import 'react-responsive-modal/styles.css';
import { FormControl, InputLabel, MenuItem, Select } from '@mui/material';
import { Button } from '@/components/Elements';
import { useNotificationStore } from '@/stores/notifications';
import { confirmDeal } from '@/api/businessInquiry/confirmDeal';
import { useCustomerAgencyListing } from '@/api/AgencyApi/customerAgencyListing';
import { ConfirmDialogWithButton } from '@/components/Elements/ConfirmationDialog/ConfirmDialogWithButton';
import { confirmRequestFromAgency } from '@/api/AgencyApi/confirmRequestFromAgency';
import i18next from 'i18next';

export const AgencyMeeting = () => {
  const navigate = useNavigate();
  const [selectedType, setSelectedType] = useState('recieved');
  const [loading, setLoading] = useState(false);
  const { data, isLoading, isFetching, refetch } = useCustomerAgencyListing({
    type: selectedType,
  });
  const handleChange = (event: any) => {
    setSelectedType(event.target.value);
  };
  useEffect(() => {
    refetch();
  }, [selectedType]);
  const list = data?.data;

  const confirmAction = async (request_id: string, agency_id: string) => {
    try {
      setLoading(true);
      await confirmRequestFromAgency({ request_id, agency_id });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have confirm the deal !',
      });
      navigate(`/user/rating/${agency_id}`);
    } finally {
      setLoading(false);
      close();
    }
  };

  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar content="View all of your agency requests on this page." />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container">
        <div className="row meeting-sent">
          {isLoading || isFetching ? (
            <MyListingLoader />
          ) : (
            <>
              <div className="row">
                <div className="col-12 col-md-10">
                  {selectedType === 'sent' ? (
                    <h3>Agency Requests Sent</h3>
                  ) : (
                    <h3>Agency Requests Received</h3>
                  )}
                </div>
                <div className="col-12 col-md-2 meeting-booking">
                  <div className="row">
                    <FormControl>
                      <InputLabel>Select reuqest type</InputLabel>
                      <Select value={selectedType} onChange={handleChange} label="Select an option">
                        <MenuItem value="recieved">Recieved</MenuItem>
                        <MenuItem value="sent">Sent</MenuItem>
                      </Select>
                    </FormControl>
                  </div>
                </div>
              </div>
              {list?.length > 0 ? (
                list?.map((item: any, index: any) => (
                  <>
                    {selectedType == 'sent' ? (
                      <>
                        <div className="col-md-6 col-sm-6 out-pay mt-2" key={index}>
                          <div className="pay-box agency">
                            <div className="">
                              <div className="item-boxs">
                                <span className="crated-span">
                                  {timeFromNow(item?.created_date)} ago
                                </span>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Sender Name</p>
                                  <p className="rightSd col-6 col-md-6">{item?.name}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">{i18next.t('Phone')}</p>
                                  <p className="rightSd col-6 col-md-6">{item?.mobile_number}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">
                                    Property Requested
                                  </p>
                                  <p className="rightSd col-6 col-md-6">{item?.property}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Sender Email</p>
                                  <p className="rightSd col-6 col-md-6">{item?.email}</p>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </>
                    ) : (
                      <>
                        <div className="col-md-6 col-sm-6 out-pay mt-2" key={index}>
                          <div className="pay-box agency">
                            <div className="">
                              <div className="item-boxs">
                                <span className="crated-span">
                                  {timeFromNow(item?.created_date)} ago
                                </span>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Agency Name</p>
                                  <p className="rightSd col-6 col-md-6">{item?.agency_name}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Agency Email</p>
                                  <p className="rightSd col-6 col-md-6">{item?.agency_email}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">{i18next.t('Phone')}</p>
                                  <p className="rightSd col-6 col-md-6">
                                    {item?.agency_phone_number}
                                  </p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">
                                    Property Requested
                                  </p>
                                  <p className="rightSd col-6 col-md-6">{item?.property}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Status</p>
                                  <p className="rightSd col-6 col-md-6">{item?.status}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Ratings</p>
                                  <p className="rightSd col-6 col-md-6">
                                    {[...new Array(item?.average_rating)]?.map((item, index) => {
                                      return <i key={index} className="fa-solid fa-star"></i>;
                                    })}
                                    {[...new Array(5 - item?.average_rating)]?.map(
                                      (item, index) => {
                                        return <i key={index} className="fa-regular fa-star"></i>;
                                      }
                                    )}
                                  </p>
                                </div>
                              </div>

                              {item?.status == 'Accepted' ? (
                                <div className="w-full AcceptedDiv">
                                  <Button>Approved</Button>
                                </div>
                              ) : (
                                <div className="divCentr mt-3">
                                  <ConfirmDialogWithButton
                                    triggerButton={<Button variant="outlineDark">Approve</Button>}
                                    confirmButton={
                                      <Button
                                        isLoading={loading}
                                        onClick={() => confirmAction(item?.id, item?.agency_id)}
                                        variant="primary"
                                      >
                                        Approve
                                      </Button>
                                    }
                                    title="Confirm"
                                    icon="info"
                                    body="Are you sure you want to approve this request?"
                                  />
                                </div>
                              )}
                            </div>
                          </div>
                        </div>
                      </>
                    )}
                  </>
                ))
              ) : (
                <h5 className="makeCenter">Nothing to Show Yet!</h5>
              )}
            </>
          )}
        </div>
      </div>

      <br />
      <Footer />
    </>
  );
};
