import React, { useEffect, useState } from 'react';
import * as z from 'zod';
import plus from '@/assets/plus.png';
import axiosmod from 'axios';
import { ContentLayout } from '@/components/Layout';
import { useSelectFile } from '@/hooks/useSelectFile';
import { Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import companyCategory from '@/constants/companyCategory';
import openingHours from '@/constants/openingHours';
import { Button, Spinner } from '@/components/Elements';
import { uploadImage } from '@/api/uploadImage';
import { useNotificationStore } from '@/stores/notifications';
import { useNavigate, useParams } from 'react-router-dom';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { useAuth } from '@/lib/auth';
import storage from '@/utils/storage';
import { axios } from '@/lib/axios';
import { useSelectMultipleFile } from '@/hooks/useSelectMultipleFile';

import { getCommonDetail } from '@/api/commonDetail/getCommonDetail';

import { Business } from '@/types';
import EditSalePageLoader from '@/components/Elements/Loader/EditSalePageLoader';
import FileViewer from '@/components/Viewer/FileViewer';
import GooglePlacesAutocomplete from 'react-google-places-autocomplete';
import { GoogleMap, Marker } from '@react-google-maps/api';
import EditDraftInput from '@/components/Elements/DraftInput/EditDraftInput';
import DraftInput from '@/components/Elements/DraftInput/DraftInput';
import { EditorState } from 'draft-js';
import { InputPhone } from '@/components/Form/InputPhone';
import { isValidMobile, isValidMobileMsg } from '@/utils/validation';
import i18next from 'i18next';

const googleMapAPIkey = process.env.REACT_APP_GOOGLE_MAPS_API_KEY as string;

// -------------- google maps --------------------

function Map({
  location,
  // addressDetails,
  setAddressDetails,
}: {
  location: any;
  addressDetails: any;
  setAddressDetails: any;
}) {
  const [userLat, setUserLat] = useState(37.0902);
  const [userLong, setUserLong] = useState(95.7129);
  const center = { lat: userLat, lng: userLong };

  const geocoder = new google.maps.Geocoder();

  useEffect(() => {
    getLocationDetails();
  }, [center]);

  const getLocationDetails = () => {
    geocoder.geocode({ location: center }).then((response) => {
      if (response.results[0]) {
        setAddressDetails({
          latitude: userLat,
          longitude: userLong,
          address_line: response.results[0].formatted_address,
        });
      } else {
        console.log('No results found');
      }
    });
  };

  useEffect(() => {
    if (location?.lat) {
      setUserLat(parseFloat(location?.lat));
      setUserLong(parseFloat(location?.lng));
      getLocationDetails();
    }
  }, [location]);

  return (
    <GoogleMap
      zoom={10}
      center={center}
      mapContainerClassName="map-container"
      onClick={(e) => {
        setUserLat(e.latLng?.lat() || 0);
        setUserLong(e.latLng?.lng() || 0);
      }}
    >
      <Marker position={center} />
    </GoogleMap>
  );
}

type LocationCoordinates = {
  lat?: number;
  lng?: number;
};

// ---------------google maps -------------------

const schema = z.object({
  company_name: z.string().min(1, 'Please enter Business name'),
  company_established: z.string().min(1, 'Please enter Business established'),
  number_of_employes: z.string().min(1, 'Please enter number of employees'),
  company_email: z
    .string()
    .min(1, 'Please enter Business email address')
    .email('Please enter a valid email address'),
  company_telephone: z.custom(isValidMobile, isValidMobileMsg),
  company_category: z.string().min(1, 'Please enter Business category'),
  opening_hours: z.string().min(1, 'Please enter opening hours'),
  closing_hours: z.string().min(1, 'Please enter closing hours'),
  company_facebook_link: z.string().optional(),
  company_twitter_link: z.string().optional(),
  company_youtube_link: z.string().optional(),
  company_linkedin_link: z.string().optional(),
  company_details: z.string().optional(),
  company_vision: z.string().optional(),
  note_to_purchase: z.string().optional(),
  purchase_price: z.string().min(1, 'Please enter purchase price'),
  total_turnover: z.string().min(1, 'Please enter total turnover'),
  operating_profit: z.string().min(1, 'Please enter operating profit'),
  salary_percentage: z.string().min(1, 'Please enter salary percentage'),
  description: z.string().min(1, 'Please enter Description'),
  website_link: z.string().min(1, 'Please enter website ink'),
  cost_of_goods_sold: z.string().min(1, 'Please enter cost of goods sold'),
  background_for_sale: z.string().min(1, 'Please enter background for sale'),
  // concept: z.string().min(1, 'Please enter concept'),
  // operation_and_history: z.string().min(1, 'Please enter operation and history'),
  // market_situtation: z.string().min(1, 'Please enter market solution'),
  // premisis_and_location: z.string().min(1, 'Please enter premisses and location'),
  // advantage_and_opportuntity: z.string().min(1, 'Please enter advantages and opportunity'),
  // price_and_valuation: z.string().min(1, 'Please enter price and valuation'),
  // financial_information: z.string().min(1, 'Please enter inancial information'),
  // various_information: z.string().min(1, 'Please enter various info'),
});

type CreateBusinessValues = {
  company_name: string;
  company_established: string;
  number_of_employes: string;
  company_email: string;
  company_telephone: string;
  company_category: string;
  opening_hours: string;
  company_twitter_link: string;
  company_facebook_link: string;
  company_youtube_link: string;
  company_linkedin_link: string;
  company_details: string;
  company_vision: string;
  note_to_purchase: string;
  purchase_price: any;
  total_turnover: any;
  operating_profit: any;
  salary_percentage: string;
  is_draft: any;
  property_id: any;
  image_data: any;
  videos: any;
  // ---------------
  description: string;
  documents: string;
  background_for_sale: any;
  closing_hours: string;
  website_link: string;
  cost_of_goods_sold: any;
  location: string;
  latitude: string;
  longitude: string;

  // ----------------
  concept: string;
  operation_and_history: string;
  market_situtation: string;
  premisis_and_location: string;
  advantage_and_opportuntity: string;
  price_and_valuation: string;
  financial_information: string;
  various_information: string;
};

export const CreateBusiness = () => {
  const navigate = useNavigate();
  const localCurrency = storage.getAmount();
  const localSymbol = storage.getSymbol();
  const {
    file: videoFile,
    preview: videoPreview,
    handleChange: handleVideoChange,
    cover,
  } = useSelectFile();

  const {
    file: pdfFile,
    preview: pdfPreview,
    handleChange: pdfhandleChange,
    pdfName,
  } = useSelectFile();

  const [loading, setLoading] = useState(false);

  const auth = useAuth();
  const { id } = useParams();

  // ye h edit k lies
  const [iseditForm, setIseditForm] = useState<boolean>(false);

  const [user, setUser] = useState<Business>();
  const [isLoader, setisLoader] = useState<boolean>(false);

  const getDataOfApi = async () => {
    if (id != null) {
      setisLoader(true);
      const data = await getCommonDetail(id);
      const userIn = data?.data ?? ({} as Business);
      setUser(userIn);
      setisLoader(false);
    }
  };
  useEffect(() => {
    auth.refetchUser();
    getDataOfApi();
    setIseditForm(true);
  }, [id]);

  // ye h edit k lie
  const [conceptData, setConceptData] = useState<any>(null);
  const conceptOldData = user?.concept;
  const [conceptState, setConceptState] = useState(() => EditorState.createEmpty());

  const [operation_and_historyData, setoperation_and_historyData] = useState<any>(null);
  const operation_and_historyOldData = user?.operation_and_history;
  const [operation_and_historyState, setoperation_and_historyState] = useState(() =>
    EditorState.createEmpty()
  );

  const [market_situtationData, setmarket_situtationData] = useState<any>(null);
  const market_situtationOldData = user?.market_situtation;
  const [market_situtationState, setmarket_situtationState] = useState(() =>
    EditorState.createEmpty()
  );

  const [premisis_and_locationData, setpremisis_and_locationData] = useState<any>(null);
  const premisis_and_locationOldData = user?.premisis_and_location;
  const [premisis_and_locationState, setpremisis_and_locationState] = useState(() =>
    EditorState.createEmpty()
  );

  const [advantage_and_opportuntityData, setadvantage_and_opportuntityData] = useState<any>(null);
  const advantage_and_opportuntityOldData = user?.advantage_and_opportuntity;
  const [advantage_and_opportuntityState, setadvantage_and_opportuntityState] = useState(() =>
    EditorState.createEmpty()
  );

  const [price_and_valuationData, setprice_and_valuationData] = useState<any>(null);
  const price_and_valuationOldData = user?.price_and_valuation;
  const [price_and_valuationState, setprice_and_valuationState] = useState(() =>
    EditorState.createEmpty()
  );

  const [financial_informationData, setfinancial_informationData] = useState<any>(null);
  const financial_informationOldData = user?.financial_information;
  const [financial_informationState, setfinancial_informationState] = useState(() =>
    EditorState.createEmpty()
  );

  const [various_informationData, setvarious_informationData] = useState<any>(null);
  const various_informationOldData = user?.various_information;
  const [various_informationState, setvarious_informationState] = useState(() =>
    EditorState.createEmpty()
  );

  const [idd, setIdd] = useState('');
  const [is_draft, setis_draft] = useState<string>('False');
  const [userSubscribed, setuserSubscribed] = useState();
  const [value, setValue] = useState(null);
  const [latitude, setlatitude] = useState(0);
  const [longitude, setlongitude] = useState(0);
  const [addressValue, setAddressValue] = useState<string>('');
  const [address, setAddress] = useState<string>('');
  const [location, setLocation] = useState<LocationCoordinates>({} as LocationCoordinates);
  const [addressDetails, setAddressDetails] = useState({
    address_line: '',
    latitude: '',
    longitude: '',
  });

  useEffect(() => {
    setlatitude(addressDetails?.latitude);
    setlongitude(addressDetails?.longitude);
    setAddressValue(addressDetails?.address_line);
  }, [addressDetails]);

  useEffect(() => {
    setlatitude(user?.latitude);
    setlongitude(user?.longitude);
  }, [user]);

  useEffect(() => {
    auth.refetchUser();
    setuserSubscribed(auth?.user?.has_subscription);
  }, [auth?.user?.has_subscription]);

  useEffect(() => {
    if (auth.user?.has_subscription == true) {
      setis_draft('False');
    } else {
      setis_draft('True');
    }
  }, [auth?.user?.has_subscription]);

  const addData = {
    editId: `${idd}`,
    pageUrl: `/user/create-business/${idd}?type=BusinessSale`,
  };

  storage.setSubmitFormData(addData);

  const showSuccess = () => {
    useNotificationStore.getState().addNotification({
      title: 'Success',
      type: 'success',
      message: 'Bussiness Submitted Successfully!',
    });
  };

  const { images, handleChange, uploaded, deleteImage, text, setText, load } =
    useSelectMultipleFile();

  const deleteImages = (val: any) => {
    const filteredItems = imageArray
      .slice(0, val)
      .concat(imageArray.slice(val + 1, imageArray.length));
    setImageArray(filteredItems);
  };

  const [imageArray, setImageArray] = useState<any>([]);
  useEffect(() => {
    if (user) {
      const previousImage = eval(user?.image_data);
      setImageArray(previousImage);
    }
  }, [user]);

  const handleText = (index: number, val: string) => {
    const textItems = [...text];
    textItems[index] = val;
    setText(textItems);
  };

  const handleChangeLocation = async (value: any) => {
    const placeId = value.value.place_id;
    const { data } = await axiosmod.get(
      `https://maps.googleapis.com/maps/api/geocode/json?place_id=${placeId}&key=${googleMapAPIkey}`
    );
    const location = data?.results[0]?.geometry?.location;
    if (location) {
      setLocation(location);
      setAddress(value.label);
      setValue(value);
    }
  };

  const agency_id = localStorage.getItem('agency_id');

  const convertValuesToLocalCurrency = async (values: any) => {
    const fieldsToConvert = [
      'purchase_price',
      'background_for_sale',
      'total_turnover',
      'operating_profit',
      'cost_of_goods_sold',
    ];

    fieldsToConvert.forEach((field) => {
      values[field] /= localCurrency;
    });
  };

  const handleSubmit = async (values: CreateBusinessValues) => {
    try {
      setLoading(true);
      let pdfUrl = '';
      if (pdfFile) {
        const response = await uploadImage({ file: pdfFile });
        pdfUrl = response.url;
      } else {
        pdfUrl = user?.documents ?? '';
      }

      let videoUrl = '';

      const newArray = uploaded.map(function (value, index) {
        return { image: value, name: text[index] };
      });

      const image_data = imageArray.concat(newArray);

      if (videoFile) {
        const response = await uploadImage({ file: videoFile });
        videoUrl = response.url;
      } else {
        videoUrl = user?.videos ?? '';
      }

      values.property_id = id;
      values.is_draft = is_draft;
      values.image_data = JSON.stringify(image_data);
      values.videos = videoUrl;
      values.documents = pdfUrl;
      values.latitude = latitude;
      values.longitude = longitude;
      values.location = addressValue;
      values.concept = conceptData;
      values.operation_and_history = operation_and_historyData;
      values.market_situtation = market_situtationData;
      values.premisis_and_location = premisis_and_locationData;
      values.advantage_and_opportuntity = advantage_and_opportuntityData;
      values.price_and_valuation = price_and_valuationData;
      values.financial_information = financial_informationData;
      values.various_information = various_informationData;
      await convertValuesToLocalCurrency(values);
      id != null
        ? axios
            .post('/customer-api/edit-bussiness-sale', values)
            .then(() => {
              setLoading(false);
              showSuccess();
              navigate('/user/my-listing');
            })
            .catch(() => {
              setLoading(false);
            })
        : axios
            .post('/customer-api/bussiness-for-sale', { ...values, agency_id: agency_id })
            .then((response) => {
              setLoading(false);
              showSuccess();
              if (auth.user?.has_subscription == true) {
                setLoading(false);
                navigate('/business-for-sale');
              } else {
                setIdd(response?.data?.id);
                navigate('/user/subscription');
                setLoading(false);
              }
            })
            .catch(() => {
              setLoading(false);
            });
    } finally {
      setLoading(false);
    }
  };

  const [canAddMore, setcanAddMore] = useState(false);
  useEffect(() => {
    if (auth.user?.total_property_upload >= auth.user?.property_count) {
      setcanAddMore(true);
    }
  }, [auth?.user?.has_subscription]);

  return (
    <ContentLayout title="Create Business">
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <BackdropLoader open={loading} />
      <div className="container mt-4">
        <h3>Add New Advertisement/Listing of Business</h3>
        <h5 className="ms-2 my-4">Business Information</h5>
        {isLoader ? (
          <EditSalePageLoader />
        ) : (
          <>
            <Form<CreateBusinessValues, typeof schema>
              onSubmit={handleSubmit}
              schema={schema}
              options={{
                defaultValues: {
                  ...user,
                  number_of_employes: user?.number_of_employes?.toString(),
                  purchase_price: (user?.purchase_price * localCurrency)?.toString(),
                  background_for_sale: (user?.background_for_sale * localCurrency)?.toString(),
                  total_turnover: (user?.total_turnover * localCurrency)?.toString(),
                  operating_profit: (user?.operating_profit * localCurrency)?.toString(),
                  salary_percentage: user?.salary_percentage?.toString(),
                  cost_of_goods_sold: (user?.cost_of_goods_sold * localCurrency)?.toString(),
                  latitude: user?.latitude?.toString(),
                  longitude: user?.longitude?.toString(),
                  location: user?.location?.toString(),
                },
              }}
            >
              {({ register, formState }) => (
                <div className="profile-box crete-business mb-5">
                  <div className="d-flex videos-upload-box">
                    <div className="video-left-up">
                      <h5>Video</h5>
                      <label htmlFor="videoInput">
                        <div className="image-box">
                          {videoPreview ? (
                            <img src={cover?.toString() ?? ''} alt="" className="profileImage" />
                          ) : user?.videos ? (
                            <p className="smallFile">
                              <FileViewer file={user?.videos} />
                            </p>
                          ) : (
                            <img src={plus} alt="" width="60" />
                          )}
                        </div>
                      </label>
                      <input
                        accept="video/mp4,video/x-m4v,video/*"
                        onChange={handleVideoChange}
                        type="file"
                        id="videoInput"
                        className="d-none"
                      />
                    </div>
                    <div className="selectedImagesDiv">
                      <h5>Images</h5>

                      <div className="row crosses-select">
                        {imageArray.map((item: any, index: number) => (
                          <div key={index} className="col-12 col-md-6 cross-pic">
                            <div className="image-box">
                              <button type="button" onClick={() => deleteImages(index)}>
                                <i className="fa-solid fa-square-xmark pics"></i>
                              </button>
                              <img src={item.image} alt="..." />
                            </div>
                            {item.name && <h6 className="itemName">{item.name}</h6>}
                          </div>
                        ))}

                        {images.map((item: any, index: number) => (
                          <div key={index} className="cross-pic">
                            <div className="image-box">
                              <button type="button" onClick={() => deleteImage(index)}>
                                <i className="fa-solid fa-square-xmark pics"></i>
                              </button>
                              <img src={item} alt="..." />
                            </div>
                            <input
                              type="text"
                              id="imageName"
                              name="imageName"
                              placeholder="Image name"
                              onChange={(e) => handleText(index, e.target.value)}
                              value={text[index]}
                            />
                          </div>
                        ))}

                        <div className="col-md-2 col-12">
                          <div className="padding-r">
                            <label htmlFor="fileInput1">
                              <div className="image-box">
                                {load ? <Spinner /> : <img src={plus} alt="" width="60" />}
                              </div>
                            </label>
                            <input
                              accept="image/*"
                              onChange={handleChange}
                              multiple
                              type="file"
                              id="fileInput1"
                              className="d-none"
                            />
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="row">
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="text"
                        label="Business name"
                        error={formState.errors['company_name']}
                        registration={register('company_name')}
                        placeholder="Business name"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="number"
                        label="Business established (In Years)"
                        error={formState.errors['company_established']}
                        registration={register('company_established')}
                        placeholder="Business established (In Years)"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="number"
                        min={0}
                        label="Number of employees"
                        error={formState.errors['number_of_employes']}
                        registration={register('number_of_employes')}
                        placeholder="Number of employees"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="email"
                        label="Business Email Address"
                        error={formState.errors['company_email']}
                        registration={register('company_email')}
                        placeholder="Business Email Address"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="text"
                        label="Website Link"
                        error={formState.errors['website_link']}
                        registration={register('website_link')}
                        placeholder="Website Link"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputPhone
                        floating
                        value={user?.company_telephone}
                        error={formState.errors['company_telephone']}
                        registration={register('company_telephone')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <SelectField
                        label="Business Category"
                        error={formState.errors['company_category']}
                        registration={register('company_category')}
                        placeholder="Business Category"
                        options={Object.entries(companyCategory).map(([key, value]) => ({
                          label: value,
                          value: key,
                        }))}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-4">
                      <InputField
                        type="time"
                        label="Opening Hour"
                        error={formState.errors['opening_hours']}
                        registration={register('opening_hours')}
                      />
                    </div>
                    <div className=" col-md-6 col-12 col-sm-6">
                      <p className="headingUplod mb-0">Upload Doccuments here</p>
                      <label htmlFor="fileInput">
                        <div>
                          {pdfPreview ? null : (
                            <>
                              {user?.documents ? (
                                <div className="pdfDiv">
                                  <FileViewer file={user?.documents} />
                                </div>
                              ) : null}
                            </>
                          )}

                          {pdfPreview ? (
                            <>
                              {pdfName ? (
                                <>
                                  <div className="files-box">
                                    <p>{pdfName}</p>
                                  </div>
                                </>
                              ) : (
                                <>
                                  <div className="image-box">
                                    <img src={pdfPreview} alt="" className="profileImage" />
                                  </div>
                                </>
                              )}
                            </>
                          ) : (
                            <>
                              {user?.documents ? (
                                <div className="files-box">
                                  <p>Edit Doccument here .</p>
                                </div>
                              ) : (
                                <div className="files-box">
                                  <img src={plus} alt="" width="60" />
                                </div>
                              )}
                            </>
                          )}
                        </div>
                      </label>
                      <input
                        accept="pdf/*"
                        onChange={pdfhandleChange}
                        type="file"
                        id="fileInput"
                        className="d-none"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-5">
                      <InputField
                        type="time"
                        label="Closing Hour"
                        error={formState.errors['closing_hours']}
                        registration={register('closing_hours')}
                      />
                    </div>
                    <p className="mt-4 btn-heavy">Business Social Media</p>
                    <div className="col-12 col-md-6">
                      <InputField
                        type="text"
                        label="Facebook"
                        error={formState.errors['company_facebook_link']}
                        registration={register('company_facebook_link')}
                        placeholder="Facebook"
                      />
                    </div>
                    <div className="col-12 col-md-6 ">
                      <InputField
                        type="text"
                        label="Twitter"
                        error={formState.errors['company_twitter_link']}
                        registration={register('company_twitter_link')}
                        placeholder="Twitter"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="text"
                        label={i18next.t('Youtube')}
                        error={formState.errors['company_youtube_link']}
                        registration={register('company_youtube_link')}
                        placeholder={i18next.t('Youtube')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="text"
                        label="Linkedin"
                        error={formState.errors['company_linkedin_link']}
                        registration={register('company_linkedin_link')}
                        placeholder="Linkedin"
                      />
                    </div>
                    <div className="col-12  col-md-6  mt-4">
                      <TextAreaField
                        rows={4}
                        error={formState.errors['company_details']}
                        registration={register('company_details')}
                        label={i18next.t('Business Details')}
                      />
                    </div>
                    <div className="col-12  col-md-6  mt-4">
                      <TextAreaField
                        rows={4}
                        error={formState.errors['company_vision']}
                        registration={register('company_vision')}
                        label="Business Vision"
                      />
                    </div>
                    <div className="col-12 col-md-6  mt-4">
                      <TextAreaField
                        rows={4}
                        error={formState.errors['description']}
                        registration={register('description')}
                        label={i18next.t('Description')}
                      />
                    </div>
                    <div className="col-12 col-md-6  mt-4">
                      <TextAreaField
                        rows={4}
                        error={formState.errors['note_to_purchase']}
                        registration={register('note_to_purchase')}
                        label="Important note to purchases"
                      />
                    </div>
                    <p className="mt-4 btn-heavy">Business Information</p>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`${i18next.t('Purchase price')} ${localSymbol}`}
                        error={formState.errors['purchase_price']}
                        registration={register('purchase_price')}
                        placeholder={i18next.t('Purchase price')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`${i18next.t('Cost Of Goods Sold')} ${localSymbol}`}
                        error={formState.errors['cost_of_goods_sold']}
                        registration={register('cost_of_goods_sold')}
                        placeholder={i18next.t('Cost Of Goods Sold')}
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`Background For Sale ${localSymbol}`}
                        error={formState.errors['background_for_sale']}
                        registration={register('background_for_sale')}
                        placeholder="Background For Sale"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`Total Turnover ${localSymbol}`}
                        error={formState.errors['total_turnover']}
                        registration={register('total_turnover')}
                        placeholder="Total Turnover"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="float"
                        label={`Operating Profit ${localSymbol}`}
                        error={formState.errors['operating_profit']}
                        registration={register('operating_profit')}
                        placeholder="Operating Profit"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <InputField
                        type="text"
                        label="Salary percentage"
                        error={formState.errors['salary_percentage']}
                        registration={register('salary_percentage')}
                        placeholder="Salary percentage"
                      />
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">{i18next.t('Concept')}</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={conceptOldData}
                            html={conceptData}
                            setHtml={setConceptData}
                            editorState={conceptState}
                            setEditorState={setConceptState}
                          />
                        ) : (
                          <DraftInput html={conceptData} setHtml={setConceptData} />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">Operation And History</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={operation_and_historyOldData}
                            html={operation_and_historyData}
                            setHtml={setoperation_and_historyData}
                            editorState={operation_and_historyState}
                            setEditorState={setoperation_and_historyState}
                          />
                        ) : (
                          <DraftInput
                            html={operation_and_historyData}
                            setHtml={setoperation_and_historyData}
                          />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">Market Situtation</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={market_situtationOldData}
                            html={market_situtationData}
                            setHtml={setmarket_situtationData}
                            editorState={market_situtationState}
                            setEditorState={setmarket_situtationState}
                          />
                        ) : (
                          <DraftInput
                            html={market_situtationData}
                            setHtml={setmarket_situtationData}
                          />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">Premisis And Location</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={premisis_and_locationOldData}
                            html={premisis_and_locationData}
                            setHtml={setpremisis_and_locationData}
                            editorState={premisis_and_locationState}
                            setEditorState={setpremisis_and_locationState}
                          />
                        ) : (
                          <DraftInput
                            html={premisis_and_locationData}
                            setHtml={setpremisis_and_locationData}
                          />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">Advantage And Opportuntity</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={advantage_and_opportuntityOldData}
                            html={advantage_and_opportuntityData}
                            setHtml={setadvantage_and_opportuntityData}
                            editorState={advantage_and_opportuntityState}
                            setEditorState={setadvantage_and_opportuntityState}
                          />
                        ) : (
                          <DraftInput
                            html={advantage_and_opportuntityData}
                            setHtml={setadvantage_and_opportuntityData}
                          />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">Price And Valuation</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={price_and_valuationOldData}
                            html={price_and_valuationData}
                            setHtml={setprice_and_valuationData}
                            editorState={price_and_valuationState}
                            setEditorState={setprice_and_valuationState}
                          />
                        ) : (
                          <DraftInput
                            html={price_and_valuationData}
                            setHtml={setprice_and_valuationData}
                          />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">{i18next.t('Financial Information')}</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={financial_informationOldData}
                            html={financial_informationData}
                            setHtml={setfinancial_informationData}
                            editorState={financial_informationState}
                            setEditorState={setfinancial_informationState}
                          />
                        ) : (
                          <DraftInput
                            html={financial_informationData}
                            setHtml={setfinancial_informationData}
                          />
                        )}
                      </div>
                    </div>
                    <div className="col-12 col-md-6 mt-2">
                      <div className="draftDivs">
                        <h6 className="draftHead">{i18next.t('Various Information')}</h6>

                        {iseditForm === true ? (
                          <EditDraftInput
                            stateData={various_informationOldData}
                            html={various_informationData}
                            setHtml={setvarious_informationData}
                            editorState={various_informationState}
                            setEditorState={setvarious_informationState}
                          />
                        ) : (
                          <DraftInput
                            html={various_informationData}
                            setHtml={setvarious_informationData}
                          />
                        )}
                      </div>
                    </div>
                    <div
                      className="col-12 col-md-12 mt-3"
                      style={{ width: '100%', marginBottom: '20px' }}
                    >
                      <div style={{ width: '100%', height: '80%' }}>
                        <Map
                          location={location}
                          setAddressDetails={setAddressDetails}
                          addressDetails={addressDetails}
                        />
                      </div>
                    </div>
                    <br />
                    <div className="col-12">
                      <div className="pt-2 pb-2">
                        <GooglePlacesAutocomplete
                          selectProps={{
                            defaultInputValue: user?.location ? user?.location : '',
                            value,
                            onChange: handleChangeLocation,
                          }}
                        />
                      </div>
                    </div>
                    <div className="d-flex justify-content-center mt-4">
                      {userSubscribed == true ? (
                        <>
                          {canAddMore ? (
                            <Button disabled className="disableSubmit">
                              Reached Upload limit
                            </Button>
                          ) : (
                            <Button
                              isLoading={loading}
                              type="submit"
                              variant="primary"
                              size="md"
                              className="mt-2 "
                            >
                              Submit
                            </Button>
                          )}
                        </>
                      ) : (
                        <>
                          {' '}
                          <Button
                            isLoading={loading}
                            type="submit"
                            variant="primary"
                            size="md"
                            className="mt-2 "
                          >
                            Subscribe
                          </Button>
                        </>
                      )}
                    </div>
                  </div>
                </div>
              )}
            </Form>
          </>
        )}
      </div>
    </ContentLayout>
  );
};
