import Footer from '@/components/Layout/Footer/Footer';
// import './landing.css';
import React, { useEffect, useState } from 'react';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import { useMeetingDetails } from '@/api/businessInquiry/meetingListing';
import { timeFromNow, trimSixty } from '@/utils/format';
import { Image } from '@/components/Elements/Images/Image';
import './meeting.css';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import { FormControl, InputLabel, MenuItem, Select, TextField } from '@mui/material';
import { Button } from '@/components/Elements';
import { useNotificationStore } from '@/stores/notifications';
import { acceptMeetingStatus } from '@/api/businessInquiry/acceptMeetingStatus';
import { rejectMeetingStatus } from '@/api/businessInquiry/rejectMeetingStatus';
import { confirmDeal } from '@/api/businessInquiry/confirmDeal';
import { cancelDeal } from '@/api/businessInquiry/cancelDeal';
import i18next from 'i18next';

export const BusinessMeetingSent = () => {
  const navigate = useNavigate();
  const [selectedType, setSelectedType] = useState('sent');
  const [message, setMessage] = useState('');

  const handleInputChange = (event) => {
    setMessage(event.target.value);
  };

  const [selectedId, setSelectedId] = useState<number>();
  const [confirmId, setConfirmId] = useState<number>();
  const [isDisable, setDisable] = useState(true);

  const [read, setRead] = useState(false);
  const [apiLoading, setLoading] = useState(false);
  const [loadingReject, setLoadingReject] = useState(false);
  const [loading] = useState(false);
  const { data, isLoading, isFetching, refetch } = useMeetingDetails({
    type: selectedType,
  });
  const handleChange = (event) => {
    setSelectedType(event.target.value);
  };
  useEffect(() => {
    refetch();
  }, [selectedType]);
  const list = data?.data;
  const [open, setOpen] = useState(false);
  const [open2, setOpen2] = useState(false);
  const [open3, setOpen3] = useState(false);
  const [open4, setOpen4] = useState(false);
  const [open5, setOpen5] = useState(false);

  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);

  const onOpenModal2 = () => setOpen2(true);
  const onCloseModal2 = () => setOpen2(false);

  const onOpenModal3 = () => setOpen3(true);
  const onCloseModal3 = () => setOpen3(false);

  const onOpenModal4 = () => setOpen4(true);
  const onCloseModal4 = () => setOpen4(false);

  const onOpenModal5 = () => setOpen5(true);
  const onCloseModal5 = () => setOpen5(false);

  const handleId = (id: any) => {
    setSelectedId(id);
    onOpenModal();
  };

  const handlePay = (id: any) => {
    setSelectedId(id);
    onOpenModal5();
  };
  const handleOnlineNavigate = () => {
    if (selectedId) {
      navigate(`/user/online-business-payment?id=${selectedId}`);
    }
  };

  const handleOfflineNavigate = () => {
    if (selectedId) {
      navigate(`/user/offline-business-payment?id=${selectedId}`);
    }
  };

  const confirmActionId = (id: any) => {
    setConfirmId(id);
    onOpenModal3();
  };
  const handleRejectDealModel = () => {
    onCloseModal3();
    onOpenModal4();
    setMessage('');
  };

  const handlerejectModel = () => {
    onCloseModal();
    onOpenModal2();
    setMessage('');
  };

  useEffect(() => {
    if (message === '') {
      setDisable(true);
    } else {
      setDisable(false);
    }
  }, [message]);

  const acceptAction = async (meeting_id: string) => {
    try {
      setLoading(true);
      await acceptMeetingStatus({ meeting_id, accepet_message: message });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have changed the status , response will be shared with the user !',
      });

      refetch();
      onCloseModal();
    } finally {
      setLoading(false);
    }
  };

  const rejectAction = async (meeting_id: number) => {
    try {
      setLoadingReject(true);
      await rejectMeetingStatus({ meeting_id, reject_reason: message });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have canceled meeting request, response will be shared with the user !',
      });
      onCloseModal2();
    } finally {
      setLoadingReject(false);
    }
  };
  const confirmAction = async (meeting_id: string) => {
    try {
      setLoading(true);
      await confirmDeal({ meeting_id });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have confirm the deal !',
      });
      onCloseModal3();
    } finally {
      setLoading(false);
    }
  };
  const cancelAction = async (meeting_id: string) => {
    try {
      setLoading(true);
      await cancelDeal({ meeting_id });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have cancelled the deal !',
      });
      onCloseModal4();
    } finally {
      setLoading(false);
    }
  };
  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar content="This page displays all of your business meeting bookings to discuss REEIPO deals." />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container">
        <div className="row meeting-sent">
          {isLoading || isFetching ? (
            <MyListingLoader />
          ) : (
            <>
              <div className="row">
                <div className="col-12 col-md-10">
                  {selectedType === 'sent' ? (
                    <h3>Booking Requests Sent</h3>
                  ) : (
                    <h3>Booking Requests Received</h3>
                  )}
                </div>
                <div className="col-12 col-md-2 meeting-booking">
                  <div className="row">
                    <FormControl>
                      <InputLabel>Select Meeting type</InputLabel>
                      <Select value={selectedType} onChange={handleChange} label="Select an option">
                        <MenuItem value="sent">Sent</MenuItem>
                        <MenuItem value="recieved">Recieved</MenuItem>
                      </Select>
                    </FormControl>
                  </div>
                </div>
              </div>
              {list?.length > 0 ? (
                list?.map((item, index) => (
                  <>
                    <div className="col-md-8 col-sm-8 out-pay mt-2" key={index}>
                      <div className="pay-box row">
                        <div className="col-md-4 col-sm-4">
                          <Image src={item?.customer_image} alt="" />
                        </div>
                        <div className="col-md-8">
                          <div className="item-boxs">
                            <span className="crated-span">
                              {timeFromNow(item?.created_date)} ago
                            </span>
                            <h5>{item?.property_name}</h5>

                            <div className="row ity">
                              <p className="leftSd col-md-8 col-7">Customer Name</p>
                              <p className="rightSd col-5 col-md-4">{item?.customer_name}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-7">{i18next.t('Phone')}</p>
                              <p className="rightSd col-5 col-md-4">{item?.phone_number}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-7">Meeting Date</p>
                              <p className="rightSd col-5 col-md-4">{item?.book_date}</p>
                            </div>
                            <div className="row ity">
                              <p className="leftSd col-md-8 col-7">Meeting Time</p>
                              <p className="rightSd col-5 col-md-4">{item?.book_time}</p>
                            </div>
                            <div className="row ity">
                              <p className=" col-12">{i18next.t('Message')} :</p>
                              {read === true ? (
                                <p className=" col-12 msgMeeting">
                                  {item?.message}
                                  <button className="showMOre" onClick={() => setRead(false)}>
                                    Hide{' '}
                                  </button>
                                </p>
                              ) : (
                                <p className=" col-12 msgMeeting">
                                  {trimSixty(item?.message)}
                                  <button
                                    className="shAcceptedowMOre"
                                    onClick={() => setRead(true)}
                                  >
                                    Read more
                                  </button>
                                </p>
                              )}
                            </div>
                            {selectedType === 'sent' ? (
                              <div className="row mt-2 meeting-btns">
                                <div className="col-md-6 col-12">
                                  <Button
                                    variant="outline"
                                    onClick={() =>
                                      navigate(
                                        `/sale-detail/${item?.property_id}?type=BusinessSale`
                                      )
                                    }
                                  >
                                    View Property
                                  </Button>
                                </div>
                                <div className="col-md-6 col-12">
                                  {item?.meeting_status === 'pending' && <Button>Pending</Button>}
                                  {item?.meeting_status === 'accepted' && (
                                    <Button>Meeting Confirmed</Button>
                                  )}
                                  {item?.meeting_status === 'rejected' && (
                                    <Button>Meeting Cancelled</Button>
                                  )}
                                  {item?.meeting_status === 'confirm_deal' && (
                                    <Button onClick={() => handlePay(item?.meeting_id)}>
                                      Pay now
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'cancle_deal' && (
                                    <Button>Deal Cancelled</Button>
                                  )}
                                  {item?.meeting_status === 'deal_completed' && (
                                    <Button>Payment Done </Button>
                                  )}
                                  {item?.meeting_status === 'payment_rejected' && (
                                    <Button onClick={() => handlePay(item?.meeting_id)}>
                                      Payment Rejected
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'deal_finished' && (
                                    <Button
                                    // isLoading={loading}
                                    // onClick={() => confirmActionId(item?.meeting_id)}
                                    >
                                      Deal Confirmed
                                    </Button>
                                  )}
                                </div>
                              </div>
                            ) : (
                              <div className="row mt-2 meeting-btns">
                                <div className="col-md-6">
                                  <Button
                                    variant="outline"
                                    onClick={() =>
                                      navigate(
                                        `/sale-detail/${item?.property_id}?type=BusinessSale`
                                      )
                                    }
                                  >
                                    View Property
                                  </Button>
                                </div>
                                <div className="col-md-6">
                                  {item?.meeting_status === 'pending' && (
                                    <Button onClick={() => handleId(item?.meeting_id)}>
                                      Action
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'accepted' && (
                                    <Button
                                      isLoading={loading}
                                      onClick={() => confirmActionId(item?.meeting_id)}
                                    >
                                      Confirm Deal
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'rejected' && (
                                    <Button
                                      isLoading={loading}
                                      onClick={() => confirmActionId(item?.meeting_id)}
                                    >
                                      Meeting Rejected
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'deal_finished' && (
                                    <Button
                                    // isLoading={loading}
                                    // onClick={() => confirmActionId(item?.meeting_id)}
                                    >
                                      Deal Confirmed
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'confirm_deal' && (
                                    <Button>Waiting For Payment</Button>
                                  )}
                                  {item?.meeting_status === 'cancle_deal' && (
                                    <Button
                                      isLoading={loading}
                                      // onClick={() => cancleActionId(item?.meeting_id)}
                                    >
                                      Deal Cancelled
                                    </Button>
                                  )}
                                  {item?.meeting_status === 'deal_completed' && (
                                    <Button
                                      onClick={() =>
                                        navigate(
                                          `/user/verify-business-contract?id=${item?.meeting_id}`
                                        )
                                      }
                                    >
                                      Verify Payment{' '}
                                    </Button>
                                  )}
                                  {/* {item?.meeting_status === 'deal_completed' && (
                                    <Button>Payment Done</Button>
                                  )} */}
                                  {item?.meeting_status === 'payment_rejected' && (
                                    <Button
                                      onClick={() =>
                                        navigate(
                                          `/user/verify-business-contract?id=${item?.meeting_id}`
                                        )
                                      }
                                    >
                                      Payment Rejected{' '}
                                    </Button>
                                  )}
                                </div>
                              </div>
                            )}
                          </div>
                        </div>
                      </div>
                    </div>
                  </>
                ))
              ) : (
                <h5 className="makeCenter">No Meetings Booked!</h5>
              )}
            </>
          )}
        </div>
      </div>
      <Modal open={open} onClose={onCloseModal} center>
        <section className="addModelss">
          <div className="row">
            <h3 className="sselect">Are you sure you want to accept the property.</h3>
            <div className="msgReject">
              <TextField
                label="Provide a message for accept meeting."
                variant="outlined"
                multiline
                rows={4}
                fullWidth
                value={message}
                onChange={handleInputChange}
              />
            </div>
            <div className="col-6 col-sm-6 rightAlignButton">
              <Button onClick={handlerejectModel}>Reject</Button>
            </div>
            <div className="col-6 col-sm-6 leftAlignButton">
              <Button isLoading={apiLoading} onClick={() => acceptAction(selectedId)}>
                Accept
              </Button>
            </div>
          </div>
        </section>
      </Modal>
      <Modal open={open2} onClose={onCloseModal2} center>
        <section className="addModelss">
          <div className="row">
            <h3 className="sselect">Are you sure you want to Reject the meeting request.</h3>
            <div className="msgReject">
              <TextField
                label="Provide a message for rejecting meeting."
                variant="outlined"
                multiline
                rows={4}
                fullWidth
                value={message}
                onChange={handleInputChange}
              />
            </div>
            <div className="col-6 col-sm-6 rightAlignButton">
              <Button onClick={onCloseModal2}>No</Button>
            </div>
            <div className="col-6 col-sm-6 leftAlignButton">
              <Button
                disabled={isDisable}
                isLoading={loadingReject}
                onClick={() => rejectAction(selectedId)}
              >
                {i18next.t('Yes')}
              </Button>
            </div>
          </div>
        </section>
      </Modal>
      <Modal open={open3} onClose={onCloseModal3} center>
        <section className="addModelss">
          <div className="row">
            <h3 className="sselect">Are you sure you want to confirm the deal.</h3>
            <div className="col-6 col-sm-6 rightAlignButton">
              <Button onClick={handleRejectDealModel}>Cancle Deal</Button>
            </div>
            <div className="col-6 col-sm-6 leftAlignButton">
              <Button isLoading={apiLoading} onClick={() => confirmAction(confirmId)}>
                Accept Deal
              </Button>
            </div>
          </div>
        </section>
      </Modal>
      <Modal open={open4} onClose={onCloseModal4} center>
        <section className="addModelss">
          <div className="row">
            <h3 className="sselect">Are you sure you want to cancel the deal.</h3>
            <div className="col-6 col-sm-6 rightAlignButton">
              <Button onClick={onCloseModal4}>No</Button>
            </div>
            <div className="col-6 col-sm-6 leftAlignButton">
              <Button isLoading={apiLoading} onClick={() => cancelAction(confirmId)}>
                Yes , cancel deal
              </Button>
            </div>
          </div>
        </section>
      </Modal>
      <Modal open={open5} onClose={onCloseModal5} center>
        <section className="model-datas">
          <h3>Please select the payment method..</h3>
        </section>
        <p className="btn-lines delete-bots">
          <Button onClick={handleOfflineNavigate}>Offline</Button>
          <Button onClick={handleOnlineNavigate}>Online</Button>
        </p>
      </Modal>
      <br />
      <Footer />
    </>
  );
};
