import Footer from '@/components/Layout/Footer/Footer';
// import './landing.css';
import React, { useEffect, useState } from 'react';
import MyListingLoader from '@/components/Elements/Loader/MyListingLoader';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import { timeFromNow } from '@/utils/format';
import './BuySharesDetail.css';
import 'react-responsive-modal/styles.css';
import { FormControl, InputLabel, MenuItem, Select } from '@mui/material';
import { Button } from '@/components/Elements';
import { useNotificationStore } from '@/stores/notifications';
import { confirmDeal } from '@/api/businessInquiry/confirmDeal';
import { useCustomerAgencyListing } from '@/api/AgencyApi/customerAgencyListing';
import { ConfirmDialogWithButton } from '@/components/Elements/ConfirmationDialog/ConfirmDialogWithButton';
import { confirmRequestFromAgency } from '@/api/AgencyApi/confirmRequestFromAgency';
import { useBUyShareDetail } from '@/api/AgencyApi/getBUyShareDetail';
import { approveBuyShares } from '@/api/AgencyApi/approveBuyShares';
import i18next from 'i18next';

export const BuySharesDetail = () => {
  const navigate = useNavigate();
  const [selectedType, setSelectedType] = useState('recieved');
  const [indexVal, setindex] = useState();
  const [loading, setLoading] = useState(false);
  const [isShow, setisShow] = useState(false);
  const { data, isLoading, isFetching, refetch } = useBUyShareDetail({
    type: selectedType,
  });
  const handleChange = (event: any) => {
    setSelectedType(event.target.value);
  };
  useEffect(() => {
    refetch();
  }, [selectedType]);
  const list = data?.data;

  const confirmAction = async (request_id: string) => {
    try {
      setLoading(true);
      await approveBuyShares({ request_id });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'You have approved the request !',
      });
    } finally {
      setLoading(false);
      close();
    }
  };

  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar content={'View all of your shares related decisions here.'} />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>

      <div className="container">
        <div className="row meeting-sent">
          {isLoading || isFetching ? (
            <MyListingLoader />
          ) : (
            <>
              <div className="row">
                <div className="col-12 col-md-10">
                  {selectedType === 'sent' ? (
                    <h3>Requests to Sell Your Shares</h3>
                  ) : (
                    <h3>Requests to Buy Your Shares</h3>
                  )}
                </div>
                <div className="col-12 col-md-2 meeting-booking">
                  <div className="row">
                    <FormControl>
                      <InputLabel>Select reuqest type</InputLabel>
                      <Select value={selectedType} onChange={handleChange} label="Select an option">
                        <MenuItem value="recieved">Recieved</MenuItem>
                        <MenuItem value="sent">Sent</MenuItem>
                      </Select>
                    </FormControl>
                  </div>
                </div>
              </div>
              {list?.length > 0 ? (
                list?.map((item: any, index: any) => (
                  <>
                    {selectedType == 'sent' ? (
                      <>
                        <div className="col-md-6 col-sm-6 out-pay mt-2" key={index}>
                          <div className="pay-box agency">
                            <div className="">
                              <div
                                className="item-boxs makebtn"
                                role="button"
                                // onClick={() => navigate(`${item?.url}`)}
                              >
                                <span className="crated-span">
                                  {timeFromNow(item?.created_date)} ago
                                </span>
                                <div className="row ity opopop">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Company Name</p>
                                  <p className="rightSd col-6 col-md-6">{item?.company_name}</p>
                                </div>

                                {indexVal == index && isShow ? (
                                  <>
                                    {/* <div className="row ity">
                                      <p className="leftSd col-md-6 col-6 semi-bold">
                                        Company Name
                                      </p>
                                      <p className="rightSd col-6 col-md-6">{item?.company_name}</p>
                                    </div> */}
                                    <div className="row ity">
                                      <p className="leftSd col-md-6 col-6 semi-bold">
                                        Company Email account
                                      </p>
                                      <p className="rightSd col-6 col-md-6">
                                        {item?.company_email}
                                      </p>
                                    </div>
                                    <div className="row ity">
                                      <p className="leftSd col-md-6 col-6 semi-bold">
                                        {i18next.t('Phone Number')}
                                      </p>
                                      <p className="rightSd col-6 col-md-6">
                                        {item?.company_phone_number}
                                      </p>
                                    </div>
                                  </>
                                ) : null}
                                {item?.share_status === 'Pending' ? (
                                  <span className="yoyo">
                                    {' '}
                                    <i className="fa-solid fa-hourglass-half"></i> Pending
                                  </span>
                                ) : (
                                  <>
                                    {isShow ? null : (
                                      <span className="yoyoApr">
                                        <i className="fa-regular fa-circle-check"></i> Approved
                                      </span>
                                    )}
                                  </>
                                )}
                              </div>
                              <div className="row mt-2 mmmm">
                                {item?.share_status === 'Pending' ? (
                                  <button className="viewDetails22">
                                    View Details{' '}
                                    <span className="monio">
                                      You are able to view Company deatil after request get approved
                                    </span>
                                  </button>
                                ) : (
                                  <button
                                    className="viewDetails"
                                    onClick={() => {
                                      setindex(index), setisShow(!isShow);
                                    }}
                                  >
                                    {isShow ? 'Hide Details' : 'View Details'}
                                  </button>
                                )}
                              </div>
                            </div>
                          </div>
                        </div>
                      </>
                    ) : (
                      <>
                        <div className="col-md-6 col-sm-6 out-pay mt-2" key={index}>
                          <div className="pay-box agency">
                            <div className="">
                              <div className="item-boxs">
                                <span className="crated-span">
                                  {timeFromNow(item?.created_date)} ago
                                </span>

                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Customer Name</p>
                                  <p className="rightSd col-6 col-md-6">{item?.customer_name}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">Customer Email</p>
                                  <p className="rightSd col-6 col-md-6">{item?.customer_email}</p>
                                </div>
                                <div className="row ity">
                                  <p className="leftSd col-md-6 col-6 semi-bold">
                                    {i18next.t('Phone')}
                                  </p>
                                  <p className="rightSd col-6 col-md-6">
                                    {item?.customer_phone_number}
                                  </p>
                                </div>
                              </div>

                              {item?.share_status == 'Approved' ? (
                                <div className="w-full AcceptedDiv">
                                  <Button disabled={true}>Approved</Button>
                                </div>
                              ) : (
                                <div className="divCentr mt-3">
                                  <ConfirmDialogWithButton
                                    triggerButton={<Button variant="outlineDark">Approve</Button>}
                                    confirmButton={
                                      <Button
                                        isLoading={loading}
                                        onClick={() => confirmAction(item?.id)}
                                        variant="primary"
                                      >
                                        Approve
                                      </Button>
                                    }
                                    title="Confirm"
                                    icon="info"
                                    body="Are you sure you want to approve this request?"
                                  />
                                </div>
                              )}
                            </div>
                          </div>
                        </div>
                      </>
                    )}
                  </>
                ))
              ) : (
                <h5 className="makeCenter">Nothing to Show Yet!</h5>
              )}
            </>
          )}
        </div>
      </div>

      <br />
      <Footer />
    </>
  );
};
