import React, { useState } from 'react';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import Checkbox from '@mui/material/Checkbox';
// import FormGroup from '@mui/material/FormGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import { z } from 'zod';
import { Form, InputField, TextAreaField } from '@/components/Form';
import { Button } from '@/components/Elements';
import { useNotificationStore } from '@/stores/notifications';
import './Contracts.css';

function AddTask() {
  const taskschema = z.object({
    names: z.string().min(1, 'Please enter your company name'),
    dates: z.string().min(1, 'Please enter your full name'),
  });

  type taskValues = {
    names: string;
    dates: string;
    status: string;
  };
  const [inputVal, setInputValue] = useState({
    names: '',
    dates: '',
    status: 'pending',
  });

  const [artists, setArtists] = useState<any>([]);

  // let nextId = 0;
  const [nextId, setNextId] = useState(0);
  const handleSubmit2 = (event) => {
    setArtists([...artists, { id: nextId, inputVal }]);
    setNextId(nextId + 1);
    event.preventDefault();
  };
  const handleTaskSubmit = async (values: taskValues) => {
    try {
      setInputValue(values);
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'info',
        message: 'Task added successfully!',
      });
    } finally {
      console.log('Task added successfully!');
    }
  };
  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => {
    handleSubmit2(event);
    setOpen(false);
  };

  return (
    <>
      <div className="bOx">
        <div className="row taskMOdel">
          <div className="col-6 col-md-6">
            <h4>Tasks</h4>
          </div>

          <div className="col-6 col-md-6 taskbtn">
            <Button onClick={onOpenModal}>+ Add Tasks</Button>
          </div>
          <div className="box-in-form">
            <Modal open={open} onClose={onCloseModal} center>
              <section className="model-datas">
                <h3>Task name </h3>
                <div>
                  <Form<taskValues, typeof taskschema>
                    onSubmit={handleTaskSubmit}
                    schema={taskschema}
                  >
                    {({ register, formState }) => (
                      <>
                        <div>
                          <TextAreaField
                            label="Add Task"
                            rows={4}
                            error={formState.errors['names']}
                            registration={register('names')}
                          />
                        </div>
                        <div>
                          <InputField
                            type="date"
                            label="Select Date"
                            error={formState.errors['dates']}
                            registration={register('dates')}
                            placeholder="Select Date"
                          />
                        </div>
                        <div className="row ad-btns">
                          <div className="col-6 col-md-6 left">
                            <Button type="submit">Add Task</Button>
                          </div>

                          <div className="col-6 col-md-6">
                            <Button onClick={onCloseModal}>Close</Button>
                          </div>
                        </div>
                      </>
                    )}
                  </Form>
                </div>
              </section>
            </Modal>
          </div>
        </div>

        <div>
          <ul>
            {artists.map((item: any) => (
              <>
                <li key={item.inputVal.id}>
                  <div className="bOxi">
                    <FormControlLabel control={<Checkbox />} label={item.inputVal.names} />
                    <div className="row small-in">
                      <div className="rit">
                        <span>
                          <i className="fa-solid fa-calendar"></i> {item.inputVal.dates}
                        </span>
                      </div>
                    </div>
                  </div>
                </li>
              </>
            ))}
          </ul>
        </div>
      </div>
    </>
  );
}

export default AddTask;
