import * as z from 'zod';
import React, { useState } from 'react';
import Footer from '@/components/Layout/Footer/Footer';
import { Button } from '@/components/Elements';
import { Form, InputField } from '@/components/Form';
import UserHeadBar from '../../components/UserHeadBar';
import { SigneeDetail } from '@/types';
import Signature from '@/components/Elements/Loader/Signature';
import { useNotificationStore } from '@/stores/notifications';
import { Link, useNavigate } from 'react-router-dom';
import DigitalSignature from './DigitalSignature';
import './Contracts.css';
import './PayStubForm.css';
import { useSigneeDetails } from '@/api/contract/getSigneeData';
import { ovnerSignContract } from '@/api/contract/ovnerSignContract';
import { buyerSignContract } from '@/api/contract/buyerSignContract';
// import FileViewer from '@/components/Viewer/FileViewer';
import digitalSignature from '@/assets/digitalSignature.png';
import FileViewer from '@/components/Viewer/FileViewer';
import i18next from 'i18next';

export const ContractSignin = () => {
  const ownerSchema = z.object({
    owner_full_name: z.string().min(1, 'Please enter owner full name'),
    owner_email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
  });

  type ownerValues = {
    owner_full_name: string;
    owner_email: string;
    id: string;
  };
  const buyerSchema = z.object({
    buyer_full_name: z.string().min(1, 'Please enter buyer full name'),
    buyer_email: z
      .string()
      .min(1, 'Please enter email address')
      .email('Please enter valid email address!'),
  });

  type buyerValues = {
    buyer_full_name: string;
    buyer_email: string;
    id: string;
  };

  const navigate = useNavigate();

  const searchParams = new URLSearchParams(document.location.search);
  const contractID = searchParams.get('id');

  const { data, isLoading, isFetching } = useSigneeDetails({ id: contractID ?? '1' });
  const user = data?.data ?? ({} as SigneeDetail);

  const [ownerSignature, setOwnerSignature] = useState<any>();
  const [buyerSignature, setBuyerSignature] = useState<any>();

  const isSignedByBuyer = user?.buyer_signature;
  const isSignedBySeller = user?.owner_signature;

  const userData = user.user_type;
  let isSeller = true;
  let isBuyer = true;

  const taskData = user?.task ?? '';
  const json = eval(taskData);

  const handleOwnerSubmit = async (values: ownerValues) => {
    try {
      let idValue = '';
      if (contractID) {
        idValue = contractID;
      }
      await ovnerSignContract({ ...values, id: idValue, owner_signature: ownerSignature });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Owner Contract signed successfully!',
      });

      if (userData == 'seller') {
        navigate(`/user/my-leads`);
      } else {
        navigate(`/user/purchase?id=${contractID}`);
      }
    } finally {
    }
  };
  const handleBuyerSubmit = async (values: buyerValues) => {
    try {
      let idValue = '';
      if (contractID) {
        idValue = contractID;
      }
      await buyerSignContract({
        ...values,
        id: idValue,
        buyer_signature: buyerSignature,
      });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Owner Contract signed successfully!',
      });
      navigate(`/user/purchase?id=${contractID}`);
    } finally {
    }
  };
  return (
    <>
      {isLoading || isFetching ? (
        <Signature />
      ) : (
        <>
          <UserHeadBar />
          <section className="contract-cont container">
            <p className="topHeadings">
              <div className="sign-crt">Sign contract</div>
              <Link to={user?.contract_file} target="_blank">
                View Contract
              </Link>
            </p>
            <div className="contract-vwr">
              <FileViewer file={user?.contract_file}></FileViewer>
            </div>
            <div className="row contrt">
              <div className="col-12  col-md-12 col-lg-8 outr-div">
                <div className="row">
                  <div className="col-12 col-md-6 no-space">
                    {isSignedBySeller != '' ? (
                      (isSeller = true)
                    ) : (
                      <>{userData == 'seller' ? (isSeller = false) : (isSeller = true)}</>
                    )}
                    <fieldset disabled={isSeller}>
                      <Form<ownerValues, typeof ownerSchema>
                        onSubmit={handleOwnerSubmit}
                        schema={ownerSchema}
                        options={{
                          defaultValues: user,
                        }}
                      >
                        {({ register, formState }) => (
                          <>
                            <p className="form-heading">
                              <i className="fa-regular fa-user"></i> Seller Sign
                            </p>
                            <div className="bOx">
                              <div>
                                <InputField
                                  label="Full Name"
                                  type="text"
                                  error={formState.errors['owner_full_name']}
                                  registration={register('owner_full_name')}
                                />
                              </div>
                              <div>
                                <InputField
                                  label={i18next.t('Email')}
                                  type="email"
                                  error={formState.errors['owner_email']}
                                  registration={register('owner_email')}
                                />
                              </div>

                              <div className="signatureDiv">
                                <p>Signature</p>

                                {isSignedBySeller ? (
                                  <>
                                    <img
                                      src={isSignedBySeller}
                                      alt="sasa"
                                      className="signature-preview"
                                    />
                                  </>
                                ) : (
                                  <div className="beforeSign">
                                    {ownerSignature ? (
                                      <>
                                        <img
                                          className="signature-preview"
                                          src={ownerSignature}
                                          alt="sasa"
                                        />
                                      </>
                                    ) : (
                                      <>
                                        <img
                                          className="signature-preview-2"
                                          src={digitalSignature}
                                          alt="sasa"
                                        />
                                        <span className="imageSpan">
                                          Signature will appear here
                                        </span>
                                      </>
                                    )}
                                  </div>
                                )}

                                <div className="d-flex justify-content-center signature-contract">
                                  <DigitalSignature setSignature={setOwnerSignature} />

                                  <button
                                    type="button"
                                    className="btn btn-secondary mt-3 ml-3"
                                    style={{ marginBottom: '34px' }}
                                    onClick={() => setOwnerSignature(null)}
                                  >
                                    {i18next.t('Clear')}
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div className="btn-btn">
                              {isSeller ? null : (
                                <Button className="mid-button-form verified" type="submit">
                                  Send
                                </Button>
                              )}
                            </div>
                          </>
                        )}
                      </Form>
                    </fieldset>
                    <div className="btn-btn">
                      {isSignedBySeller && isSignedByBuyer ? (
                        <>
                          {userData == 'seller' ? (
                            <Button className="mid-button-form">
                              <i className="fa-solid fa-check"></i> Contract Verified
                            </Button>
                          ) : null}
                        </>
                      ) : null}
                    </div>
                  </div>
                  <div className="col-12 col-md-6 no-space">
                    {isSignedByBuyer != '' ? (
                      (isSeller = true)
                    ) : (
                      <>{userData == 'buyer' ? (isBuyer = false) : (isBuyer = true)}</>
                    )}

                    <fieldset disabled={isBuyer}>
                      <Form<buyerValues, typeof buyerSchema>
                        onSubmit={handleBuyerSubmit}
                        schema={buyerSchema}
                        options={{
                          defaultValues: user,
                        }}
                      >
                        {({ register, formState }) => (
                          <>
                            <p className="form-heading">
                              <i className="fa-regular fa-user"></i>
                              <span className="buyers-sign"> Buyer Sign</span>
                            </p>
                            <div className="bOx">
                              <div>
                                <InputField
                                  label="Full Name"
                                  type="text"
                                  error={formState.errors['buyer_full_name']}
                                  registration={register('buyer_full_name')}
                                />
                              </div>

                              <div>
                                <InputField
                                  label={i18next.t('Email')}
                                  type="email"
                                  error={formState.errors['buyer_email']}
                                  registration={register('buyer_email')}
                                />
                              </div>

                              <div className="signatureDiv">
                                <p>Signature</p>
                                {isSignedByBuyer ? (
                                  <>
                                    <img
                                      src={isSignedByBuyer}
                                      alt="sasa"
                                      className="signature-preview"
                                    />
                                  </>
                                ) : (
                                  <div className="beforeSign">
                                    {buyerSignature ? (
                                      <>
                                        <img
                                          className="signature-preview"
                                          src={buyerSignature}
                                          alt="sasa"
                                        />
                                      </>
                                    ) : (
                                      <>
                                        <img
                                          className="signature-preview-2"
                                          src={digitalSignature}
                                          alt="sasa"
                                        />
                                        <span className="imageSpan">
                                          Signature will appear here
                                        </span>
                                      </>
                                    )}
                                  </div>
                                )}
                                <div className="d-flex justify-content-center  signature-contract">
                                  <DigitalSignature setSignature={setBuyerSignature} />

                                  <button
                                    type="button"
                                    className="btn btn-secondary mt-3 ml-3"
                                    style={{ marginBottom: '34px' }}
                                    onClick={() => setBuyerSignature(null)}
                                  >
                                    {i18next.t('Clear')}
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div className="btn-btn">
                              {isBuyer ? null : (
                                <Button className="mid-button-form" type="submit">
                                  Send{' '}
                                </Button>
                              )}
                            </div>
                          </>
                        )}
                      </Form>
                    </fieldset>
                    <div className="btn-btn">
                      {isSignedBySeller && isSignedByBuyer ? (
                        <>
                          {userData == 'buyer' ? (
                            <Button
                              className="mid-button-form"
                              onClick={() => navigate(`/user/purchase?id=${contractID}`)}
                            >
                              Pay now
                            </Button>
                          ) : null}
                        </>
                      ) : null}
                    </div>
                  </div>
                </div>
              </div>

              <div className="col-12  col-md-12 col-lg-4 outr-div">
                <div className="bOx tsk moveable">
                  <h4>Tasks</h4>

                  <div>
                    <ul>
                      {json.map((item: any) => (
                        <>
                          <li key={item.id}>
                            <div className="bOxi">
                              <p>{item.names}</p>
                              <div className="row small-in">
                                <div className="col-12 col-md-12 rit">
                                  <span>
                                    <i className="fa-solid fa-calendar"></i> {item.dates}
                                  </span>
                                </div>
                              </div>
                            </div>
                          </li>
                        </>
                      ))}
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </section>
          <br />
          <Footer />
        </>
      )}
    </>
  );
};
