import * as z from 'zod';
import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { Button } from '@/components/Elements';
import plus from '@/assets/plus.png';
import { Form, InputField, TextAreaField } from '@/components/Form';
import Footer from '@/components/Layout/Footer/Footer';
import UserHeadBar from '../../components/UserHeadBar';
import Checkbox from '@mui/material/Checkbox';
// import FormGroup from '@mui/material/FormGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import './Contracts.css';
import { createContract } from '@/api/contract/createContract';
import { useNotificationStore } from '@/stores/notifications';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import { uploadImage } from '@/api/uploadImage';
import { useSelectFile } from '@/hooks/useSelectFile';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import CustomTooltip from '@/components/Elements/CustomTooltip/CustomTooltip';
import { contractByLawyer } from '../../api/contractByLawyer';
export const Contracts = () => {
  const schema = z.object({
    company_name: z.string().min(1, 'Please enter your company name'),
    full_name: z.string().min(1, 'Please enter your full name'),

    // user_level: z.string().min(1, 'Please select one option'),
    // user_level2: z.string().min(1, 'Please select one option'),
  });

  type ContactValues = {
    company_name: string;
    full_name: string;
    contract_file: File;
    // user_level: string;
    // user_level2: string;
  };
  const taskschema = z.object({
    names: z.string().min(1, 'Please enter valid task'),
    dates: z.string().min(1, 'Please enter date'),
  });

  type taskValues = {
    names: string;
    dates: string;
    status: string;
  };

  const searchParams = new URLSearchParams(document.location.search);
  const contractId = searchParams.get('id');
  const personName = searchParams.get('name');
  const navigate = useNavigate();
  const [loading, setLoading] = useState(false);
  const { file, preview, handleChange, pdfName } = useSelectFile();
  const [artists, setArtists] = useState<any>([]);
  const [nextId, setNextId] = useState(0);

  const handleTaskSubmit = (values: taskValues) => {
    try {
      setLoading(true);
      setArtists([
        ...artists,
        { id: nextId, names: `${values.names}`, dates: `${values.dates}`, status: 'pending' },
      ]);
      setOpen(false);
      setNextId(nextId + 1);
    } finally {
      setLoading(false);
    }
  };

  const handleSubmit = async (values: ContactValues) => {
    try {
      setLoading(true);
      let pdfUrl = '';
      let responseId = '';
      if (file) {
        const response = await uploadImage({ file });
        pdfUrl = response.url;
      }
      await createContract({
        ...values,
        id: contractId ?? 'null',
        contract_file: pdfUrl,
        tasks: artists ?? 'one',
        full_name: personName ?? 'not found',
      }).then(function (response) {
        responseId = response.contract_id;
      });
      useNotificationStore.getState().addNotification({
        title: 'Success',
        type: 'success',
        message: 'Contract created successfully!',
      });
      navigate(`/user/contract-signin?id=${responseId}`);
    } finally {
      setLoading(false);
    }
  };
  // const handleLevelChange = (e: any) => {
  //   setUserLevel(e.target.value);
  // };
  // const handleLevelChange2 = (e: any) => {
  //   setUserLevel2(e.target.value);
  // };
  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => {
    setOpen(false);
  };

  const handleLawyerBtn = async () => {
    setLoading(true);
    await contractByLawyer(contractId ?? '');
    setLoading(false);
    useNotificationStore.getState().addNotification({
      type: 'success',
      title: 'Success',
      message: 'Lawyer have been notified !',
    });
    navigate('/');
  };

  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <section className="container">
        <p className="topHeadings">
          <div className="sign-crt">Create a contract</div>
        </p>
        <Form<ContactValues, typeof schema> onSubmit={handleSubmit} schema={schema}>
          {({ register, formState }) => (
            <>
              <div className="row contrt">
                <div className="col-12  col-md-12 col-lg-8 outr-div">
                  <div className="bOxer">
                    <h5 className="headf">Contract Upload</h5>
                    <label htmlFor="fileInput">
                      <div>
                        {/* {preview ? <p>{pdfName}</p> : <img src={plus} alt="" width="60" />} */}
                        {preview ? (
                          <>
                            {pdfName ? (
                              <>
                                <div className="files-box">
                                  <p>{pdfName}</p>
                                </div>
                              </>
                            ) : (
                              <>
                                <div className="image-box">
                                  <img src={preview} alt="" className="profileImage" />
                                </div>
                              </>
                            )}
                          </>
                        ) : (
                          <>
                            <div className="files-box">
                              <img src={plus} alt="" width="60" />
                            </div>
                          </>
                        )}
                      </div>
                    </label>
                    <input
                      accept="pdf/*"
                      onChange={handleChange}
                      type="file"
                      id="fileInput"
                      className="d-none"
                    />
                    <br />

                    <div className="row  company-details mt-4">
                      <div className="col-12 col-md-6">
                        <h5>
                          <i className="fa-regular fa-building"></i> Company Name
                        </h5>
                        {/* <div className=" d-flex justify-content-around checkboxes">
                          <RadioButtonField
                            value="company"
                            registration={register('user_level', {
                              onChange: handleLevelChange,
                              value: 'private_user',
                            })}
                            error={formState.errors['user_level']}
                            label="Company"
                          />
                          <RadioButtonField
                            value="private_user"
                            registration={register('user_level', {
                              onChange: handleLevelChange,
                              value: 'private_user',
                            })}
                            error={formState.errors['user_level']}
                            label="Private person"
                          />
                        </div> */}
                        <div>
                          <InputField
                            type="text"
                            label={i18next.t('Company name')}
                            error={formState.errors['company_name']}
                            registration={register('company_name')}
                            placeholder={i18next.t('Company name')}
                          />
                        </div>
                      </div>
                      <div className="col-12 col-md-6">
                        <h5>
                          <i className="fa-regular fa-user"></i> {i18next.t('User Name')}
                        </h5>
                        {/* <div className=" d-flex justify-content-around checkboxes">
                          <RadioButtonField
                            value="company2"
                            registration={register('user_level2', {
                              onChange: handleLevelChange2,
                              value: 'company2',
                            })}
                            error={formState.errors['user_level2']}
                            label="Company"
                          />
                          <RadioButtonField
                            value="private_user2"
                            registration={register('user_level2', {
                              onChange: handleLevelChange2,
                              value: 'private_user2',
                            })}
                            error={formState.errors['user_level2']}
                            label="Private person"
                          />
                        </div> */}
                        <div>
                          <InputField
                            type="text"
                            label="Full name"
                            error={formState.errors['full_name']}
                            registration={register('full_name', { value: `${personName}` })}
                            placeholder="Full name"
                            disabled
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="col-12 col-md-12  col-lg-4 outr-div">
                  <div className="bOxer">
                    <div className="row taskMOdel">
                      <div className="col-12 col-md-12 col-lg-6">
                        <h4 className="task-tooltip">
                          Tasks
                          <CustomTooltip
                            text={'Share the details of the facilities , offered by the owner.'}
                          />
                        </h4>
                      </div>

                      <div className="col-12 col-md-12 col-lg-6 taskbtn">
                        <Button onClick={onOpenModal}>+ Add Tasks</Button>
                      </div>
                    </div>
                    {nextId != 0 ? (
                      <>
                        {' '}
                        <div className="sd">
                          <ul>
                            {artists.map((item: any) => (
                              <>
                                <li key={item.id}>
                                  <div className="bOxi">
                                    <FormControlLabel control={<Checkbox />} label={item.names} />
                                    <div className="row small-in">
                                      <div className="rit">
                                        <span>
                                          <i className="fa-solid fa-calendar"></i> {item.dates}
                                        </span>
                                        <button
                                          className="delt"
                                          onClick={() => {
                                            setArtists((artists: any[]) =>
                                              artists.filter((data) => data.id != `${item.id}`)
                                            );
                                          }}
                                        >
                                          Delete
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                </li>
                              </>
                            ))}
                          </ul>
                        </div>{' '}
                      </>
                    ) : (
                      <p className="notask">No task is added</p>
                    )}
                  </div>
                  <div className="btn-btn mt-2">
                    <Button type="button" className="mt-2" onClick={handleLawyerBtn}>
                      Do it by Lawyer
                    </Button>
                  </div>
                </div>
              </div>
              <div className="btn-btn">
                <Button type="submit" className="ms-3">
                  Send For Signing
                </Button>
              </div>
            </>
          )}
        </Form>
        <div className="box-in-form">
          <Modal open={open} onClose={onCloseModal} center>
            <section className="model-datas">
              <h3>Task name </h3>
              <div>
                <Form<taskValues, typeof taskschema>
                  onSubmit={handleTaskSubmit}
                  schema={taskschema}
                >
                  {({ register, formState }) => (
                    <>
                      <div>
                        <TextAreaField
                          label="Add Task"
                          rows={4}
                          error={formState.errors['names']}
                          registration={register('names')}
                        />
                      </div>
                      <div>
                        <InputField
                          type="date"
                          label="Select Date"
                          error={formState.errors['dates']}
                          registration={register('dates')}
                          placeholder="Select Date"
                        />
                      </div>
                      <div className="row ad-btns">
                        <div className="col-12 col-md-6 left">
                          <Button type="submit">Add Task</Button>
                        </div>

                        <div className="col-12 col-md-6">
                          <Button onClick={onCloseModal}>Close</Button>
                        </div>
                      </div>
                    </>
                  )}
                </Form>
              </div>
            </section>
          </Modal>
        </div>
      </section>
      <br />
      <Footer />
    </>
  );
};
