/* eslint-disable jsx-a11y/no-autofocus */
import React, { LegacyRef, useRef } from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Button from '@material-ui/core/Button';
import Dialog from '@material-ui/core/Dialog';
import AppBar from '@material-ui/core/AppBar';
import Toolbar from '@material-ui/core/Toolbar';
import IconButton from '@material-ui/core/IconButton';
import Typography from '@material-ui/core/Typography';
import CloseIcon from '@material-ui/icons/Close';
import Slide from '@material-ui/core/Slide';
import SignatureCanvas from 'react-signature-canvas';
import ReactSignatureCanvas from 'react-signature-canvas';

const useStyles = makeStyles((theme) => ({
  appBar: {
    position: 'relative',
  },
  title: {
    marginLeft: theme.spacing(2),
    flex: 1,
  },
}));

const Transition = React.forwardRef(function Transition(props: any, ref: any) {
  return <Slide direction="up" ref={ref} {...(props ?? ' ')} />;
});

export default function DigitalSignature({ setSignature }: { setSignature: any }) {
  const classes = useStyles();
  const sigCanvas = useRef<LegacyRef<ReactSignatureCanvas> | null>(null);

  const [open, setOpen] = React.useState(false);

  const handleClickOpen = () => {
    setOpen(true);
  };

  const handleClose = () => {
    setOpen(false);
  };

  const clear = () => {
    sigCanvas.current.clear();
  };

  const save = () => {
    const sign = sigCanvas.current.getTrimmedCanvas().toDataURL('image/png');
    setSignature(sign);
    handleClose();
  };

  return (
    <>
      <button
        type="button"
        className="btn btn-outline-new mt-3"
        style={{ marginBottom: '34px' }}
        onClick={handleClickOpen}
      >
        Add Digital Signature
      </button>

      <Dialog fullScreen open={open} onClose={handleClose} TransitionComponent={Transition}>
        <AppBar className={classes.appBar}>
          <Toolbar>
            <IconButton
              edge="start"
              color="inherit"
              type="button"
              onClick={handleClose}
              aria-label="close"
            >
              <CloseIcon />
            </IconButton>
            <div className="digital-signs">
              <Typography variant="h6" className={classes.title}>
                Please sign here
              </Typography>
              <Button type="button" autoFocus color="inherit" onClick={save}>
                Save
              </Button>
              <Button type="button" autoFocus color="inherit" onClick={clear}>
                {i18next.t('Clear')}
              </Button>
            </div>
          </Toolbar>
        </AppBar>
        <SignatureCanvas
          penColor="black"
          canvasProps={{ className: 'sigCanvas' }}
          ref={sigCanvas}
        />
      </Dialog>
    </>
  );
}
