import React, { useEffect, useState } from 'react';
import UserHeadBar from '../../components/UserHeadBar';
import { useNavigate } from 'react-router-dom';
import './Contracts.css';
import * as z from 'zod';
import { Button } from '@/components/Elements';
import { Form, TextAreaField } from '@/components/Form';
import { useNotificationStore } from '@/stores/notifications';
import 'react-responsive-modal/styles.css';
import plus from '@/assets/plus.png';
import { Modal } from 'react-responsive-modal';
import Footer from '@/components/Layout/Footer/Footer';
import storage from '@/utils/storage';
import { uploadImage } from '@/api/uploadImage';
import { useSelectFile } from '@/hooks/useSelectFile';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import Box from '@mui/material/Box';
import Rating from '@mui/material/Rating';
import successs from '@/assets/successs.svg';
import { axios } from '@/lib/axios';

const schema = z.object({
  // rating_data: z.string().min(1, 'Please enter data datda'),
  review_data: z.string().min(1, 'Please enter data'),
});

type HouseRentFormValues = {
  rating_data: string;
  review_data: string;
  receive_customer_id: string;
};

export const OfflinePayment = () => {
  const searchParams = new URLSearchParams(document.location.search);
  const contract_id = searchParams.get('id');

  const [value, setValue] = useState<number | null>(2);

  const [open2, setOpen2] = useState(false);
  const [propertyId, setPropertyId] = useState();
  const onOpenModal2 = () => setOpen2(true);
  const onCloseModal2 = () => setOpen2(false);

  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);

  const payment_mode = 'Offline';
  const token = storage.getToken();
  const { file, preview, handleChange, pdfName } = useSelectFile();

  const [show, setShow] = useState<boolean>(false);
  const [loading, setLoading] = useState<boolean>(false);

  const handleOr = () => {
    onOpenModal();
    onCloseModal2();
  };

  useEffect(() => {
    setShow(false);
  }, [pdfName]);

  const handleSubmit = async (values: HouseRentFormValues) => {
    try {
      setLoading(true);
      values.rating_data = value;
      values.receive_customer_id = propertyId;
      axios.post('/customer-api/add-rating-review', values);
      setLoading(false);
      onCloseModal();
      navigate(`/user/my-deals`);
    } finally {
      setLoading(false);
      useNotificationStore.getState().addNotification({
        type: 'success',
        title: 'Success',
        message: 'Ratings sent successfully..',
      });
    }
  };

  // const handleSubmit2 = async () => {
  //   let pdfUrl = '';
  //   if (file) {
  //     setLoading(true);

  //     setShow(false);
  //     const response = await uploadImage({ file });
  //     pdfUrl = response.url;
  //   } else {
  //     setShow(true);
  //   }

  //   axios
  //     .post(
  //       `http://54.225.243.254:9007/customer-api/property_payment`,
  //       { contract_id, payment_mode, payment_recipet: pdfUrl },
  //       {
  //         headers: {
  //           Authorization: `${token}`,
  //         },
  //       }
  //     )
  //     .then(() => {
  //       setLoading(false);
  //       // useNotificationStore.getState().addNotification({
  //       //   type: 'success',
  //       //   title: 'Success',
  //       //   message: 'Payment record uploaded Susccessfully',
  //       // });
  //       onOpenModal2();
  //       // navigate(`/user/purchase?id=${contract_id}`);
  //     });
  // };
  const axiosUrl = process.env.REACT_APP_API_URL;

  const handleSubmit2 = async () => {
    let pdfUrl = '';
    if (file) {
      setLoading(true);

      setShow(false);
      const response = await uploadImage({ file });
      pdfUrl = response.url;
    } else {
      setShow(true);
    }

    axios
      .post(`${axiosUrl}/customer-api/property_payment`, {
        contract_id,
        payment_mode,
        payment_recipet: pdfUrl,
      })
      .then((response) => {
        setLoading(false);
        useNotificationStore.getState().addNotification({
          title: 'Success',
          type: 'success',
          message: 'Purchased successfully',
        });
        // console.log(response, 'response');

        const customer_id = response?.customer_id;
        setPropertyId(customer_id);
        // console.log(propertyId, 'propertyId');

        onOpenModal2();
        // navigate(`/user/purchase?id=${contract_id}`);
      })
      .catch((error) => {
        // Handle error, if any
        console.error(error);
      });
  };

  const navigate = useNavigate();
  const handleNavigate = () => {
    navigate('/user/online-payment');
  };
  console.log(handleNavigate);

  return (
    <>
      <UserHeadBar />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <BackdropLoader open={loading} />
      <section className="container">
        <h4>Complete Your Purchase</h4>
        <br />
        <Form onSubmit={handleSubmit2}>
          {() => (
            <>
              <div>
                <label htmlFor="fileInput">
                  <div>
                    <p>Please upload your payment reciept ......</p>
                    {preview ? (
                      <>
                        {pdfName ? (
                          <>
                            <div className="files-box">
                              <p>{pdfName}</p>
                            </div>
                          </>
                        ) : (
                          <>
                            <div className="image-box">
                              <img src={preview} alt="" className="profileImage" />
                            </div>
                          </>
                        )}
                      </>
                    ) : (
                      <>
                        <div className="files-box">
                          <img src={plus} alt="" width="60" />
                        </div>
                      </>
                    )}
                  </div>
                </label>
                <input
                  name="pdfFile"
                  accept="pdf/*"
                  onChange={handleChange}
                  type="file"
                  id="fileInput"
                  className="d-none"
                />
              </div>
              {show && <p className="errorForms">Please select a file to show paymnet record *</p>}
              <Button type="submit" variant="primary" size="md" className="mt-2 ">
                Upload
              </Button>
            </>
          )}
        </Form>
      </section>
      <Modal open={open2} onClose={onCloseModal2} center>
        <section className="review-modelss">
          <div className="row">
            <h3 className="sselect">Payment Completed Successfully</h3>
            <p className="sselect">
              <img src={successs} alt="success" />
            </p>

            <div className="row">
              <div className="col-6 col-sm-6 btnm">
                <Button onClick={() => navigate('/user/my-deals')}> {i18next.t(`Cancel`)}</Button>
              </div>
              <div className="col-6 col-sm-6 btnm">
                <Button onClick={() => handleOr()}>Give Review</Button>
              </div>
            </div>
          </div>
        </section>
      </Modal>
      {/* =============================================================== */}
      {/* 
      <Modal open={open3} onClose={onCloseModal3} center>
        <section className="review-modelss">
          <div className="row">
            <h3 className="sselect">Share your Review and Ratings here.</h3>

            <Form<HouseRentFormValues, typeof schema3> onSubmit={handleSubmit3} schema={schema3}>
              {({ register, formState }) => (
                <div className=" mb-5">
                  <div className="row mt-4">
                    <Box
                      sx={{
                        '& > legend': { mt: 2 },
                      }}
                    >
                      <Rating
                        name="simple-controlled"
                        value={value}
                        onChange={(event, newValue) => {
                          setValue(newValue);
                        }}
                      />
                    </Box>
                    <div className="col-12 mt-4">
                      <TextAreaField
                        label="Give Reviews"
                        error={formState.errors['review_data']}
                        registration={register('review_data')}
                      />
                    </div>

                    <div className="row">
                      <div className="col-6 col-sm-6 rightAlignButton">
                        <Button onClick={() => navigate(`/user/my-deals`)}> Cancel</Button>
                      </div>
                      <div className="col-6 col-sm-6 leftAlignButton">
                        <Button isLoading={loading} type="submit">
                          {' '}
                          Send
                        </Button>
                      </div>
                    </div>
                  </div>
                </div>
              )}
            </Form>
          </div>
        </section>
      </Modal> */}
      <Modal open={open} onClose={onCloseModal} center>
        <section className="review-modelss">
          <div className="row">
            <h3 className="sselect">Share your Review and Ratings here.</h3>

            <Form<HouseRentFormValues, typeof schema> onSubmit={handleSubmit} schema={schema}>
              {({ register, formState }) => (
                <div className=" mb-5">
                  <div className="row mt-4">
                    <Box
                      sx={{
                        '& > legend': { mt: 2 },
                      }}
                    >
                      <Rating
                        name="simple-controlled"
                        value={value}
                        onChange={(event, newValue) => {
                          setValue(newValue);
                        }}
                      />
                    </Box>
                    <div className="col-12 mt-4">
                      <TextAreaField
                        label="Give Reviews"
                        error={formState.errors['review_data']}
                        registration={register('review_data')}
                      />
                    </div>

                    <div className="row">
                      <div className="col-6 col-sm-6 rightAlignButton">
                        <Button onClick={() => navigate(`/user/my-deals`)}>
                          {' '}
                          {i18next.t(`Cancel`)}
                        </Button>
                      </div>
                      <div className="col-6 col-sm-6 leftAlignButton">
                        <Button isLoading={loading} type="submit">
                          {' '}
                          Send
                        </Button>
                      </div>
                    </div>
                  </div>
                </div>
              )}
            </Form>
          </div>
        </section>
      </Modal>
      <br />
      <Footer />
    </>
  );
};
