import Footer from '@/components/Layout/Footer/Footer';
import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import * as z from 'zod';
import { Button } from '@/components/Elements';
import { RadioButtonField, Form, InputField, SelectField, TextAreaField } from '@/components/Form';
import UserHeadBar from '../../components/UserHeadBar';
import './Contracts.css';
import masterCard from '@/assets/masterCard.png';
import card1 from '@/assets/card1.png';
import card2 from '@/assets/card2.png';
import card3 from '@/assets/card3.png';
import card4 from '@/assets/card4.png';
import card5 from '@/assets/card5.png';
import card6 from '@/assets/card6.png';
import card7 from '@/assets/card7.png';
import Months from '@/constants/months';
import Checkbox from '@mui/material/Checkbox';
import FormControlLabel from '@mui/material/FormControlLabel';
import Box from '@mui/material/Box';
import Rating from '@mui/material/Rating';
import 'react-responsive-modal/styles.css';
import { Modal } from 'react-responsive-modal';
import storage from '@/utils/storage';

import { useNotificationStore } from '@/stores/notifications';
import BackdropLoader from '@/components/Elements/Loader/BackdropLoader';
import successs from '@/assets/successs.svg';
import { axios } from '@/lib/axios';
import i18next from 'i18next';
const schema3 = z.object({
  // rating_data: z.string().min(1, 'Please enter data datda'),
  review_data: z.string().min(1, 'Please enter data'),
});

type HouseRentFormValues = {
  rating_data: string;
  review_data: string;
  receive_customer_id: string;
};

export const PaymentContract = () => {
  const searchParams = new URLSearchParams(document.location.search);
  const contract_id = searchParams.get('id');
  const [value, setValue] = useState<number | null>(2);
  const [propertyId, setPropertyId] = useState();
  const [amount, setAmount] = useState(0.0);

  const payment_mode = 'Online';
  const token = storage.getToken();
  const [open, setOpen] = useState(false);
  const onOpenModal = () => setOpen(true);
  const onCloseModal = () => setOpen(false);
  const [loading, setLoading] = useState<boolean>(false);
  const navigate = useNavigate();
  const handleNavigate = () => {
    navigate('/user/my-deals');
  };
  const schema = z.object({
    msg: z.string().min(1, 'Enter full name.'),
    user_level: z.string().min(1, 'Please select one option.'),
    user_level2: z.string().min(1, 'Please select one option.'),
    active: z.string().min(1, 'Please select one option.'),
    card_number: z.string().min(1, 'Please enter card number.'),
    card_name: z.string().min(1, 'Please enter card name.'),
  });
  type ContactValues = {
    msg: string;
    active: string;
    card_number: string;
    card_name: string;
  };
  const schemas = z.object({
    card_number: z.string().min(1, 'Enter card number.'),
    card_name: z.string().min(1, 'Enter card name.'),
    cvc: z.string().min(1, 'Enter cvv'),
    months: z.string().min(1, 'Enter month'),
    year: z.string().min(1, 'Enter year'),
  });
  type CardValues = {
    card_number: string;
    card_name: string;
    cvc: string;
    months: string;
    year: string;
  };

  const [open2, setOpen2] = useState(false);
  const onOpenModal2 = () => setOpen2(true);
  const onCloseModal2 = () => setOpen2(false);

  const [open3, setOpen3] = useState(false);
  const onOpenModal3 = () => setOpen3(true);
  const onCloseModal3 = () => setOpen3(false);

  const handleOr = () => {
    onOpenModal3();
    onCloseModal2();
  };

  const handleSubmit3 = async (values: HouseRentFormValues) => {
    try {
      setLoading(true);
      values.rating_data = value;
      values.receive_customer_id = propertyId;
      axios.post('/customer-api/add-rating-review', values);
      setLoading(false);
      onCloseModal3();
      navigate(`/user/my-deals`);
    } finally {
      setLoading(false);
      useNotificationStore.getState().addNotification({
        type: 'success',
        title: 'Success',
        message: 'Ratings sent successfully..',
      });
    }
  };
  const axiosUrl = process.env.REACT_APP_API_URL;

  const handleSubmit = async () => {
    setLoading(true);
    axios
      .post(`${axiosUrl}/customer-api/property_payment`, {
        contract_id,
        payment_mode,
      })
      .then((response) => {
        setLoading(false);
        onOpenModal2();
        const customer_id = response?.customer_id;
        // Now, you can store it in the PropertyId variable or use it as needed.
        setPropertyId(customer_id);
        useNotificationStore.getState().addNotification({
          type: 'success',
          title: 'Success',
          message: 'Payment record uploaded Susccessfully',
        });
        // navigate(`/user/purchase?id=${contract_id}`);
        // navigate(`/user/my-deals`);
      });
  };

  const [userLevel2, setUserLevel2] = useState('private_user');
  console.log(userLevel2);

  const handleLevelChange2 = (e: any) => {
    setUserLevel2(e.target.value);
  };
  return (
    <>
      <BackdropLoader open={loading} />
      <UserHeadBar />
      <button onClick={() => navigate(-1)}>
        <i className="fa-regular fa-circle-left go-back-button"></i>
      </button>
      <section className="container pays">
        <div className="payment-Methods">
          <h4>Payment Methods</h4>
          <div className="row">
            <div className="col-md-2 col-4 outer-card">
              <div className="card-box">
                <img src={card1} alt="CARD" />
              </div>
            </div>
            <div className="col-md-2 col-4 outer-card">
              <div className="card-box">
                <img src={card2} alt="CARD" />
              </div>
            </div>
            <div className="col-md-2 col-4 outer-card">
              <div className="card-box">
                <img src={card3} alt="CARD" />
              </div>
            </div>
            <div className="col-md-2 col-4 outer-card">
              <div className="card-box">
                <img src={card4} alt="CARD" />
              </div>
            </div>
            <div className="col-md-2 col-4 outer-card">
              <div className="card-box">
                <img src={card5} alt="CARD" />
              </div>
            </div>
            <div className="col-md-2 col-4 outer-card">
              <div className="card-box">
                <img src={card6} alt="CARD" />
              </div>
            </div>
            <div className="col-md-2 col-4 outer-card">
              <form action="https://www.escrow.com/checkout" method="post" target="_blank">
                <input type="hidden" name="type" value="domain_name" />
                <input type="hidden" name="non_initiator_email" value="info@bobben.no" />
                <input type="hidden" name="non_initiator_id" value="2972143" />
                <input type="hidden" name="non_initiator_role" value="seller" />
                <input type="hidden" name="title" value="Buy" />
                <input type="hidden" name="currency" value="USD" />
                <input type="hidden" name="domain" value="http://localhost:3000/" />
                <input type="hidden" name="price" value={amount ?? 0} />
                <input type="hidden" name="concierge" value="false" />
                <input type="hidden" name="with_content" value="false" />
                <input type="hidden" name="inspection_period" value="1" />
                <input type="hidden" name="fee_payer" value="seller" />
                <input type="hidden" name="return_url" value="http://localhost:3000/" />
                <input type="hidden" name="button_types" value="buy_now" />
                <input type="hidden" name="auto_accept" value="" />
                <input type="hidden" name="auto_reject" value="" />
                <input type="hidden" name="item_key" value="undefined" />
                <button className="btn-escrow" type="submit" style={{ width: '100%' }}>
                  <div className="card-box">
                    {' '}
                    <img src={card7} alt="CARD" />
                  </div>
                </button>
                <img
                  src={`https://t.escrow.com/1px.gif?name=bin&price=${
                    amount ?? 0
                  }&title=Buy&user_id=2972143`}
                  style={{ display: 'none' }}
                  alt=""
                />
              </form>
            </div>
          </div>
        </div>
        <h4>Pay With Cards</h4>
        <div className="row hed">
          <div className="col-md-6 col-12">
            <h3>
              <i className="fa-regular fa-credit-card"></i> Pay With Debit /Credit Cards
            </h3>
          </div>
          <div className="col-md-6 col-12 lift">
            {/* <button className="add-card-btn" onClick={onOpenModal}>
              + Add Card
            </button> */}
          </div>
        </div>
        <div className="add-model">
          <Modal open={open} onClose={onCloseModal}>
            <button className="closeButton" onClick={onCloseModal}>
              <i className="fa-solid fa-circle-xmark"></i>
            </button>
            <section className="model-data">
              <h4>Add Credit Card</h4>
              <Form<CardValues, typeof schemas> onSubmit={handleSubmit} schema={schemas}>
                {({ register, formState }) => (
                  <>
                    <div className=" addCard">
                      <InputField
                        type="number"
                        label="Card number"
                        error={formState.errors['card_number']}
                        registration={register('card_number')}
                      />
                      <InputField
                        type="text"
                        label="Card Name"
                        error={formState.errors['card_name']}
                        registration={register('card_name')}
                      />{' '}
                      <p>Expiration date</p>
                      <div className="row">
                        <div className="col-4 col-md-4">
                          <SelectField
                            label="MM"
                            error={formState.errors['months']}
                            registration={register('months')}
                            placeholder="MM"
                            options={Object.entries(Months).map(([key, value]) => ({
                              label: value,
                              value: key,
                            }))}
                          />
                        </div>
                        {/* <div className="col-4 col-md-4">
                          <SelectField
                            label="YYY"
                            error={formState.errors['year']}
                            registration={register('year')}
                            placeholder="MM"
                            options={Object.entries(Months).map(([key, value]) => ({
                              label: value,
                              value: key,
                            }))}
                          />
                        </div> */}
                        <div className="col-4 col-md-4">
                          <InputField
                            label="Year"
                            type="number"
                            error={formState.errors['year']}
                            registration={register('year')}
                          />
                        </div>
                        <div className="col-4 col-md-4">
                          <InputField
                            label="CVC"
                            type="number"
                            error={formState.errors['cvc']}
                            registration={register('cvc')}
                          />
                        </div>
                      </div>
                    </div>
                    <FormControlLabel control={<Checkbox />} label="Mark as Default card" />
                    <div className="btn-btn">
                      <Button type="submit">Add Card</Button>
                    </div>
                  </>
                )}
              </Form>
            </section>
          </Modal>
        </div>

        <Form<ContactValues, typeof schema> onSubmit={handleSubmit} schema={schema}>
          {({ register, formState }) => (
            <>
              <div className=" contrt">
                <div className="bOx Mbox">
                  <div className="row roww">
                    <div className="col-md-2 col-2 div-left">
                      <RadioButtonField
                        value="active"
                        registration={register('active', {
                          onChange: handleLevelChange2,
                          value: 'active',
                        })}
                        error={formState.errors['active']}
                      />
                    </div>
                    <div
                      // onClick={handleNavigate}
                      // onKeyDown={handleNavigate}
                      role="button"
                      tabIndex={-1}
                      className="col-md-8 col-8 div-mid"
                    >
                      **** **** **** 5677
                    </div>
                    <div className="col-md-2 col-2 div-right">
                      <img src={masterCard} alt="as" />
                    </div>
                  </div>
                </div>
                <div className="bOx Mbox">
                  <div className="row roww">
                    <div className="col-md-2 col-2 div-left">
                      <RadioButtonField
                        value="active"
                        registration={register('active', {
                          onChange: handleLevelChange2,
                          value: 'active',
                        })}
                        error={formState.errors['active']}
                      />
                    </div>

                    <div
                      // onClick={handleNavigate}
                      // onKeyDown={handleNavigate}
                      role="button"
                      tabIndex={-1}
                      className="col-md-8 col-8 div-mid"
                    >
                      **** **** **** 5677
                    </div>
                    <div className="col-md-2 col-2 div-right">
                      <img src={masterCard} alt="as" />
                    </div>
                  </div>
                </div>
              </div>
              <div className="btn-btn">
                <Button onClick={handleSubmit} type="submit">
                  Complete Payment
                </Button>
              </div>
            </>
          )}
        </Form>
      </section>
      <br />
      <Modal open={open2} onClose={onCloseModal2} center>
        <section className="review-modelss">
          <div className="row">
            <h3 className="sselect">Payment Completed Successfully</h3>
            <p className="sselect">
              <img src={successs} alt="success" />
            </p>

            <div className="row">
              <div className="col-6 col-sm-6 rightAlignButton">
                <Button onClick={() => navigate('/user/my-deals')}> {i18next.t(`Cancel`)}</Button>
              </div>
              <div className="col-6 col-sm-6 leftAlignButton">
                <Button onClick={() => handleOr()}>Give Review</Button>
              </div>
            </div>
          </div>
        </section>
      </Modal>
      {/* =============================================================== */}
      <Modal open={open3} onClose={onCloseModal3} center>
        <section className="review-modelss">
          <div className="row">
            <h3 className="sselect">Share your Review and Ratings here.</h3>

            <Form<HouseRentFormValues, typeof schema3> onSubmit={handleSubmit3} schema={schema3}>
              {({ register, formState }) => (
                <div className=" mb-5">
                  <div className="row mt-4">
                    <Box
                      sx={{
                        '& > legend': { mt: 2 },
                      }}
                    >
                      <Rating
                        name="simple-controlled"
                        value={value}
                        onChange={(event, newValue) => {
                          setValue(newValue);
                        }}
                      />
                    </Box>
                    <div className="col-12 mt-4">
                      <TextAreaField
                        label="Give Reviews"
                        error={formState.errors['review_data']}
                        registration={register('review_data')}
                      />
                    </div>

                    <div className="row">
                      <div className="col-6 col-sm-6 rightAlignButton">
                        <Button onClick={() => navigate(`/user/my-deals`)}>
                          {' '}
                          {i18next.t(`Cancel`)}
                        </Button>
                      </div>
                      <div className="col-6 col-sm-6 leftAlignButton">
                        <Button isLoading={loading} type="submit">
                          {' '}
                          Send
                        </Button>
                      </div>
                    </div>
                  </div>
                </div>
              )}
            </Form>
          </div>
        </section>
      </Modal>
      <Footer />
    </>
  );
};
